/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal.logging;

import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogLevel;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class AbstractInternalLogger
implements InternalLogger,
Serializable {
    private static final long serialVersionUID = -6382972526573193470L;
    private final String name;

    protected AbstractInternalLogger(String string) {
        this.name = ObjectUtil.checkNotNull(string, "name");
    }

    public String name() {
        return this.name;
    }

    public boolean isEnabled(InternalLogLevel internalLogLevel) {
        switch (internalLogLevel) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error();
    }

    public void log(InternalLogLevel internalLogLevel, String string, Object object, Object object2) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, object, object2);
                return;
            }
            case DEBUG: {
                this.debug(string, object, object2);
                return;
            }
            case INFO: {
                this.info(string, object, object2);
                return;
            }
            case WARN: {
                this.warn(string, object, object2);
                return;
            }
            case ERROR: {
                this.error(string, object, object2);
                return;
            }
        }
        throw new Error();
    }

    public void log(InternalLogLevel internalLogLevel, String string, Object ... objectArray) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, objectArray);
                return;
            }
            case DEBUG: {
                this.debug(string, objectArray);
                return;
            }
            case INFO: {
                this.info(string, objectArray);
                return;
            }
            case WARN: {
                this.warn(string, objectArray);
                return;
            }
            case ERROR: {
                this.error(string, objectArray);
                return;
            }
        }
        throw new Error();
    }

    protected Object readResolve() throws ObjectStreamException {
        return InternalLoggerFactory.getInstance(this.name());
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.name() + ')';
    }
}

