/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import com.appoptics.ext.io.netty.util.internal.InternalThreadLocalMap;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtil {
    public static final String NEWLINE = SystemPropertyUtil.get("line.separator", "\n");
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final byte[] HEX2B;

    private StringUtil() {
    }

    public static String byteToHexStringPadded(int n2) {
        return BYTE2HEX_PAD[n2 & 0xFF];
    }

    public static int decodeHexNibble(char c2) {
        assert (HEX2B.length == 65536);
        return HEX2B[c2];
    }

    public static byte decodeHexByte(CharSequence charSequence, int n2) {
        int n3 = StringUtil.decodeHexNibble(charSequence.charAt(n2));
        int n4 = StringUtil.decodeHexNibble(charSequence.charAt(n2 + 1));
        if (n3 == -1 || n4 == -1) {
            Object[] objectArray = new Object[3];
            int n5 = n2;
            objectArray[0] = charSequence.subSequence(n5, n5 + 2);
            objectArray[1] = n2;
            objectArray[2] = charSequence;
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", objectArray));
        }
        return (byte)((n3 << 4) + n4);
    }

    public static String simpleClassName(Object object) {
        if (object == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(object.getClass());
    }

    public static String simpleClassName(Class<?> object) {
        int n2 = ((String)(object = ObjectUtil.checkNotNull(object, "clazz").getName())).lastIndexOf(46);
        if (n2 >= 0) {
            return ((String)object).substring(n2 + 1);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence escapeCsv(CharSequence charSequence, boolean c2) {
        void var3_13;
        int n2;
        void var3_9;
        void var1_5;
        void var1_4;
        int n3 = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (c2 != '\u0000') {
            int n4 = StringUtil.indexOfFirstNonOwsChar(charSequence, n3);
            n3 = StringUtil.indexOfLastNonOwsChar(charSequence, n4, n3);
        } else {
            boolean bl = false;
            --n3;
        }
        if (var1_4 > n3) {
            return "";
        }
        int n5 = -1;
        boolean bl = false;
        if (StringUtil.isDoubleQuote(charSequence.charAt((int)var1_4))) {
            bl = StringUtil.isDoubleQuote(charSequence.charAt(n3)) && n3 > var1_4;
            if (bl) {
                ++var1_5;
                --n3;
            } else {
                var3_9 = var1_4;
            }
        }
        if (var3_9 < 0) {
            void var5_15;
            if (bl) {
                for (var5_15 = var1_5; var5_15 <= n3; ++var5_15) {
                    if (!StringUtil.isDoubleQuote(charSequence.charAt((int)var5_15))) continue;
                    if (var5_15 == n3 || !StringUtil.isDoubleQuote(charSequence.charAt((int)(var5_15 + true)))) {
                        void var3_10 = var5_15;
                        break;
                    }
                    ++var5_15;
                }
            } else {
                for (var5_15 = var1_5; var5_15 <= n3; ++var5_15) {
                    n2 = charSequence.charAt((int)var5_15);
                    if (n2 == 10 || n2 == 13 || n2 == 44) {
                        void var3_11 = var5_15;
                        break;
                    }
                    if (!StringUtil.isDoubleQuote((char)n2)) continue;
                    if (var5_15 == n3 || !StringUtil.isDoubleQuote(charSequence.charAt((int)(var5_15 + true)))) {
                        void var3_12 = var5_15;
                        break;
                    }
                    ++var5_15;
                }
            }
            if (var3_13 < 0) {
                if (bl) {
                    return charSequence.subSequence((int)(var1_5 - true), n3 + 2);
                }
                return charSequence.subSequence((int)var1_5, n3 + 1);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - var1_5 + 1 + 7);
        stringBuilder.append('\"').append(charSequence, (int)var1_5, (int)var3_13);
        for (n2 = var3_13; n2 <= n3; ++n2) {
            char c3 = charSequence.charAt(n2);
            if (StringUtil.isDoubleQuote(c3)) {
                stringBuilder.append('\"');
                if (n2 < n3 && StringUtil.isDoubleQuote(charSequence.charAt(n2 + 1))) {
                    ++n2;
                }
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.append('\"');
    }

    public static List<CharSequence> unescapeCsvFields(CharSequence charSequence) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(2);
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        boolean bl = false;
        int n2 = charSequence.length() - 1;
        block8: for (int i2 = 0; i2 <= n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (bl) {
                switch (c2) {
                    case '\"': {
                        if (i2 == n2) {
                            arrayList.add(stringBuilder.toString());
                            return arrayList;
                        }
                        if ((c2 = charSequence.charAt(++i2)) == '\"') {
                            stringBuilder.append('\"');
                            break;
                        }
                        if (c2 == ',') {
                            bl = false;
                            arrayList.add(stringBuilder.toString());
                            stringBuilder.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2 - 1);
                    }
                    default: {
                        stringBuilder.append(c2);
                        break;
                    }
                }
                continue;
            }
            switch (c2) {
                case ',': {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue block8;
                }
                case '\"': {
                    if (stringBuilder.length() == 0) {
                        bl = true;
                        continue block8;
                    }
                }
                case '\n': 
                case '\r': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2);
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        if (bl) {
            throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, n2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence charSequence, int n2) {
        return new IllegalArgumentException("invalid escaped CSV field: " + charSequence + " index: " + n2);
    }

    public static int length(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udfff';
    }

    private static boolean isDoubleQuote(char c2) {
        return c2 == '\"';
    }

    public static CharSequence trimOws(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 == 0) {
            return charSequence;
        }
        int n3 = StringUtil.indexOfFirstNonOwsChar(charSequence, n2);
        int n4 = StringUtil.indexOfLastNonOwsChar(charSequence, n3, n2);
        if (n3 == 0 && n4 == n2 - 1) {
            return charSequence;
        }
        return charSequence.subSequence(n3, n4 + 1);
    }

    private static int indexOfFirstNonOwsChar(CharSequence charSequence, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 && StringUtil.isOws(charSequence.charAt(n3)); ++n3) {
        }
        return n3;
    }

    private static int indexOfLastNonOwsChar(CharSequence charSequence, int n2, int n3) {
        --n3;
        while (n3 > n2 && StringUtil.isOws(charSequence.charAt(n3))) {
            --n3;
        }
        return n3;
    }

    private static boolean isOws(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    static {
        for (int i2 = 0; i2 < BYTE2HEX_PAD.length; ++i2) {
            String string = Integer.toHexString(i2);
            int n2 = i2;
            StringUtil.BYTE2HEX_PAD[n2] = n2 > 15 ? string : "0" + string;
            StringUtil.BYTE2HEX_NOPAD[i2] = string;
        }
        HEX2B = new byte[65536];
        Arrays.fill(HEX2B, (byte)-1);
        StringUtil.HEX2B[48] = 0;
        StringUtil.HEX2B[49] = 1;
        StringUtil.HEX2B[50] = 2;
        StringUtil.HEX2B[51] = 3;
        StringUtil.HEX2B[52] = 4;
        StringUtil.HEX2B[53] = 5;
        StringUtil.HEX2B[54] = 6;
        StringUtil.HEX2B[55] = 7;
        StringUtil.HEX2B[56] = 8;
        StringUtil.HEX2B[57] = 9;
        StringUtil.HEX2B[65] = 10;
        StringUtil.HEX2B[66] = 11;
        StringUtil.HEX2B[67] = 12;
        StringUtil.HEX2B[68] = 13;
        StringUtil.HEX2B[69] = 14;
        StringUtil.HEX2B[70] = 15;
        StringUtil.HEX2B[97] = 10;
        StringUtil.HEX2B[98] = 11;
        StringUtil.HEX2B[99] = 12;
        StringUtil.HEX2B[100] = 13;
        StringUtil.HEX2B[101] = 14;
        StringUtil.HEX2B[102] = 15;
    }
}

