/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal;

import java.util.Arrays;

public final class AppendableCharSequence
implements Appendable,
CharSequence {
    private char[] chars;
    private int pos;

    public AppendableCharSequence(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("length: " + n2 + " (length: >= 1)");
        }
        this.chars = new char[n2];
    }

    private AppendableCharSequence(char[] cArray) {
        if (cArray.length <= 0) {
            throw new IllegalArgumentException("length: " + cArray.length + " (length: >= 1)");
        }
        this.chars = cArray;
        this.pos = cArray.length;
    }

    public final void setLength(int n2) {
        if (n2 < 0 || n2 > this.pos) {
            throw new IllegalArgumentException("length: " + n2 + " (length: >= 0, <= " + this.pos + ')');
        }
        this.pos = n2;
    }

    public final int length() {
        return this.pos;
    }

    public final char charAt(int n2) {
        if (n2 > this.pos) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[n2];
    }

    public final char charAtUnsafe(int n2) {
        return this.chars[n2];
    }

    public final AppendableCharSequence subSequence(int n2, int n3) {
        if (n2 == n3) {
            return new AppendableCharSequence(Math.min(16, this.chars.length));
        }
        return new AppendableCharSequence(Arrays.copyOfRange(this.chars, n2, n3));
    }

    public final AppendableCharSequence append(char c2) {
        if (this.pos == this.chars.length) {
            char[] cArray = this.chars;
            this.chars = new char[cArray.length << 1];
            System.arraycopy(cArray, 0, this.chars, 0, cArray.length);
        }
        this.chars[this.pos++] = c2;
        return this;
    }

    public final AppendableCharSequence append(CharSequence charSequence) {
        return this.append(charSequence, 0, charSequence.length());
    }

    public final AppendableCharSequence append(CharSequence object, int n2, int n3) {
        if (object.length() < n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        if (n4 > this.chars.length - this.pos) {
            this.chars = AppendableCharSequence.expand(this.chars, this.pos + n4, this.pos);
        }
        if (object instanceof AppendableCharSequence) {
            AppendableCharSequence appendableCharSequence = (AppendableCharSequence)object;
            object = appendableCharSequence.chars;
            System.arraycopy(appendableCharSequence.chars, n2, this.chars, this.pos, n4);
            this.pos += n4;
            return this;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            this.chars[this.pos++] = object.charAt(i2);
        }
        return this;
    }

    public final void reset() {
        this.pos = 0;
    }

    public final String toString() {
        return new String(this.chars, 0, this.pos);
    }

    public final String subStringUnsafe(int n2, int n3) {
        return new String(this.chars, n2, n3 - n2);
    }

    private static char[] expand(char[] cArray, int n2, int n3) {
        int n4 = cArray.length;
        do {
            if ((n4 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n2 > n4);
        char[] cArray2 = new char[n4];
        System.arraycopy(cArray, 0, cArray2, 0, n3);
        return cArray2;
    }
}

