/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.AbstractEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.DefaultPromise;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutorGroup;
import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GlobalEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.OrderedEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Promise;
import com.appoptics.ext.io.netty.util.concurrent.RejectedExecutionHandler;
import com.appoptics.ext.io.netty.util.concurrent.ScheduledFutureTask;
import com.appoptics.ext.io.netty.util.concurrent.ThreadProperties;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.ThreadExecutorMap;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleThreadEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    static final int DEFAULT_MAX_PENDING_EXECUTOR_TASKS = Math.max(16, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.eventexecutor.maxPendingTasks", Integer.MAX_VALUE));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final Runnable NOOP_TASK = new Runnable(){

        public final void run() {
        }
    };
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "state");
    private static final AtomicReferenceFieldUpdater<SingleThreadEventExecutor, ThreadProperties> PROPERTIES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleThreadEventExecutor.class, ThreadProperties.class, "threadProperties");
    private final Queue<Runnable> taskQueue;
    private volatile Thread thread;
    private volatile ThreadProperties threadProperties;
    private final Executor executor;
    private volatile boolean interrupted;
    private final CountDownLatch threadLock = new CountDownLatch(1);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private final int maxPendingTasks;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, Executor executor, boolean bl, Queue<Runnable> queue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventExecutorGroup);
        this.addTaskWakesUp = bl;
        this.maxPendingTasks = DEFAULT_MAX_PENDING_EXECUTOR_TASKS;
        this.executor = ThreadExecutorMap.apply(executor, (EventExecutor)this);
        this.taskQueue = ObjectUtil.checkNotNull(queue, "taskQueue");
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedExecutionHandler, "rejectedHandler");
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        return SingleThreadEventExecutor.pollTaskFrom(this.taskQueue);
    }

    protected static Runnable pollTaskFrom(Queue<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) == WAKEUP_TASK) {
        }
        return runnable;
    }

    private boolean fetchFromScheduledTaskQueue() {
        Runnable runnable;
        if (this.scheduledTaskQueue == null || this.scheduledTaskQueue.isEmpty()) {
            return true;
        }
        long l2 = AbstractScheduledEventExecutor.nanoTime();
        do {
            if ((runnable = this.pollScheduledTask(l2)) != null) continue;
            return true;
        } while (this.taskQueue.offer(runnable));
        this.scheduledTaskQueue.add((ScheduledFutureTask)runnable);
        return false;
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    protected void addTask(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "task");
        if (!this.offerTask(runnable)) {
            this.reject(runnable);
        }
    }

    final boolean offerTask(Runnable runnable) {
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        return this.taskQueue.offer(runnable);
    }

    protected boolean removeTask(Runnable runnable) {
        return this.taskQueue.remove(ObjectUtil.checkNotNull(runnable, "task"));
    }

    protected boolean runAllTasks() {
        boolean bl;
        assert (this.inEventLoop());
        boolean bl2 = false;
        do {
            bl = this.fetchFromScheduledTaskQueue();
            SingleThreadEventExecutor singleThreadEventExecutor = this;
            if (!singleThreadEventExecutor.runAllTasksFrom(singleThreadEventExecutor.taskQueue)) continue;
            bl2 = true;
        } while (!bl);
        if (bl2) {
            this.lastExecutionTime = ScheduledFutureTask.nanoTime();
        }
        this.afterRunningAllTasks();
        return bl2;
    }

    protected final boolean runAllTasksFrom(Queue<Runnable> queue) {
        Runnable runnable = SingleThreadEventExecutor.pollTaskFrom(queue);
        if (runnable == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(runnable);
        } while ((runnable = SingleThreadEventExecutor.pollTaskFrom(queue)) != null);
        return true;
    }

    protected boolean runAllTasks(long l2) {
        long l3;
        block2: {
            this.fetchFromScheduledTaskQueue();
            Runnable runnable = this.pollTask();
            if (runnable == null) {
                this.afterRunningAllTasks();
                return false;
            }
            long l4 = l2 > 0L ? ScheduledFutureTask.nanoTime() + l2 : 0L;
            long l5 = 0L;
            do {
                SingleThreadEventExecutor.safeExecute(runnable);
                if ((++l5 & 0x3FL) == 0L && (l3 = ScheduledFutureTask.nanoTime()) >= l4) break block2;
            } while ((runnable = this.pollTask()) != null);
            l3 = ScheduledFutureTask.nanoTime();
        }
        this.afterRunningAllTasks();
        this.lastExecutionTime = l3;
        return true;
    }

    protected void afterRunningAllTasks() {
    }

    protected void updateLastExecutionTime() {
        this.lastExecutionTime = ScheduledFutureTask.nanoTime();
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean bl) {
        if (!bl) {
            this.taskQueue.offer(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    private boolean runShutdownHooks() {
        boolean bl = false;
        while (!this.shutdownHooks.isEmpty()) {
            Object object = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            object = object.iterator();
            while (object.hasNext()) {
                Runnable runnable = (Runnable)object.next();
                try {
                    runnable.run();
                    bl = true;
                }
                catch (Throwable throwable) {
                    logger.warn("Shutdown hook raised an exception.", throwable);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.lastExecutionTime = ScheduledFutureTask.nanoTime();
        }
        return bl;
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        boolean bl;
        int n2;
        int n3;
        ObjectUtil.checkPositiveOrZero(l2, "quietPeriod");
        if (l3 < l2) {
            throw new IllegalArgumentException("timeout: " + l3 + " (expected >= quietPeriod (" + l2 + "))");
        }
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (this.isShuttingDown()) {
            return this.terminationFuture();
        }
        boolean bl2 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return this.terminationFuture();
            }
            bl = true;
            n3 = this.state;
            if (bl2) {
                n2 = 3;
                continue;
            }
            switch (n3) {
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = n3;
                    bl = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n3, n2));
        this.gracefulShutdownQuietPeriod = timeUnit.toNanos(l2);
        this.gracefulShutdownTimeout = timeUnit.toNanos(l3);
        if (this.ensureThreadStarted(n3)) {
            return this.terminationFuture;
        }
        if (bl) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(bl2);
            }
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        boolean bl;
        int n2;
        int n3;
        if (this.isShutdown()) {
            return;
        }
        boolean bl2 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return;
            }
            bl = true;
            n3 = this.state;
            if (bl2) {
                n2 = 4;
                continue;
            }
            switch (n3) {
                case 1: 
                case 2: 
                case 3: {
                    n2 = 4;
                    break;
                }
                default: {
                    n2 = n3;
                    bl = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n3, n2));
        if (this.ensureThreadStarted(n3)) {
            return;
        }
        if (bl) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(bl2);
            }
        }
    }

    public boolean isShuttingDown() {
        return this.state >= 3;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 5;
    }

    protected boolean confirmShutdown() {
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelScheduledTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = ScheduledFutureTask.nanoTime();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            if (this.gracefulShutdownQuietPeriod == 0L) {
                return true;
            }
            this.taskQueue.offer(WAKEUP_TASK);
            return false;
        }
        long l2 = ScheduledFutureTask.nanoTime();
        if (this.isShutdown() || l2 - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (l2 - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.taskQueue.offer(WAKEUP_TASK);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) throws InterruptedException {
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        this.threadLock.await(l2, timeUnit);
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "task");
        Runnable runnable2 = runnable;
        this.execute(runnable2, !(runnable2 instanceof AbstractEventExecutor.LazyRunnable) && this.wakesUpForTask(runnable));
    }

    @Override
    public void lazyExecute(Runnable runnable) {
        this.execute(ObjectUtil.checkNotNull(runnable, "task"), false);
    }

    private void execute(Runnable runnable, boolean bl) {
        boolean bl2 = this.inEventLoop();
        this.addTask(runnable);
        if (!bl2) {
            this.startThread();
            if (this.isShutdown()) {
                boolean bl3 = false;
                try {
                    if (this.removeTask(runnable)) {
                        bl3 = true;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                if (bl3) {
                    SingleThreadEventExecutor.reject();
                }
            }
        }
        if (!this.addTaskWakesUp && bl) {
            this.wakeup(bl2);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection, l2, timeUnit);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection, l2, timeUnit);
    }

    private void throwIfInEventLoop(String string) {
        if (this.inEventLoop()) {
            throw new RejectedExecutionException("Calling " + string + " from within the EventLoop is not allowed");
        }
    }

    protected boolean wakesUpForTask(Runnable runnable) {
        return true;
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    protected final void reject(Runnable runnable) {
        this.rejectedExecutionHandler.rejected(runnable, this);
    }

    private void startThread() {
        if (this.state == 1 && STATE_UPDATER.compareAndSet(this, 1, 2)) {
            try {
                this.doStartThread();
                return;
            }
            catch (Throwable throwable) {
                STATE_UPDATER.compareAndSet(this, 2, 1);
                throw throwable;
            }
        }
    }

    private boolean ensureThreadStarted(int n2) {
        if (n2 == 1) {
            try {
                this.doStartThread();
            }
            catch (Throwable throwable) {
                STATE_UPDATER.set(this, 5);
                this.terminationFuture.tryFailure(throwable);
                if (!(throwable instanceof Exception)) {
                    PlatformDependent.throwException(throwable);
                }
                return true;
            }
        }
        return false;
    }

    private void doStartThread() {
        assert (this.thread == null);
        this.executor.execute(new Runnable(){

            /*
             * Loose catch block
             */
            public void run() {
                int n2;
                SingleThreadEventExecutor.this.thread = Thread.currentThread();
                if (SingleThreadEventExecutor.this.interrupted) {
                    SingleThreadEventExecutor.this.thread.interrupt();
                }
                SingleThreadEventExecutor.this.updateLastExecutionTime();
                SingleThreadEventExecutor.this.run();
                while ((n2 = SingleThreadEventExecutor.this.state) < 3 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n2, 3)) {
                }
                if (SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                    logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                }
                try {
                    while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                    }
                    while ((n2 = SingleThreadEventExecutor.this.state) < 4 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n2, 4)) {
                    }
                    SingleThreadEventExecutor.this.confirmShutdown();
                }
                finally {
                    try {
                        SingleThreadEventExecutor.this.cleanup();
                    }
                    finally {
                        FastThreadLocal.removeAll();
                        STATE_UPDATER.set(SingleThreadEventExecutor.this, 5);
                        SingleThreadEventExecutor.this.threadLock.countDown();
                        n2 = SingleThreadEventExecutor.this.drainTasks();
                        if (n2 > 0 && logger.isWarnEnabled()) {
                            logger.warn("An event executor terminated with non-empty task queue (" + n2 + ')');
                        }
                        SingleThreadEventExecutor.this.terminationFuture.setSuccess(null);
                    }
                }
                return;
                catch (Throwable throwable) {
                    try {
                        logger.warn("Unexpected exception from an event executor: ", throwable);
                    }
                    catch (Throwable throwable2) {}
                    finally {
                        int n3;
                        while ((n3 = SingleThreadEventExecutor.this.state) < 3 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n3, 3)) {
                        }
                        while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                        }
                        while ((n3 = SingleThreadEventExecutor.this.state) < 4 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n3, 4)) {
                        }
                        SingleThreadEventExecutor.this.confirmShutdown();
                    }
                }
            }
        });
    }

    final int drainTasks() {
        Runnable runnable;
        int n2 = 0;
        while ((runnable = this.taskQueue.poll()) != null) {
            if (WAKEUP_TASK == runnable) continue;
            ++n2;
        }
        return n2;
    }
}

