/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.PromiseTask;
import com.appoptics.ext.io.netty.util.concurrent.ScheduledFuture;
import com.appoptics.ext.io.netty.util.internal.DefaultPriorityQueue;
import com.appoptics.ext.io.netty.util.internal.PriorityQueueNode;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ScheduledFutureTask<V>
extends PromiseTask<V>
implements ScheduledFuture<V>,
PriorityQueueNode {
    private static final long START_TIME = System.nanoTime();
    private long id;
    private long deadlineNanos;
    private final long periodNanos;
    private int queueIndex = -1;

    static long nanoTime() {
        return System.nanoTime() - START_TIME;
    }

    static long deadlineNanos(long l2) {
        long l3 = ScheduledFutureTask.nanoTime() + l2;
        if (l3 < 0L) {
            return Long.MAX_VALUE;
        }
        return l3;
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, long l2) {
        super((EventExecutor)abstractScheduledEventExecutor, runnable);
        this.deadlineNanos = l2;
        this.periodNanos = 0L;
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, long l2, long l3) {
        super((EventExecutor)abstractScheduledEventExecutor, runnable);
        this.deadlineNanos = l2;
        this.periodNanos = ScheduledFutureTask.validatePeriod(l3);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l2, long l3) {
        super((EventExecutor)abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l2;
        this.periodNanos = ScheduledFutureTask.validatePeriod(l3);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l2) {
        super((EventExecutor)abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l2;
        this.periodNanos = 0L;
    }

    private static long validatePeriod(long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("period: 0 (expected: != 0)");
        }
        return l2;
    }

    final ScheduledFutureTask<V> setId(long l2) {
        if (this.id == 0L) {
            this.id = l2;
        }
        return this;
    }

    @Override
    protected final EventExecutor executor() {
        return super.executor();
    }

    public final long deadlineNanos() {
        return this.deadlineNanos;
    }

    final void setConsumed() {
        if (this.periodNanos == 0L) {
            assert (ScheduledFutureTask.nanoTime() >= this.deadlineNanos);
            this.deadlineNanos = 0L;
        }
    }

    public final long delayNanos() {
        return ScheduledFutureTask.deadlineToDelayNanos(this.deadlineNanos());
    }

    static long deadlineToDelayNanos(long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        return Math.max(0L, l2 - ScheduledFutureTask.nanoTime());
    }

    @Override
    public final long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.delayNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public final int compareTo(Delayed delayed) {
        if (this == delayed) {
            return 0;
        }
        delayed = (ScheduledFutureTask)delayed;
        long l2 = this.deadlineNanos() - ((ScheduledFutureTask)delayed).deadlineNanos();
        if (l2 < 0L) {
            return -1;
        }
        if (l2 > 0L) {
            return 1;
        }
        if (this.id < ((ScheduledFutureTask)delayed).id) {
            return -1;
        }
        assert (this.id != ((ScheduledFutureTask)delayed).id);
        return 1;
    }

    @Override
    public final void run() {
        assert (this.executor().inEventLoop());
        try {
            block10: {
                block9: {
                    block8: {
                        if (this.delayNanos() > 0L) {
                            if (this.isCancelled()) {
                                this.scheduledExecutor().scheduledTaskQueue().removeTyped(this);
                                return;
                            }
                            this.scheduledExecutor().scheduleFromEventLoop(this);
                            return;
                        }
                        if (this.periodNanos != 0L) break block8;
                        if (!this.setUncancellableInternal()) break block9;
                        break block10;
                    }
                    if (!this.isCancelled()) {
                        this.runTask();
                        if (!this.executor().isShutdown()) {
                            this.deadlineNanos = this.periodNanos > 0L ? (this.deadlineNanos += this.periodNanos) : ScheduledFutureTask.nanoTime() - this.periodNanos;
                            if (!this.isCancelled()) {
                                this.scheduledExecutor().scheduledTaskQueue().add(this);
                            }
                        }
                    }
                }
                return;
            }
            Object v2 = this.runTask();
            this.setSuccessInternal(v2);
        }
        catch (Throwable throwable) {
            this.setFailureInternal(throwable);
        }
    }

    private AbstractScheduledEventExecutor scheduledExecutor() {
        return (AbstractScheduledEventExecutor)this.executor();
    }

    @Override
    public final boolean cancel(boolean bl) {
        if (bl = super.cancel(bl)) {
            this.scheduledExecutor().removeScheduled(this);
        }
        return bl;
    }

    final boolean cancelWithoutRemove(boolean bl) {
        return super.cancel(bl);
    }

    @Override
    protected final StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = super.toStringBuilder();
        stringBuilder.setCharAt(stringBuilder.length() - 1, ',');
        return stringBuilder.append(" deadline: ").append(this.deadlineNanos).append(", period: ").append(this.periodNanos).append(')');
    }

    @Override
    public final int priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue) {
        return this.queueIndex;
    }

    @Override
    public final void priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue, int n2) {
        this.queueIndex = n2;
    }
}

