/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.AbstractEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.FailedFuture;
import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GlobalEventExecutor;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmediateEventExecutor
extends AbstractEventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ImmediateEventExecutor.class);
    public static final ImmediateEventExecutor INSTANCE = new ImmediateEventExecutor();
    private static final FastThreadLocal<Queue<Runnable>> DELAYED_RUNNABLES = new FastThreadLocal<Queue<Runnable>>(){

        @Override
        protected final Queue<Runnable> initialValue() throws Exception {
            return new ArrayDeque<Runnable>();
        }
    };
    private static final FastThreadLocal<Boolean> RUNNING = new FastThreadLocal<Boolean>(){

        @Override
        protected final Boolean initialValue() throws Exception {
            return Boolean.FALSE;
        }
    };
    private final Future<?> terminationFuture = new FailedFuture(GlobalEventExecutor.INSTANCE, new UnsupportedOperationException());

    private ImmediateEventExecutor() {
    }

    @Override
    public final boolean inEventLoop() {
        return true;
    }

    @Override
    public final boolean inEventLoop(Thread thread) {
        return true;
    }

    @Override
    public final Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        return this.terminationFuture();
    }

    @Override
    public final Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public final void shutdown() {
    }

    @Override
    public final boolean isShutdown() {
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return false;
    }

    @Override
    public final boolean awaitTermination(long l2, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public final void execute(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "command");
        if (!RUNNING.get().booleanValue()) {
            RUNNING.set(Boolean.TRUE);
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                logger.info("Throwable caught while executing Runnable {}", (Object)runnable, (Object)throwable);
            }
            finally {
                Queue<Runnable> queue = DELAYED_RUNNABLES.get();
                while ((runnable = queue.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        logger.info("Throwable caught while executing Runnable {}", (Object)runnable, (Object)throwable);
                    }
                }
                RUNNING.set(Boolean.FALSE);
            }
        } else {
            DELAYED_RUNNABLES.get().add(runnable);
        }
    }
}

