/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

final class FastThreadLocalRunnable
implements Runnable {
    private final Runnable runnable;

    private FastThreadLocalRunnable(Runnable runnable) {
        this.runnable = ObjectUtil.checkNotNull(runnable, "runnable");
    }

    public final void run() {
        try {
            this.runnable.run();
            return;
        }
        finally {
            FastThreadLocal.removeAll();
        }
    }

    static Runnable wrap(Runnable runnable) {
        if (runnable instanceof FastThreadLocalRunnable) {
            return runnable;
        }
        return new FastThreadLocalRunnable(runnable);
    }
}

