/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.concurrent;

import com.appoptics.ext.io.netty.util.concurrent.AbstractEventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutorGroup;
import com.appoptics.ext.io.netty.util.concurrent.ScheduledFuture;
import com.appoptics.ext.io.netty.util.concurrent.ScheduledFutureTask;
import com.appoptics.ext.io.netty.util.internal.DefaultPriorityQueue;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PriorityQueue;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    private static final Comparator<ScheduledFutureTask<?>> SCHEDULED_FUTURE_TASK_COMPARATOR = new Comparator<ScheduledFutureTask<?>>(){

        @Override
        public final int compare(ScheduledFutureTask<?> scheduledFutureTask, ScheduledFutureTask<?> scheduledFutureTask2) {
            return scheduledFutureTask.compareTo(scheduledFutureTask2);
        }
    };
    static final Runnable WAKEUP_TASK = new Runnable(){

        public final void run() {
        }
    };
    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue;
    long nextTaskId;

    protected AbstractScheduledEventExecutor() {
    }

    protected AbstractScheduledEventExecutor(EventExecutorGroup eventExecutorGroup) {
        super(eventExecutorGroup);
    }

    protected static long nanoTime() {
        return ScheduledFutureTask.nanoTime();
    }

    protected static long deadlineToDelayNanos(long l2) {
        return ScheduledFutureTask.deadlineToDelayNanos(l2);
    }

    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new DefaultPriorityQueue(SCHEDULED_FUTURE_TASK_COMPARATOR, 11);
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<ScheduledFutureTask<?>> queue) {
        return queue == null || queue.isEmpty();
    }

    protected void cancelScheduledTasks() {
        assert (this.inEventLoop());
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(priorityQueue)) {
            return;
        }
        ScheduledFutureTask[] scheduledFutureTaskArray = priorityQueue.toArray(new ScheduledFutureTask[0]);
        ScheduledFutureTask[] scheduledFutureTaskArray2 = scheduledFutureTaskArray;
        scheduledFutureTaskArray2 = scheduledFutureTaskArray;
        int n2 = scheduledFutureTaskArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ScheduledFutureTask scheduledFutureTask = scheduledFutureTaskArray2[i2];
            scheduledFutureTask.cancelWithoutRemove(false);
        }
        priorityQueue.clearIgnoringIndexes();
    }

    protected final Runnable pollScheduledTask(long l2) {
        assert (this.inEventLoop());
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask == null || scheduledFutureTask.deadlineNanos() - l2 > 0L) {
            return null;
        }
        this.scheduledTaskQueue.remove();
        scheduledFutureTask.setConsumed();
        return scheduledFutureTask;
    }

    protected final long nextScheduledTaskDeadlineNanos() {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask != null) {
            return scheduledFutureTask.deadlineNanos();
        }
        return -1L;
    }

    final ScheduledFutureTask<?> peekScheduledTask() {
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        if (priorityQueue != null) {
            return (ScheduledFutureTask)priorityQueue.peek();
        }
        return null;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.validateScheduled0(l2, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(callable, "callable");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.validateScheduled0(l2, timeUnit);
        return this.schedule(new ScheduledFutureTask<V>(this, callable, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l2));
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", l3));
        }
        this.validateScheduled0(l2, timeUnit);
        this.validateScheduled0(l3, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2)), timeUnit.toNanos(l3)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l2));
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", l3));
        }
        this.validateScheduled0(l2, timeUnit);
        this.validateScheduled0(l3, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2)), -timeUnit.toNanos(l3)));
    }

    private void validateScheduled0(long l2, TimeUnit timeUnit) {
        this.validateScheduled(l2, timeUnit);
    }

    @Deprecated
    protected void validateScheduled(long l2, TimeUnit timeUnit) {
    }

    final void scheduleFromEventLoop(ScheduledFutureTask<?> scheduledFutureTask) {
        this.scheduledTaskQueue().add(scheduledFutureTask.setId(++this.nextTaskId));
    }

    private <V> ScheduledFuture<V> schedule(ScheduledFutureTask<V> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduleFromEventLoop(scheduledFutureTask);
        } else {
            long l2 = scheduledFutureTask.deadlineNanos();
            if (this.beforeScheduledTaskSubmitted(l2)) {
                this.execute(scheduledFutureTask);
            } else {
                this.lazyExecute(scheduledFutureTask);
                if (this.afterScheduledTaskSubmitted(l2)) {
                    this.execute(WAKEUP_TASK);
                }
            }
        }
        return scheduledFutureTask;
    }

    final void removeScheduled(ScheduledFutureTask<?> scheduledFutureTask) {
        assert (scheduledFutureTask.isCancelled());
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().removeTyped(scheduledFutureTask);
            return;
        }
        this.lazyExecute(scheduledFutureTask);
    }

    protected boolean beforeScheduledTaskSubmitted(long l2) {
        return true;
    }

    protected boolean afterScheduledTaskSubmitted(long l2) {
        return true;
    }
}

