/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.collection;

import com.appoptics.ext.io.netty.util.collection.CharObjectMap;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharObjectHashMap<V>
implements CharObjectMap<V> {
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private char[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Character> keySet = new KeySet();
    private final Set<Map.Entry<Character, V>> entrySet = new EntrySet();
    private final Iterable<CharObjectMap.PrimitiveEntry<V>> entries = new Iterable<CharObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<CharObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public CharObjectHashMap() {
        this(8, 0.5f);
    }

    public CharObjectHashMap(int n2) {
        this(n2, 0.5f);
    }

    public CharObjectHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f2;
        n2 = MathUtil.safeFindNextPositivePowerOfTwo(n2);
        this.mask = n2 - 1;
        this.keys = new char[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
    }

    private static <T> T toExternal(T t2) {
        assert (t2 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        if (t2 == NULL_VALUE) {
            return null;
        }
        return t2;
    }

    private static <T> T toInternal(T t2) {
        if (t2 == null) {
            return (T)NULL_VALUE;
        }
        return t2;
    }

    @Override
    public V get(char c2) {
        int n2 = this.indexOf(c2);
        c2 = (char)n2;
        if (n2 == -1) {
            return null;
        }
        return CharObjectHashMap.toExternal(this.values[c2]);
    }

    @Override
    public V put(char c2, V v2) {
        int n2;
        int n3 = n2 = this.hashIndex(c2);
        do {
            if (this.values[n3] == null) {
                this.keys[n3] = c2;
                this.values[n3] = CharObjectHashMap.toInternal(v2);
                this.growSize();
                return null;
            }
            if (this.keys[n3] != c2) continue;
            V v3 = this.values[n3];
            this.values[n3] = CharObjectHashMap.toInternal(v2);
            return CharObjectHashMap.toExternal(v3);
        } while ((n3 = this.probeNext(n3)) != n2);
        throw new IllegalStateException("Unable to insert");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends Character, ? extends V> object) {
        if (object instanceof CharObjectHashMap) {
            void entry;
            object = (CharObjectHashMap)((Object)object);
            boolean i2 = false;
            while (entry < ((CharObjectHashMap)((Object)object)).values.length) {
                V v2 = ((CharObjectHashMap)((Object)object)).values[entry];
                if (v2 != null) {
                    this.put(((CharObjectHashMap)((Object)object)).keys[entry], v2);
                }
                ++entry;
            }
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            this.put((Character)entry.getKey(), (V)entry.getValue());
        }
    }

    public V remove(char c2) {
        int n2 = this.indexOf(c2);
        c2 = (char)n2;
        if (n2 == -1) {
            return null;
        }
        V v2 = this.values[c2];
        this.removeAt(c2);
        return CharObjectHashMap.toExternal(v2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    public boolean containsKey(char c2) {
        return this.indexOf(c2) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        object = CharObjectHashMap.toInternal(object);
        V[] VArray = this.values;
        int n2 = this.values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2 = VArray[i2];
            if (v2 == null || !v2.equals(object)) continue;
            return true;
        }
        return false;
    }

    public Iterable<CharObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return CharObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int n2 = this.size;
        char[] cArray = this.keys;
        int n3 = this.keys.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = cArray[i2];
            n2 ^= CharObjectHashMap.hashCode(c2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharObjectMap)) {
            return false;
        }
        if (this.size != (object = (CharObjectMap)object).size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            char c2 = this.keys[i2];
            Object v3 = object.get(c2);
            if (!(v2 == NULL_VALUE ? v3 != null : !v2.equals(v3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.containsKey(charObjectHashMap.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.get(charObjectHashMap.objectToKey(object));
    }

    @Override
    public V put(Character c2, V v2) {
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.put(charObjectHashMap.objectToKey(c2), v2);
    }

    @Override
    public V remove(Object object) {
        CharObjectHashMap charObjectHashMap = this;
        return charObjectHashMap.remove(charObjectHashMap.objectToKey(object));
    }

    @Override
    public Set<Character> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Character, V>> entrySet() {
        return this.entrySet;
    }

    private char objectToKey(Object object) {
        return ((Character)object).charValue();
    }

    private int indexOf(char c2) {
        int n2;
        int n3 = n2 = this.hashIndex(c2);
        do {
            if (this.values[n3] == null) {
                return -1;
            }
            if (c2 != this.keys[n3]) continue;
            return n3;
        } while ((n3 = this.probeNext(n3)) != n2);
        return -1;
    }

    private int hashIndex(char c2) {
        return CharObjectHashMap.hashCode(c2) & this.mask;
    }

    private static int hashCode(char c2) {
        return c2;
    }

    private int probeNext(int n2) {
        return n2 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            CharObjectHashMap charObjectHashMap = this;
            charObjectHashMap.rehash(charObjectHashMap.keys.length << 1);
        }
    }

    private boolean removeAt(int n2) {
        --this.size;
        this.keys[n2] = '\u0000';
        this.values[n2] = null;
        int n3 = n2;
        int n4 = this.probeNext(n2);
        V v2 = this.values[n4];
        while (v2 != null) {
            char c2 = this.keys[n4];
            int n5 = this.hashIndex(c2);
            if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                this.keys[n3] = c2;
                this.values[n3] = v2;
                this.keys[n4] = '\u0000';
                this.values[n4] = null;
                n3 = n4;
            }
            n4 = this.probeNext(n4);
            v2 = this.values[n4];
        }
        return n3 != n2;
    }

    private int calcMaxSize(int n2) {
        int n3 = n2 - 1;
        return Math.min(n3, (int)((float)n2 * this.loadFactor));
    }

    private void rehash(int n2) {
        char[] cArray = this.keys;
        V[] VArray = this.values;
        this.keys = new char[n2];
        Object object = new Object[n2];
        this.values = object;
        this.maxSize = this.calcMaxSize(n2);
        this.mask = n2 - 1;
        block0: for (n2 = 0; n2 < VArray.length; ++n2) {
            object = VArray[n2];
            if (object == null) continue;
            char c2 = cArray[n2];
            int n3 = this.hashIndex(c2);
            while (true) {
                if (this.values[n3] == null) {
                    this.keys[n3] = c2;
                    this.values[n3] = object;
                    continue block0;
                }
                n3 = this.probeNext(n3);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            CharObjectHashMap charObjectHashMap = this;
            stringBuilder.append(charObjectHashMap.keyToString(charObjectHashMap.keys[i2])).append('=').append((Object)(v2 == this ? "(this Map)" : CharObjectHashMap.toExternal(v2)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(char c2) {
        return Character.toString(c2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class MapEntry
    implements Map.Entry<Character, V> {
        private final int entryIndex;

        MapEntry(int n2) {
            this.entryIndex = n2;
        }

        @Override
        public final Character getKey() {
            this.verifyExists();
            return Character.valueOf(CharObjectHashMap.this.keys[this.entryIndex]);
        }

        @Override
        public final V getValue() {
            this.verifyExists();
            return CharObjectHashMap.toExternal(CharObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public final V setValue(V v2) {
            this.verifyExists();
            Object object = CharObjectHashMap.toExternal(CharObjectHashMap.this.values[this.entryIndex]);
            ((CharObjectHashMap)CharObjectHashMap.this).values[this.entryIndex] = CharObjectHashMap.toInternal(v2);
            return object;
        }

        private void verifyExists() {
            if (CharObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapIterator
    implements Iterator<Map.Entry<Character, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<Character, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PrimitiveIterator
    implements CharObjectMap.PrimitiveEntry<V>,
    Iterator<CharObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != CharObjectHashMap.this.values.length && CharObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != CharObjectHashMap.this.values.length;
        }

        @Override
        public final CharObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public final void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (CharObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public final char key() {
            return CharObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public final V value() {
            return CharObjectHashMap.toExternal(CharObjectHashMap.this.values[this.entryIndex]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<Character> {
        private KeySet() {
        }

        @Override
        public final int size() {
            return CharObjectHashMap.this.size();
        }

        @Override
        public final boolean contains(Object object) {
            return CharObjectHashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return CharObjectHashMap.this.remove(object) != null;
        }

        @Override
        public final boolean retainAll(Collection<?> collection) {
            boolean bl = false;
            Iterator iterator = CharObjectHashMap.this.entries().iterator();
            while (iterator.hasNext()) {
                CharObjectMap.PrimitiveEntry primitiveEntry = iterator.next();
                if (collection.contains(Character.valueOf(primitiveEntry.key()))) continue;
                bl = true;
                iterator.remove();
            }
            return bl;
        }

        @Override
        public final void clear() {
            CharObjectHashMap.this.clear();
        }

        @Override
        public final Iterator<Character> iterator() {
            return new Iterator<Character>(){
                private final Iterator<Map.Entry<Character, V>> iter;
                {
                    this.iter = CharObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Character next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<Map.Entry<Character, V>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<Character, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public final int size() {
            return CharObjectHashMap.this.size();
        }
    }
}

