/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util;

import com.appoptics.ext.io.netty.util.ResourceLeakHint;
import com.appoptics.ext.io.netty.util.ResourceLeakTracker;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLeakDetector<T> {
    private static final Level DEFAULT_LEVEL;
    private static final int TARGET_RECORDS;
    static final int SAMPLING_INTERVAL;
    private static Level level;
    private static final InternalLogger logger;
    private final Set<DefaultResourceLeak<?>> allLeaks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final Set<String> reportedLeaks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String resourceType;
    private final int samplingInterval;
    private static final AtomicReference<String[]> excludedMethods;

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > Level.DISABLED.ordinal();
    }

    public static Level getLevel() {
        return level;
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> clazz, int n2, long l2) {
        this(clazz, n2);
    }

    public ResourceLeakDetector(Class<?> clazz, int n2) {
        this(StringUtil.simpleClassName(clazz), n2, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(String string, int n2, long l2) {
        this.resourceType = ObjectUtil.checkNotNull(string, "resourceType");
        this.samplingInterval = n2;
    }

    public final ResourceLeakTracker<T> track(T t2) {
        return this.track0(t2);
    }

    private DefaultResourceLeak track0(T t2) {
        Level level = ResourceLeakDetector.level;
        if (level == Level.DISABLED) {
            return null;
        }
        if (level.ordinal() < Level.PARANOID.ordinal()) {
            if (PlatformDependent.threadLocalRandom().nextInt(this.samplingInterval) == 0) {
                this.reportLeak();
                return new DefaultResourceLeak(t2, this.refQueue, this.allLeaks);
            }
            return null;
        }
        this.reportLeak();
        return new DefaultResourceLeak(t2, this.refQueue, this.allLeaks);
    }

    private void clearRefQueue() {
        DefaultResourceLeak defaultResourceLeak;
        while ((defaultResourceLeak = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            defaultResourceLeak.dispose();
        }
    }

    protected boolean needReport() {
        return logger.isErrorEnabled();
    }

    private void reportLeak() {
        Object object;
        if (!this.needReport()) {
            this.clearRefQueue();
            return;
        }
        while ((object = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            if (!((DefaultResourceLeak)object).dispose() || !this.reportedLeaks.add((String)(object = ((DefaultResourceLeak)object).toString()))) continue;
            if (((String)object).isEmpty()) {
                ResourceLeakDetector resourceLeakDetector = this;
                resourceLeakDetector.reportUntracedLeak(resourceLeakDetector.resourceType);
                continue;
            }
            ResourceLeakDetector resourceLeakDetector = this;
            resourceLeakDetector.reportTracedLeak(resourceLeakDetector.resourceType, (String)object);
        }
    }

    protected void reportTracedLeak(String string, String string2) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See https://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)string, (Object)string2);
    }

    protected void reportUntracedLeak(String string) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See https://netty.io/wiki/reference-counted-objects.html for more information.", string, "com.appoptics.ext.io.netty.leakDetection.level", Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    public static void addExclusions(Class clazz, String ... stringArray) {
        String[] stringArray2;
        Method method;
        int n2;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        Object[] objectArray = clazz.getDeclaredMethods();
        int n3 = objectArray.length;
        for (n2 = 0; !(n2 >= n3 || hashSet.remove((method = objectArray[n2]).getName()) && hashSet.isEmpty()); ++n2) {
        }
        if (!hashSet.isEmpty()) {
            throw new IllegalArgumentException("Can't find '" + hashSet + "' in " + clazz.getName());
        }
        do {
            objectArray = excludedMethods.get();
            stringArray2 = Arrays.copyOf(objectArray, objectArray.length + 2 * stringArray.length);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray2[objectArray.length + (n2 << 1)] = clazz.getName();
                stringArray2[objectArray.length + (n2 << 1) + 1] = stringArray[n2];
            }
        } while (!excludedMethods.compareAndSet((String[])objectArray, stringArray2));
    }

    static {
        boolean bl;
        DEFAULT_LEVEL = Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("com.appoptics.ext.io.netty.noResourceLeakDetection") != null) {
            bl = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)bl);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)"com.appoptics.ext.io.netty.leakDetection.level", (Object)DEFAULT_LEVEL.name().toLowerCase());
        } else {
            bl = false;
        }
        Object object = bl ? Level.DISABLED : DEFAULT_LEVEL;
        object = SystemPropertyUtil.get("com.appoptics.ext.io.netty.leakDetectionLevel", ((Enum)object).name());
        object = SystemPropertyUtil.get("com.appoptics.ext.io.netty.leakDetection.level", (String)object);
        object = Level.parseLevel((String)object);
        TARGET_RECORDS = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.leakDetection.targetRecords", 4);
        SAMPLING_INTERVAL = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.leakDetection.samplingInterval", 128);
        level = object;
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)"com.appoptics.ext.io.netty.leakDetection.level", (Object)((Enum)object).name().toLowerCase());
            logger.debug("-D{}: {}", (Object)"com.appoptics.ext.io.netty.leakDetection.targetRecords", (Object)TARGET_RECORDS);
        }
        excludedMethods = new AtomicReference<String[]>(EmptyArrays.EMPTY_STRINGS);
    }

    private static final class Record
    extends Throwable {
        private static final long serialVersionUID = 6065153674892850720L;
        private static final Record BOTTOM = new Record();
        private final String hintString;
        private final Record next;
        private final int pos;

        Record(Record record, Object object) {
            this.hintString = object instanceof ResourceLeakHint ? ((ResourceLeakHint)object).toHintString() : object.toString();
            this.next = record;
            this.pos = record.pos + 1;
        }

        Record(Record record) {
            this.hintString = null;
            this.next = record;
            this.pos = record.pos + 1;
        }

        private Record() {
            this.hintString = null;
            this.next = null;
            this.pos = -1;
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(2048);
            if (this.hintString != null) {
                stringBuilder.append("\tHint: ").append(this.hintString).append(StringUtil.NEWLINE);
            }
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            block0: for (int i2 = 3; i2 < stackTraceElementArray.length; ++i2) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i2];
                String[] stringArray = (String[])excludedMethods.get();
                for (int i3 = 0; i3 < stringArray.length; i3 += 2) {
                    if (stringArray[i3].equals(stackTraceElement.getClassName()) && stringArray[i3 + 1].equals(stackTraceElement.getMethodName())) continue block0;
                }
                stringBuilder.append('\t');
                stringBuilder.append(stackTraceElement.toString());
                stringBuilder.append(StringUtil.NEWLINE);
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultResourceLeak<T>
    extends WeakReference<Object>
    implements ResourceLeakTracker<T> {
        private static final AtomicReferenceFieldUpdater<DefaultResourceLeak<?>, Record> headUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultResourceLeak.class, Record.class, "head");
        private static final AtomicIntegerFieldUpdater<DefaultResourceLeak<?>> droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultResourceLeak.class, "droppedRecords");
        private volatile Record head;
        private volatile int droppedRecords;
        private final Set<DefaultResourceLeak<?>> allLeaks;
        private final int trackedHash;

        DefaultResourceLeak(Object object, ReferenceQueue<Object> referenceQueue, Set<DefaultResourceLeak<?>> set) {
            super(object, referenceQueue);
            assert (object != null);
            this.trackedHash = System.identityHashCode(object);
            set.add(this);
            headUpdater.set(this, new Record(Record.BOTTOM));
            this.allLeaks = set;
        }

        @Override
        public final void record() {
            this.record0(null);
        }

        @Override
        public final void record(Object object) {
            this.record0(object);
        }

        private void record0(Object object) {
            if (TARGET_RECORDS > 0) {
                int n2;
                Record record;
                Record record2;
                do {
                    record = record2 = headUpdater.get(this);
                    if (record2 == null) {
                        return;
                    }
                    n2 = record2.pos + 1;
                    if (n2 >= TARGET_RECORDS) {
                        n2 = Math.min(n2 - TARGET_RECORDS, 30);
                        n2 = PlatformDependent.threadLocalRandom().nextInt(1 << n2) != 0 ? 1 : 0;
                        if (n2 == 0) continue;
                        record = record2.next;
                        continue;
                    }
                    n2 = 0;
                } while (!headUpdater.compareAndSet(this, record2, record = object != null ? new Record(record, object) : new Record(record)));
                if (n2 != 0) {
                    droppedRecordsUpdater.incrementAndGet(this);
                }
            }
        }

        final boolean dispose() {
            this.clear();
            return this.allLeaks.remove(this);
        }

        public final boolean close() {
            if (this.allLeaks.remove(this)) {
                this.clear();
                headUpdater.set(this, null);
                return true;
            }
            return false;
        }

        @Override
        public final boolean close(T t2) {
            assert (this.trackedHash == System.identityHashCode(t2));
            try {
                boolean bl = this.close();
                return bl;
            }
            finally {
                DefaultResourceLeak.reachabilityFence0(t2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void reachabilityFence0(Object object) {
            if (object != null) {
                synchronized (object) {
                    return;
                }
            }
        }

        public final String toString() {
            Record record = headUpdater.getAndSet(this, null);
            if (record == null) {
                return "";
            }
            int n2 = droppedRecordsUpdater.get(this);
            int n3 = 0;
            int n4 = record.pos + 1;
            StringBuilder stringBuilder = new StringBuilder(n4 << 11).append(StringUtil.NEWLINE);
            stringBuilder.append("Recent access records: ").append(StringUtil.NEWLINE);
            int n5 = 1;
            HashSet<String> hashSet = new HashSet<String>(n4);
            while (record != Record.BOTTOM) {
                String string = record.toString();
                if (hashSet.add(string)) {
                    if (record.next == Record.BOTTOM) {
                        stringBuilder.append("Created at:").append(StringUtil.NEWLINE).append(string);
                    } else {
                        stringBuilder.append('#').append(n5++).append(':').append(StringUtil.NEWLINE).append(string);
                    }
                } else {
                    ++n3;
                }
                record = record.next;
            }
            if (n3 > 0) {
                stringBuilder.append(": ").append(n3).append(" leak records were discarded because they were duplicates").append(StringUtil.NEWLINE);
            }
            if (n2 > 0) {
                stringBuilder.append(": ").append(n2).append(" leak records were discarded because the leak record count is targeted to ").append(TARGET_RECORDS).append(". Use system property com.appoptics.ext.io.netty.leakDetection.targetRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setLength(stringBuilder2.length() - StringUtil.NEWLINE.length());
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        DISABLED,
        SIMPLE,
        ADVANCED,
        PARANOID;


        static Level parseLevel(String string) {
            string = string.trim();
            for (Level level : Level.values()) {
                if (!string.equalsIgnoreCase(level.name()) && !string.equals(String.valueOf(level.ordinal()))) continue;
                return level;
            }
            return DEFAULT_LEVEL;
        }
    }
}

