/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util;

import com.appoptics.ext.io.netty.util.ReferenceCounted;
import com.appoptics.ext.io.netty.util.ResourceLeakDetector;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static <T> T retain(T t2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).retain();
        }
        return t2;
    }

    public static <T> T touch(T t2, Object object) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).touch(object);
        }
        return t2;
    }

    public static boolean release(Object object) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release();
        }
        return false;
    }

    public static void safeRelease(Object object) {
        try {
            ReferenceCountUtil.release(object);
            return;
        }
        catch (Throwable throwable) {
            logger.warn("Failed to release a message: {}", object, (Object)throwable);
            return;
        }
    }

    private ReferenceCountUtil() {
    }

    static {
        ResourceLeakDetector.addExclusions(ReferenceCountUtil.class, "touch");
    }
}

