/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.buffer.CompositeByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.AbstractCoalescingBufferQueue;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelException;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelOutboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.ChannelPromiseNotifier;
import com.appoptics.ext.io.netty.handler.codec.ByteToMessageDecoder;
import com.appoptics.ext.io.netty.handler.codec.DecoderException;
import com.appoptics.ext.io.netty.handler.codec.UnsupportedMessageTypeException;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolAccessor;
import com.appoptics.ext.io.netty.handler.ssl.ConscryptAlpnSslEngine;
import com.appoptics.ext.io.netty.handler.ssl.NotSslRecordException;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.appoptics.ext.io.netty.handler.ssl.SslCloseCompletionEvent;
import com.appoptics.ext.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.appoptics.ext.io.netty.handler.ssl.SslHandshakeTimeoutException;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.ReferenceCounted;
import com.appoptics.ext.io.netty.util.concurrent.DefaultPromise;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.FutureListener;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.concurrent.ImmediateExecutor;
import com.appoptics.ext.io.netty.util.concurrent.Promise;
import com.appoptics.ext.io.netty.util.concurrent.ScheduledFuture;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslEngineType engineType;
    private final Executor delegatedTaskExecutor;
    private final boolean jdkCompatibilityMode;
    private final ByteBuffer[] singleBuffer = new ByteBuffer[1];
    private final boolean startTls;
    private boolean sentFirstMessage;
    private boolean flushedBeforeHandshake;
    private boolean readDuringHandshake;
    private boolean handshakeStarted;
    private SslHandlerCoalescingBufferQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new LazyChannelPromise();
    private final LazyChannelPromise sslClosePromise = new LazyChannelPromise();
    private boolean needsFlush;
    private boolean outboundClosed;
    private boolean closeNotify;
    private boolean processTask;
    private int packetLength;
    private boolean firedChannelRead;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyFlushTimeoutMillis = 3000L;
    private volatile long closeNotifyReadTimeoutMillis;
    volatile int wrapDataSize = 16384;

    public SslHandler(SSLEngine sSLEngine, boolean bl) {
        this(sSLEngine, bl, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl, Executor executor) {
        this.engine = ObjectUtil.checkNotNull(sSLEngine, "engine");
        this.delegatedTaskExecutor = ObjectUtil.checkNotNull(executor, "delegatedTaskExecutor");
        this.engineType = SslEngineType.forEngine(sSLEngine);
        this.startTls = bl;
        this.jdkCompatibilityMode = this.engineType.jdkCompatibilityMode(sSLEngine);
        SslHandler sslHandler = this;
        sslHandler.setCumulator(sslHandler.engineType.cumulator);
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public String applicationProtocol() {
        SSLEngine sSLEngine = this.engine();
        if (!(sSLEngine instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)((Object)sSLEngine)).getNegotiatedApplicationProtocol();
    }

    private void closeOutbound0(ChannelPromise channelPromise) {
        this.outboundClosed = true;
        this.engine.closeOutbound();
        try {
            SslHandler sslHandler = this;
            sslHandler.flush(sslHandler.ctx, channelPromise);
            return;
        }
        catch (Exception exception) {
            if (!channelPromise.tryFailure(exception)) {
                logger.warn("{} flush() raised a masked exception.", (Object)this.ctx.channel(), (Object)exception);
            }
            return;
        }
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.releaseAndFailAll(channelHandlerContext, new ChannelException("Pending write on removal of SslHandler"));
        }
        this.pendingUnencryptedWrites = null;
        SSLHandshakeException sSLHandshakeException = null;
        if (!this.handshakePromise.isDone() && this.handshakePromise.tryFailure(sSLHandshakeException = new SSLHandshakeException("SslHandler removed before handshake completed"))) {
            channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(sSLHandshakeException));
        }
        if (!this.sslClosePromise.isDone()) {
            if (sSLHandshakeException == null) {
                sSLHandshakeException = new SSLHandshakeException("SslHandler removed before handshake completed");
            }
            this.notifyClosePromise(sSLHandshakeException);
        }
        if (this.engine instanceof ReferenceCounted) {
            ((ReferenceCounted)((Object)this.engine)).release();
        }
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, true);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, false);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.handshakePromise.isDone()) {
            this.readDuringHandshake = true;
        }
        channelHandlerContext.read();
    }

    private static IllegalStateException newPendingWritesNullException() {
        return new IllegalStateException("pendingUnencryptedWrites is null, handlerRemoved0 called?");
    }

    @Override
    public void write(ChannelHandlerContext object, Object object2, ChannelPromise channelPromise) throws Exception {
        if (!(object2 instanceof ByteBuf)) {
            object = new UnsupportedMessageTypeException(object2, ByteBuf.class);
            ReferenceCountUtil.safeRelease(object2);
            channelPromise.setFailure((Throwable)object);
            return;
        }
        if (this.pendingUnencryptedWrites == null) {
            ReferenceCountUtil.safeRelease(object2);
            channelPromise.setFailure(SslHandler.newPendingWritesNullException());
            return;
        }
        this.pendingUnencryptedWrites.add((ByteBuf)object2, channelPromise);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.startTls && !this.sentFirstMessage) {
            this.sentFirstMessage = true;
            this.pendingUnencryptedWrites.writeAndRemoveAll(channelHandlerContext);
            this.forceFlush(channelHandlerContext);
            this.startHandshakeProcessing();
            return;
        }
        if (this.processTask) {
            return;
        }
        try {
            this.wrapAndFlush(channelHandlerContext);
            return;
        }
        catch (Throwable throwable) {
            this.setHandshakeFailure(channelHandlerContext, throwable);
            PlatformDependent.throwException(throwable);
            return;
        }
    }

    private void wrapAndFlush(ChannelHandlerContext channelHandlerContext) throws SSLException {
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelHandlerContext.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.flushedBeforeHandshake = true;
        }
        try {
            this.wrap(channelHandlerContext, false);
            return;
        }
        finally {
            this.forceFlush(channelHandlerContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void wrap(ChannelHandlerContext channelHandlerContext, boolean bl) throws SSLException {
        ByteBuf byteBuf = null;
        ChannelPromise channelPromise = null;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        ReferenceCounted referenceCounted = null;
        try {
            int n2 = this.wrapDataSize;
            block12: while (!channelHandlerContext.isRemoved()) {
                Object object;
                channelPromise = channelHandlerContext.newPromise();
                referenceCounted = n2 > 0 ? this.pendingUnencryptedWrites.remove(byteBufAllocator, n2, channelPromise) : this.pendingUnencryptedWrites.removeFirst(channelPromise);
                if (referenceCounted == null) return;
                if (byteBuf == null) {
                    byteBuf = this.allocateOutNetBuf(channelHandlerContext, ((ByteBuf)referenceCounted).readableBytes(), ((ByteBuf)referenceCounted).nioBufferCount());
                }
                if (((SSLEngineResult)(object = this.wrap(byteBufAllocator, this.engine, (ByteBuf)referenceCounted, byteBuf))).getStatus() == SSLEngineResult.Status.CLOSED) {
                    referenceCounted.release();
                    referenceCounted = null;
                    object = this.handshakePromise.cause();
                    if (object == null && (object = this.sslClosePromise.cause()) == null) {
                        object = new SSLException("SSLEngine closed already");
                    }
                    channelPromise.tryFailure((Throwable)object);
                    channelPromise = null;
                    this.pendingUnencryptedWrites.releaseAndFailAll(channelHandlerContext, (Throwable)object);
                    this.finishWrap(channelHandlerContext, byteBuf, null, bl, false);
                    return;
                }
                if (((ByteBuf)referenceCounted).isReadable()) {
                    this.pendingUnencryptedWrites.addFirst((ByteBuf)referenceCounted, channelPromise);
                    channelPromise = null;
                } else {
                    referenceCounted.release();
                }
                referenceCounted = null;
                switch (((SSLEngineResult)object).getHandshakeStatus()) {
                    case NEED_TASK: {
                        if (this.runDelegatedTasks(bl)) continue block12;
                        return;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                    }
                    case NOT_HANDSHAKING: {
                        this.setHandshakeSuccessIfStillHandshaking();
                    }
                    case NEED_WRAP: {
                        ByteBuf byteBuf2;
                        object = channelPromise;
                        channelPromise = null;
                        if (byteBuf.isReadable()) {
                            byteBuf2 = byteBuf;
                            byteBuf = null;
                        } else {
                            byteBuf2 = null;
                        }
                        this.finishWrap(channelHandlerContext, byteBuf2, (ChannelPromise)object, bl, false);
                        continue block12;
                    }
                    case NEED_UNWRAP: {
                        this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, true);
                        return;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)((SSLEngineResult)object).getHandshakeStatus()));
                    }
                }
            }
            return;
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
            this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, false);
        }
    }

    private void finishWrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ChannelPromise channelPromise, boolean bl, boolean bl2) {
        if (byteBuf == null) {
            byteBuf = Unpooled.EMPTY_BUFFER;
        } else if (!byteBuf.isReadable()) {
            byteBuf.release();
            byteBuf = Unpooled.EMPTY_BUFFER;
        }
        if (channelPromise != null) {
            channelHandlerContext.write(byteBuf, channelPromise);
        } else {
            channelHandlerContext.write(byteBuf);
        }
        if (bl) {
            this.needsFlush = true;
        }
        if (bl2) {
            this.readIfNeeded(channelHandlerContext);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean wrapNonAppData(final ChannelHandlerContext var1_1, boolean var2_3) throws SSLException {
        block20: {
            var3_4 = null;
            var4_5 = var1_1.alloc();
            try {
                while (!var1_1.isRemoved()) {
                    if (var3_4 == null) {
                        var3_4 = this.allocateOutNetBuf(var1_1, 2048, 1);
                    }
                    if ((var5_6 = this.wrap(var4_5, this.engine, Unpooled.EMPTY_BUFFER, (ByteBuf)var3_4)).bytesProduced() > 0) {
                        var1_1.write(var3_4).addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture object) {
                                if ((object = object.cause()) != null) {
                                    SslHandler.this.setHandshakeFailureTransportFailure(var1_1, (Throwable)object);
                                }
                            }
                        });
                        if (var2_3) {
                            this.needsFlush = true;
                        }
                        var3_4 = null;
                    }
                    var6_7 = var5_6.getHandshakeStatus();
                    switch (9.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[var6_7.ordinal()]) {
                        case 2: {
                            this.setHandshakeSuccess();
                            return false;
                        }
                        case 1: {
                            if (this.runDelegatedTasks(var2_3)) break;
                            break block20;
                        }
                        ** case 5:
                        case 4: {
                            break;
                        }
                        case 3: {
                            this.setHandshakeSuccessIfStillHandshaking();
                            if (!var2_3) {
                                this.unwrapNonAppData(var1_1);
                            }
                            return true;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)var5_6.getHandshakeStatus());
                        }
                    }
                    if (!(var5_6.bytesProduced() == 0 && var6_7 != SSLEngineResult.HandshakeStatus.NEED_TASK || var5_6.bytesConsumed() == 0 && var5_6.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (var3_4 != null) {
                    var3_4.release();
                }
            }
        }
        return false;
    }

    private SSLEngineResult wrap(ByteBufAllocator object, SSLEngine sSLEngine, ByteBuf byteBuf, ByteBuf byteBuf2) throws SSLException {
        ReferenceCounted referenceCounted = null;
        try {
            Object object2;
            int n2 = byteBuf.readerIndex();
            int n3 = byteBuf.readableBytes();
            if (byteBuf.isDirect() || !this.engineType.wantsDirectBuffer) {
                if (!(byteBuf instanceof CompositeByteBuf) && byteBuf.nioBufferCount() == 1) {
                    object = this.singleBuffer;
                    this.singleBuffer[0] = byteBuf.internalNioBuffer(n2, n3);
                } else {
                    object = byteBuf.nioBuffers();
                }
            } else {
                referenceCounted = object.directBuffer(n3);
                ((ByteBuf)referenceCounted).writeBytes(byteBuf, n2, n3);
                object = this.singleBuffer;
                ReferenceCounted referenceCounted2 = referenceCounted;
                this.singleBuffer[0] = ((ByteBuf)referenceCounted2).internalNioBuffer(((ByteBuf)referenceCounted2).readerIndex(), n3);
            }
            block6: while (true) {
                ByteBuf byteBuf3 = byteBuf2;
                object2 = byteBuf3.nioBuffer(byteBuf3.writerIndex(), byteBuf2.writableBytes());
                object2 = sSLEngine.wrap((ByteBuffer[])object, (ByteBuffer)object2);
                byteBuf.skipBytes(((SSLEngineResult)object2).bytesConsumed());
                ByteBuf byteBuf4 = byteBuf2;
                byteBuf4.writerIndex(byteBuf4.writerIndex() + ((SSLEngineResult)object2).bytesProduced());
                switch (((SSLEngineResult)object2).getStatus()) {
                    case BUFFER_OVERFLOW: {
                        byteBuf2.ensureWritable(sSLEngine.getSession().getPacketBufferSize());
                        continue block6;
                    }
                }
                break;
            }
            object = object2;
            return object;
        }
        finally {
            this.singleBuffer[0] = null;
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        boolean bl = this.handshakePromise.cause() != null;
        ClosedChannelException closedChannelException = new ClosedChannelException();
        this.setHandshakeFailure(channelHandlerContext, closedChannelException, !this.outboundClosed, this.handshakeStarted, false);
        this.notifyClosePromise(closedChannelException);
        try {
            super.channelInactive(channelHandlerContext);
            return;
        }
        catch (DecoderException decoderException) {
            if (!bl || !(decoderException.getCause() instanceof SSLException)) {
                throw decoderException;
            }
            return;
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (this.ignoreException(throwable)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)channelHandlerContext.channel(), (Object)throwable);
            }
            if (channelHandlerContext.channel().isActive()) {
                channelHandlerContext.close();
                return;
            }
        } else {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private boolean ignoreException(Throwable stackTraceElementArray) {
        if (!(stackTraceElementArray instanceof SSLException) && stackTraceElementArray instanceof IOException && this.sslClosePromise.isDone()) {
            String string = stackTraceElementArray.getMessage();
            if (string != null && IGNORABLE_ERROR_MESSAGE.matcher(string).matches()) {
                return true;
            }
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray.getStackTrace();
            stackTraceElementArray = stackTraceElementArray2;
            stackTraceElementArray = stackTraceElementArray2;
            int n2 = stackTraceElementArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz = stackTraceElementArray[i2];
                String string2 = ((StackTraceElement)((Object)clazz)).getClassName();
                clazz = ((StackTraceElement)((Object)clazz)).getMethodName();
                if (string2.startsWith("com.appoptics.ext.io.netty.") || !"read".equals(clazz)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(string2).matches()) {
                    return true;
                }
                try {
                    clazz = PlatformDependent.getClassLoader(this.getClass()).loadClass(string2);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Unexpected exception while loading class {} classname {}", this.getClass(), string2, throwable);
                }
            }
        }
        return false;
    }

    private void decodeJdkCompatible(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws NotSslRecordException {
        int n2;
        int n3 = this.packetLength;
        if (n3 > 0) {
            if (byteBuf.readableBytes() < n3) {
                return;
            }
        } else {
            n2 = byteBuf.readableBytes();
            if (n2 < 5) {
                return;
            }
            ByteBuf byteBuf2 = byteBuf;
            n3 = SslUtils.getEncryptedPacketLength(byteBuf2, byteBuf2.readerIndex());
            if (n3 == -2) {
                NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(byteBuf));
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.skipBytes(byteBuf3.readableBytes());
                this.setHandshakeFailure(channelHandlerContext, notSslRecordException);
                throw notSslRecordException;
            }
            assert (n3 > 0);
            if (n3 > n2) {
                this.packetLength = n3;
                return;
            }
        }
        this.packetLength = 0;
        try {
            ByteBuf byteBuf4 = byteBuf;
            n2 = this.unwrap(channelHandlerContext, byteBuf4, byteBuf4.readerIndex(), n3);
            assert (n2 == n3 || this.engine.isInboundDone()) : "we feed the SSLEngine a packets worth of data: " + n3 + " but it only consumed: " + n2;
            byteBuf.skipBytes(n2);
            return;
        }
        catch (Throwable throwable) {
            this.handleUnwrapThrowable(channelHandlerContext, throwable);
            return;
        }
    }

    private void decodeNonJdkCompatible(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        try {
            ByteBuf byteBuf2 = byteBuf;
            byteBuf.skipBytes(this.unwrap(channelHandlerContext, byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes()));
            return;
        }
        catch (Throwable throwable) {
            this.handleUnwrapThrowable(channelHandlerContext, throwable);
            return;
        }
    }

    private void handleUnwrapThrowable(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        try {
            if (this.handshakePromise.tryFailure(throwable)) {
                channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
            }
            this.wrapAndFlush(channelHandlerContext);
        }
        catch (SSLException sSLException) {
            logger.debug("SSLException during trying to call SSLEngine.wrap(...) because of an previous SSLException, ignoring...", sSLException);
        }
        finally {
            this.setHandshakeFailure(channelHandlerContext, throwable, true, false, true);
        }
        PlatformDependent.throwException(throwable);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws SSLException {
        if (this.processTask) {
            return;
        }
        if (this.jdkCompatibilityMode) {
            this.decodeJdkCompatible(channelHandlerContext, byteBuf);
            return;
        }
        this.decodeNonJdkCompatible(channelHandlerContext, byteBuf);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.channelReadComplete0(channelHandlerContext);
    }

    private void channelReadComplete0(ChannelHandlerContext channelHandlerContext) {
        this.discardSomeReadBytes();
        this.flushIfNeeded(channelHandlerContext);
        this.readIfNeeded(channelHandlerContext);
        this.firedChannelRead = false;
        channelHandlerContext.fireChannelReadComplete();
    }

    private void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!(channelHandlerContext.channel().config().isAutoRead() || this.firedChannelRead && this.handshakePromise.isDone())) {
            channelHandlerContext.read();
        }
    }

    private void flushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (this.needsFlush) {
            this.forceFlush(channelHandlerContext);
        }
    }

    private void unwrapNonAppData(ChannelHandlerContext channelHandlerContext) throws SSLException {
        this.unwrap(channelHandlerContext, Unpooled.EMPTY_BUFFER, 0, 0);
    }

    private int unwrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, int n3) throws SSLException {
        int n4 = n3;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = -1;
        ByteBuf byteBuf2 = this.allocate(channelHandlerContext, n3);
        try {
            block14: while (!channelHandlerContext.isRemoved()) {
                SSLEngineResult sSLEngineResult = this.engineType.unwrap(this, byteBuf, n2, n3, byteBuf2);
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                int n6 = sSLEngineResult.bytesProduced();
                int n7 = sSLEngineResult.bytesConsumed();
                n2 += n7;
                n3 -= n7;
                switch (status) {
                    case BUFFER_OVERFLOW: {
                        n7 = byteBuf2.readableBytes();
                        int n8 = n5;
                        n5 = n7;
                        int n9 = this.engine.getSession().getApplicationBufferSize() - n7;
                        if (n7 > 0) {
                            this.firedChannelRead = true;
                            channelHandlerContext.fireChannelRead(byteBuf2);
                            byteBuf2 = null;
                            if (n9 <= 0) {
                                n9 = this.engine.getSession().getApplicationBufferSize();
                            }
                        } else {
                            byteBuf2.release();
                            byteBuf2 = null;
                        }
                        if (n7 == 0 && n8 == 0) {
                            throw new IllegalStateException("Two consecutive overflows but no content was consumed. " + SSLSession.class.getSimpleName() + " getApplicationBufferSize: " + this.engine.getSession().getApplicationBufferSize() + " maybe too small.");
                        }
                        byteBuf2 = this.allocate(channelHandlerContext, this.engineType.calculatePendingData(this, n9));
                        continue block14;
                    }
                    case CLOSED: {
                        bl2 = true;
                    }
                }
                n5 = -1;
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        break;
                    }
                    case NEED_WRAP: {
                        if (!this.wrapNonAppData(channelHandlerContext, true) || n3 != 0) break;
                        break block14;
                    }
                    case NEED_TASK: {
                        if (this.runDelegatedTasks(true)) break;
                        bl = false;
                        break block14;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        bl = true;
                        break;
                    }
                    case NOT_HANDSHAKING: {
                        if (this.setHandshakeSuccessIfStillHandshaking()) {
                            bl = true;
                            continue block14;
                        }
                        if (n3 != 0) break;
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException("unknown handshake status: " + (Object)((Object)handshakeStatus));
                    }
                }
                if (status != SSLEngineResult.Status.BUFFER_UNDERFLOW && (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || n7 != 0 || n6 != 0)) continue;
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                this.readIfNeeded(channelHandlerContext);
                break;
            }
            if (this.flushedBeforeHandshake && this.handshakePromise.isDone()) {
                this.flushedBeforeHandshake = false;
                bl = true;
            }
            if (bl) {
                this.wrap(channelHandlerContext, true);
            }
            if (bl2) {
                this.notifyClosePromise(null);
            }
        }
        finally {
            if (byteBuf2 != null) {
                if (byteBuf2.isReadable()) {
                    this.firedChannelRead = true;
                    channelHandlerContext.fireChannelRead(byteBuf2);
                } else {
                    byteBuf2.release();
                }
            }
        }
        return n4 - n3;
    }

    private static ByteBuffer toByteBuffer(ByteBuf byteBuf, int n2, int n3) {
        if (byteBuf.nioBufferCount() == 1) {
            return byteBuf.internalNioBuffer(n2, n3);
        }
        return byteBuf.nioBuffer(n2, n3);
    }

    private static boolean inEventLoop(Executor executor) {
        return executor instanceof EventExecutor && ((EventExecutor)executor).inEventLoop();
    }

    private static void runAllDelegatedTasks(SSLEngine sSLEngine) {
        Runnable runnable;
        while ((runnable = sSLEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return;
    }

    private boolean runDelegatedTasks(boolean bl) {
        if (this.delegatedTaskExecutor == ImmediateExecutor.INSTANCE || SslHandler.inEventLoop(this.delegatedTaskExecutor)) {
            SslHandler.runAllDelegatedTasks(this.engine);
            return true;
        }
        this.executeDelegatedTasks(bl);
        return false;
    }

    private void executeDelegatedTasks(boolean bl) {
        this.processTask = true;
        try {
            this.delegatedTaskExecutor.execute(new SslTasksRunner(bl));
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.processTask = false;
            throw rejectedExecutionException;
        }
    }

    private boolean setHandshakeSuccessIfStillHandshaking() {
        if (!this.handshakePromise.isDone()) {
            this.setHandshakeSuccess();
            return true;
        }
        return false;
    }

    private void setHandshakeSuccess() {
        this.handshakePromise.trySuccess(this.ctx.channel());
        if (logger.isDebugEnabled()) {
            SSLSession sSLSession = this.engine.getSession();
            logger.debug("{} HANDSHAKEN: protocol:{} cipher suite:{}", this.ctx.channel(), sSLSession.getProtocol(), sSLSession.getCipherSuite());
        }
        this.ctx.fireUserEventTriggered(SslHandshakeCompletionEvent.SUCCESS);
        if (this.readDuringHandshake && !this.ctx.channel().config().isAutoRead()) {
            this.readDuringHandshake = false;
            this.ctx.read();
        }
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.setHandshakeFailure(channelHandlerContext, throwable, true, true, false);
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl, boolean bl2, boolean bl3) {
        try {
            block7: {
                this.outboundClosed = true;
                this.engine.closeOutbound();
                if (bl) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException sSLException) {
                        String string;
                        if (!logger.isDebugEnabled() || (string = sSLException.getMessage()) != null && (string.contains("possible truncation attack") || string.contains("closing inbound before receiving peer's close_notify"))) break block7;
                        logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)channelHandlerContext.channel(), (Object)sSLException);
                    }
                }
            }
            if (this.handshakePromise.tryFailure(throwable) || bl3) {
                SslUtils.handleHandshakeFailure(channelHandlerContext, throwable, bl2);
            }
            return;
        }
        finally {
            this.releaseAndFailAll(channelHandlerContext, throwable);
        }
    }

    private void setHandshakeFailureTransportFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        try {
            throwable = new SSLException("failure when writing TLS control frames", throwable);
            this.releaseAndFailAll(channelHandlerContext, throwable);
            if (this.handshakePromise.tryFailure(throwable)) {
                channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
            }
            return;
        }
        finally {
            channelHandlerContext.close();
        }
    }

    private void releaseAndFailAll(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.releaseAndFailAll(channelHandlerContext, throwable);
        }
    }

    private void notifyClosePromise(Throwable throwable) {
        if (throwable == null) {
            if (this.sslClosePromise.trySuccess(this.ctx.channel())) {
                this.ctx.fireUserEventTriggered(SslCloseCompletionEvent.SUCCESS);
                return;
            }
        } else if (this.sslClosePromise.tryFailure(throwable)) {
            this.ctx.fireUserEventTriggered(new SslCloseCompletionEvent(throwable));
        }
    }

    private void closeOutboundAndChannel(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, boolean bl) throws Exception {
        block6: {
            this.outboundClosed = true;
            this.engine.closeOutbound();
            if (!channelHandlerContext.channel().isActive()) {
                if (bl) {
                    channelHandlerContext.disconnect(channelPromise);
                    return;
                }
                channelHandlerContext.close(channelPromise);
                return;
            }
            ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
            try {
                this.flush(channelHandlerContext, channelPromise2);
                if (this.closeNotify) break block6;
                this.closeNotify = true;
            }
            catch (Throwable throwable) {
                if (!this.closeNotify) {
                    this.closeNotify = true;
                    this.safeClose(channelHandlerContext, channelPromise2, channelHandlerContext.newPromise().addListener(new ChannelPromiseNotifier(false, channelPromise)));
                } else {
                    this.sslClosePromise.addListener(new FutureListener<Channel>(channelPromise){
                        final /* synthetic */ ChannelPromise val$promise;
                        {
                            this.val$promise = channelPromise;
                        }

                        public void operationComplete(Future<Channel> future) {
                            this.val$promise.setSuccess();
                        }
                    });
                }
                throw throwable;
            }
            this.safeClose(channelHandlerContext, channelPromise2, channelHandlerContext.newPromise().addListener(new ChannelPromiseNotifier(false, channelPromise)));
            return;
        }
        this.sslClosePromise.addListener(new /* invalid duplicate definition of identical inner class */);
    }

    private void flush(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelPromise);
        } else {
            channelPromise.setFailure(SslHandler.newPendingWritesNullException());
        }
        this.flush(channelHandlerContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        this.pendingUnencryptedWrites = new SslHandlerCoalescingBufferQueue(channelHandlerContext.channel(), 16);
        if (channelHandlerContext.channel().isActive()) {
            this.startHandshakeProcessing();
        }
    }

    private void startHandshakeProcessing() {
        if (!this.handshakeStarted) {
            this.handshakeStarted = true;
            if (this.engine.getUseClientMode()) {
                this.handshake();
            }
            this.applyHandshakeTimeout();
        }
    }

    private void handshake() {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return;
        }
        if (this.handshakePromise.isDone()) {
            return;
        }
        ChannelHandlerContext channelHandlerContext = this.ctx;
        try {
            this.engine.beginHandshake();
            this.wrapNonAppData(channelHandlerContext, false);
            return;
        }
        catch (Throwable throwable) {
            this.setHandshakeFailure(channelHandlerContext, throwable);
            return;
        }
        finally {
            this.forceFlush(channelHandlerContext);
        }
    }

    private void applyHandshakeTimeout() {
        final Promise<Channel> promise = this.handshakePromise;
        final long l2 = this.handshakeTimeoutMillis;
        if (l2 <= 0L || promise.isDone()) {
            return;
        }
        final ScheduledFuture<?> scheduledFuture = this.ctx.executor().schedule(new Runnable(){

            public void run() {
                if (promise.isDone()) {
                    return;
                }
                SslHandshakeTimeoutException sslHandshakeTimeoutException = new SslHandshakeTimeoutException("handshake timed out after " + l2 + "ms");
                try {
                    if (promise.tryFailure(sslHandshakeTimeoutException)) {
                        SslUtils.handleHandshakeFailure(SslHandler.this.ctx, sslHandshakeTimeoutException, true);
                    }
                    return;
                }
                finally {
                    SslHandler.this.releaseAndFailAll(SslHandler.this.ctx, sslHandshakeTimeoutException);
                }
            }
        }, l2, TimeUnit.MILLISECONDS);
        promise.addListener((GenericFutureListener<Future<Channel>>)new FutureListener<Channel>(){

            public void operationComplete(Future<Channel> future) throws Exception {
                scheduledFuture.cancel(false);
            }
        });
    }

    private void forceFlush(ChannelHandlerContext channelHandlerContext) {
        this.needsFlush = false;
        channelHandlerContext.flush();
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.startTls) {
            this.startHandshakeProcessing();
        }
        channelHandlerContext.fireChannelActive();
    }

    private void safeClose(final ChannelHandlerContext channelHandlerContext, final ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        long l2;
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        final ScheduledFuture<?> scheduledFuture = !channelFuture.isDone() ? ((l2 = this.closeNotifyFlushTimeoutMillis) > 0L ? channelHandlerContext.executor().schedule(new Runnable(){

            public void run() {
                if (!channelFuture.isDone()) {
                    logger.warn("{} Last write attempt timed out; force-closing the connection.", (Object)channelHandlerContext.channel());
                    SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                }
            }
        }, l2, TimeUnit.MILLISECONDS) : null) : null;
        channelFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                long l2;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                if ((l2 = SslHandler.this.closeNotifyReadTimeoutMillis) <= 0L) {
                    SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                    return;
                }
                future = !SslHandler.this.sslClosePromise.isDone() ? channelHandlerContext.executor().schedule(new Runnable(){

                    public void run() {
                        if (!SslHandler.this.sslClosePromise.isDone()) {
                            logger.debug("{} did not receive close_notify in {}ms; force-closing the connection.", (Object)channelHandlerContext.channel(), (Object)l2);
                            SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                        }
                    }
                }, l2, TimeUnit.MILLISECONDS) : null;
                SslHandler.this.sslClosePromise.addListener(new FutureListener<Channel>((java.util.concurrent.ScheduledFuture)((Object)future)){
                    final /* synthetic */ java.util.concurrent.ScheduledFuture val$closeNotifyReadTimeoutFuture;
                    {
                        this.val$closeNotifyReadTimeoutFuture = scheduledFuture;
                    }

                    public void operationComplete(Future<Channel> future) throws Exception {
                        if (this.val$closeNotifyReadTimeoutFuture != null) {
                            this.val$closeNotifyReadTimeoutFuture.cancel(false);
                        }
                        SslHandler.addCloseListener(channelHandlerContext.close(channelHandlerContext.newPromise()), channelPromise);
                    }
                });
            }
        });
    }

    private static void addCloseListener(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        channelFuture.addListener(new ChannelPromiseNotifier(false, channelPromise));
    }

    private ByteBuf allocate(ChannelHandlerContext object, int n2) {
        object = object.alloc();
        if (this.engineType.wantsDirectBuffer) {
            return object.directBuffer(n2);
        }
        return object.buffer(n2);
    }

    private ByteBuf allocateOutNetBuf(ChannelHandlerContext channelHandlerContext, int n2, int n3) {
        return this.engineType.allocateWrapBuffer(this, channelHandlerContext.alloc(), n2, n3);
    }

    private static boolean attemptCopyToCumulation(ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        int n3 = byteBuf2.readableBytes();
        int n4 = byteBuf.capacity();
        if (n2 - byteBuf.readableBytes() >= n3 && (byteBuf.isWritable(n3) && n4 >= n2 || n4 < n2 && ByteBufUtil.ensureWritableSuccess(byteBuf.ensureWritable(n3, false)))) {
            byteBuf.writeBytes(byteBuf2);
            byteBuf2.release();
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        @Override
        protected final EventExecutor executor() {
            if (SslHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return SslHandler.this.ctx.executor();
        }

        @Override
        protected final void checkDeadLock() {
            if (SslHandler.this.ctx == null) {
                return;
            }
            super.checkDeadLock();
        }
    }

    private final class SslHandlerCoalescingBufferQueue
    extends AbstractCoalescingBufferQueue {
        SslHandlerCoalescingBufferQueue(Channel channel, int n2) {
            super(channel, n2);
        }

        protected final ByteBuf compose(ByteBufAllocator object, ByteBuf byteBuf, ByteBuf byteBuf2) {
            int n2 = SslHandler.this.wrapDataSize;
            if (byteBuf instanceof CompositeByteBuf) {
                object = (CompositeByteBuf)byteBuf;
                int n3 = ((CompositeByteBuf)object).numComponents();
                if (n3 == 0 || !SslHandler.attemptCopyToCumulation(((CompositeByteBuf)object).internalComponent(n3 - 1), byteBuf2, n2)) {
                    ((CompositeByteBuf)object).addComponent(true, byteBuf2);
                }
                return object;
            }
            if (SslHandler.attemptCopyToCumulation(byteBuf, byteBuf2, n2)) {
                return byteBuf;
            }
            return this.copyAndCompose((ByteBufAllocator)object, byteBuf, byteBuf2);
        }

        protected final ByteBuf composeFirst(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) {
            if (byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
                byteBuf = ((SslHandler)SslHandler.this).engineType.wantsDirectBuffer ? byteBufAllocator.directBuffer(compositeByteBuf.readableBytes()) : byteBufAllocator.heapBuffer(compositeByteBuf.readableBytes());
                try {
                    byteBuf.writeBytes(compositeByteBuf);
                }
                catch (Throwable throwable) {
                    byteBuf.release();
                    PlatformDependent.throwException(throwable);
                }
                compositeByteBuf.release();
            }
            return byteBuf;
        }

        protected final ByteBuf removeEmptyValue() {
            return null;
        }
    }

    private final class SslTasksRunner
    implements Runnable {
        private final boolean inUnwrap;

        SslTasksRunner(boolean bl) {
            this.inUnwrap = bl;
        }

        private void taskError(Throwable throwable) {
            if (this.inUnwrap) {
                try {
                    SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, throwable);
                    return;
                }
                catch (Throwable throwable2) {
                    this.safeExceptionCaught(throwable2);
                    return;
                }
            }
            SslHandler.this.setHandshakeFailure(SslHandler.this.ctx, throwable);
            SslHandler.this.forceFlush(SslHandler.this.ctx);
        }

        private void safeExceptionCaught(Throwable throwable) {
            try {
                SslHandler.this.exceptionCaught(SslHandler.this.ctx, this.wrapIfNeeded(throwable));
                return;
            }
            catch (Throwable throwable2) {
                SslHandler.this.ctx.fireExceptionCaught(throwable2);
                return;
            }
        }

        private Throwable wrapIfNeeded(Throwable throwable) {
            if (!this.inUnwrap) {
                return throwable;
            }
            if (throwable instanceof DecoderException) {
                return throwable;
            }
            return new DecoderException(throwable);
        }

        private void tryDecodeAgain() {
            try {
                SslHandler.this.channelRead(SslHandler.this.ctx, Unpooled.EMPTY_BUFFER);
                return;
            }
            catch (Throwable throwable) {
                this.safeExceptionCaught(throwable);
                return;
            }
            finally {
                SslHandler.this.channelReadComplete0(SslHandler.this.ctx);
            }
        }

        private void resumeOnEventExecutor() {
            assert (SslHandler.this.ctx.executor().inEventLoop());
            SslHandler.this.processTask = false;
            try {
                SSLEngineResult.HandshakeStatus handshakeStatus = SslHandler.this.engine.getHandshakeStatus();
                switch (handshakeStatus) {
                    case NEED_TASK: {
                        SslHandler.this.executeDelegatedTasks(this.inUnwrap);
                        break;
                    }
                    case FINISHED: {
                        SslHandler.this.setHandshakeSuccess();
                    }
                    case NOT_HANDSHAKING: {
                        SslHandler.this.setHandshakeSuccessIfStillHandshaking();
                        try {
                            SslHandler.this.wrap(SslHandler.this.ctx, this.inUnwrap);
                        }
                        catch (Throwable throwable) {
                            this.taskError(throwable);
                            return;
                        }
                        if (this.inUnwrap) {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        SslHandler.this.forceFlush(SslHandler.this.ctx);
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_UNWRAP: {
                        try {
                            SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                        }
                        catch (SSLException sSLException) {
                            SslHandler.this.handleUnwrapThrowable(SslHandler.this.ctx, sSLException);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_WRAP: {
                        try {
                            if (!SslHandler.this.wrapNonAppData(SslHandler.this.ctx, false) && this.inUnwrap) {
                                SslHandler.this.unwrapNonAppData(SslHandler.this.ctx);
                            }
                            SslHandler.this.forceFlush(SslHandler.this.ctx);
                        }
                        catch (Throwable throwable) {
                            this.taskError(throwable);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (Throwable throwable) {
                this.safeExceptionCaught(throwable);
            }
        }

        public final void run() {
            try {
                SslHandler.runAllDelegatedTasks(SslHandler.this.engine);
                assert (SslHandler.this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK);
                SslHandler.this.ctx.executor().execute(new Runnable(){

                    public void run() {
                        SslTasksRunner.this.resumeOnEventExecutor();
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
                return;
            }
        }

        private void handleException(final Throwable throwable) {
            if (SslHandler.this.ctx.executor().inEventLoop()) {
                SslHandler.this.processTask = false;
                this.safeExceptionCaught(throwable);
                return;
            }
            try {
                SslHandler.this.ctx.executor().execute(new Runnable(){

                    public void run() {
                        SslHandler.this.processTask = false;
                        SslTasksRunner.this.safeExceptionCaught(throwable);
                    }
                });
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                SslHandler.this.processTask = false;
                SslHandler.this.ctx.fireExceptionCaught(throwable);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SslEngineType {
        TCNATIVE(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            final SSLEngineResult unwrap(SslHandler sslHandler, ByteBuf object, int n2, int n3, ByteBuf byteBuf) throws SSLException {
                int n4 = ((ByteBuf)object).nioBufferCount();
                int n5 = byteBuf.writerIndex();
                if (n4 > 1) {
                    ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = (ReferenceCountedOpenSslEngine)sslHandler.engine;
                    try {
                        ((SslHandler)sslHandler).singleBuffer[0] = SslHandler.toByteBuffer(byteBuf, n5, byteBuf.writableBytes());
                        object = referenceCountedOpenSslEngine.unwrap(((ByteBuf)object).nioBuffers(n2, n3), sslHandler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)sslHandler).singleBuffer[0] = null;
                    }
                } else {
                    object = sslHandler.engine.unwrap(SslHandler.toByteBuffer((ByteBuf)object, n2, n3), SslHandler.toByteBuffer(byteBuf, n5, byteBuf.writableBytes()));
                }
                byteBuf.writerIndex(n5 + ((SSLEngineResult)object).bytesProduced());
                return object;
            }

            final ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n2, int n3) {
                return byteBufAllocator.directBuffer(((ReferenceCountedOpenSslEngine)sslHandler.engine).calculateMaxLengthForWrap(n2, n3));
            }

            final int calculatePendingData(SslHandler sslHandler, int n2) {
                int n3 = ((ReferenceCountedOpenSslEngine)sslHandler.engine).sslPending();
                if (n3 > 0) {
                    return n3;
                }
                return n2;
            }

            final boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return ((ReferenceCountedOpenSslEngine)sSLEngine).jdkCompatibilityMode;
            }
        }
        ,
        CONSCRYPT(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){

            final SSLEngineResult unwrap(SslHandler sslHandler, ByteBuf object, int n2, int n3, ByteBuf byteBuf) throws SSLException {
                int n4 = ((ByteBuf)object).nioBufferCount();
                int n5 = byteBuf.writerIndex();
                if (n4 > 1) {
                    try {
                        ((SslHandler)sslHandler).singleBuffer[0] = SslHandler.toByteBuffer(byteBuf, n5, byteBuf.writableBytes());
                        object = ((ConscryptAlpnSslEngine)sslHandler.engine).unwrap(((ByteBuf)object).nioBuffers(n2, n3), sslHandler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)sslHandler).singleBuffer[0] = null;
                    }
                } else {
                    object = sslHandler.engine.unwrap(SslHandler.toByteBuffer((ByteBuf)object, n2, n3), SslHandler.toByteBuffer(byteBuf, n5, byteBuf.writableBytes()));
                }
                byteBuf.writerIndex(n5 + ((SSLEngineResult)object).bytesProduced());
                return object;
            }

            final ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n2, int n3) {
                return byteBufAllocator.directBuffer(((ConscryptAlpnSslEngine)sslHandler.engine).calculateOutNetBufSize(n2, n3));
            }

            final int calculatePendingData(SslHandler sslHandler, int n2) {
                return n2;
            }

            final boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return true;
            }
        }
        ,
        JDK(false, ByteToMessageDecoder.MERGE_CUMULATOR){

            final SSLEngineResult unwrap(SslHandler object, ByteBuf comparable, int n2, int n3, ByteBuf byteBuf) throws SSLException {
                int n4;
                int n5 = byteBuf.writerIndex();
                comparable = SslHandler.toByteBuffer((ByteBuf)comparable, n2, n3);
                n2 = ((Buffer)((Object)comparable)).position();
                object = ((SslHandler)object).engine.unwrap((ByteBuffer)comparable, SslHandler.toByteBuffer(byteBuf, n5, byteBuf.writableBytes()));
                byteBuf.writerIndex(n5 + ((SSLEngineResult)object).bytesProduced());
                if (((SSLEngineResult)object).bytesConsumed() == 0 && (n4 = ((Buffer)((Object)comparable)).position() - n2) != ((SSLEngineResult)object).bytesConsumed()) {
                    return new SSLEngineResult(((SSLEngineResult)object).getStatus(), ((SSLEngineResult)object).getHandshakeStatus(), n4, ((SSLEngineResult)object).bytesProduced());
                }
                return object;
            }

            final ByteBuf allocateWrapBuffer(SslHandler sslHandler, ByteBufAllocator byteBufAllocator, int n2, int n3) {
                return byteBufAllocator.heapBuffer(sslHandler.engine.getSession().getPacketBufferSize());
            }

            final int calculatePendingData(SslHandler sslHandler, int n2) {
                return n2;
            }

            final boolean jdkCompatibilityMode(SSLEngine sSLEngine) {
                return true;
            }
        };

        final boolean wantsDirectBuffer;
        final ByteToMessageDecoder.Cumulator cumulator;

        static SslEngineType forEngine(SSLEngine sSLEngine) {
            if (sSLEngine instanceof ReferenceCountedOpenSslEngine) {
                return TCNATIVE;
            }
            if (sSLEngine instanceof ConscryptAlpnSslEngine) {
                return CONSCRYPT;
            }
            return JDK;
        }

        private SslEngineType(boolean bl, ByteToMessageDecoder.Cumulator cumulator) {
            this.wantsDirectBuffer = bl;
            this.cumulator = cumulator;
        }

        abstract SSLEngineResult unwrap(SslHandler var1, ByteBuf var2, int var3, int var4, ByteBuf var5) throws SSLException;

        abstract int calculatePendingData(SslHandler var1, int var2);

        abstract boolean jdkCompatibilityMode(SSLEngine var1);

        abstract ByteBuf allocateWrapBuffer(SslHandler var1, ByteBufAllocator var2, int var3, int var4);
    }
}

