/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteFilter;
import com.appoptics.ext.io.netty.handler.ssl.ClientAuth;
import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslEngineMap;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslServerSessionContext;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslSessionTicketKey;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslTlsv13X509ExtendedTrustManager;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import com.appoptics.ext.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.appoptics.ext.io.netty.internal.tcnative.CertificateCallback;
import com.appoptics.ext.io.netty.internal.tcnative.CertificateVerifier;
import com.appoptics.ext.io.netty.internal.tcnative.SSLContext;
import com.appoptics.ext.io.netty.internal.tcnative.SniHostNameMatcher;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceCountedOpenSslServerContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslServerContext.class);
    private static final byte[] ID = new byte[]{110, 101, 116, 116, 121};
    private final OpenSslServerSessionContext sessionContext;
    private static final boolean ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean("jdk.tls.server.enableSessionTicketExtension", false);

    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2) throws SSLException {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, ReferenceCountedOpenSslServerContext.toNegotiator(applicationProtocolConfig), l2, l3, clientAuth, stringArray, bl, bl2, string2);
    }

    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2) throws SSLException {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l2, l3, 1, (Certificate[])x509CertificateArray2, clientAuth, stringArray, bl, bl2, true);
        try {
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2);
            if (ENABLE_SESSION_TICKET) {
                this.sessionContext.setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    public final OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }

    static OpenSslServerSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] object, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2) throws SSLException {
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object2;
            try {
                SSLContext.setVerify((long)l2, (int)0, (int)10);
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    ObjectUtil.checkNotNull(object, "keyCertChain");
                    ReferenceCountedOpenSslServerContext.setKeyMaterial(l2, object, privateKey, string);
                } else {
                    if (keyManagerFactory == null) {
                        object2 = ReferenceCountedOpenSslServerContext.keyStorePassword(string);
                        keyManagerFactory = (object = ReferenceCountedOpenSslServerContext.buildKeyStore(object, privateKey, object2, string2)).aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init((KeyStore)object, (char[])object2);
                    }
                    openSslKeyMaterialProvider = ReferenceCountedOpenSslServerContext.providerFor(keyManagerFactory, string);
                    SSLContext.setCertificateCallback((long)l2, (CertificateCallback)new OpenSslServerCertificateCallback(openSslEngineMap, new OpenSslKeyMaterialManager(openSslKeyMaterialProvider)));
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslServerContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object2 = ReferenceCountedOpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                ReferenceCountedOpenSslServerContext.setVerifyCallback(l2, openSslEngineMap, (X509TrustManager)object2);
                object = object2.getAcceptedIssuers();
                if (object != null && ((X509Certificate[])object).length > 0) {
                    long l3 = 0L;
                    try {
                        l3 = ReferenceCountedOpenSslServerContext.toBIO(ByteBufAllocator.DEFAULT, object);
                        if (!SSLContext.setCACertificateBio((long)l2, (long)l3)) {
                            throw new SSLException("unable to setup accepted issuers for trustmanager " + object2);
                        }
                    }
                    finally {
                        ReferenceCountedOpenSslServerContext.freeBio(l3);
                    }
                }
                if (PlatformDependent.javaVersion() >= 8) {
                    SSLContext.setSniHostnameMatcher((long)l2, (SniHostNameMatcher)new OpenSslSniHostnameMatcher(openSslEngineMap));
                }
            }
            catch (SSLException sSLException) {
                object2 = sSLException;
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("unable to setup trustmanager", exception);
            }
            object2 = new OpenSslServerSessionContext(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
            object2.setSessionIdContext(ID);
            openSslKeyMaterialProvider = null;
            object = object2;
            return object;
        }
        catch (Throwable throwable) {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
            throw throwable;
        }
    }

    private static void setVerifyCallback(long l2, OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
        if (ReferenceCountedOpenSslServerContext.useExtendedTrustManager(x509TrustManager)) {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)x509TrustManager));
            return;
        }
        SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new TrustManagerVerifyCallback(openSslEngineMap, x509TrustManager));
    }

    private static final class OpenSslSniHostnameMatcher
    implements SniHostNameMatcher {
        private final OpenSslEngineMap engineMap;

        OpenSslSniHostnameMatcher(OpenSslEngineMap openSslEngineMap) {
            this.engineMap = openSslEngineMap;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(openSslEngineMap);
            this.manager = OpenSslTlsv13X509ExtendedTrustManager.wrap(x509ExtendedTrustManager);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
            super(openSslEngineMap);
            this.manager = x509TrustManager;
        }
    }

    private static final class OpenSslServerCertificateCallback
    implements CertificateCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslServerCertificateCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engineMap = openSslEngineMap;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }
    }
}

