/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class OpenSslX509TrustManagerWrapper {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(OpenSslX509TrustManagerWrapper.class);
    private static final TrustManagerWrapper WRAPPER;

    private OpenSslX509TrustManagerWrapper() {
    }

    static X509TrustManager wrapIfNeeded(X509TrustManager x509TrustManager) {
        return WRAPPER.wrapIfNeeded(x509TrustManager);
    }

    private static SSLContext newSSLContext() throws NoSuchAlgorithmException, NoSuchProviderException {
        return SSLContext.getInstance("TLS", "SunJSSE");
    }

    static {
        TrustManagerWrapper trustManagerWrapper = new TrustManagerWrapper(){

            public final X509TrustManager wrapIfNeeded(X509TrustManager x509TrustManager) {
                return x509TrustManager;
            }
        };
        Object object = null;
        Object object2 = PlatformDependent.getUnsafeUnavailabilityCause();
        if (object2 == null) {
            try {
                object2 = OpenSslX509TrustManagerWrapper.newSSLContext();
                ((SSLContext)object2).init(null, new TrustManager[]{new X509TrustManager(){

                    public final void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        throw new CertificateException();
                    }

                    public final void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        throw new CertificateException();
                    }

                    public final X509Certificate[] getAcceptedIssuers() {
                        return EmptyArrays.EMPTY_X509_CERTIFICATES;
                    }
                }}, null);
            }
            catch (Throwable throwable) {
                object2 = null;
                object = throwable;
            }
            if (object != null) {
                LOGGER.debug("Unable to access wrapped TrustManager", (Throwable)object);
            } else {
                object = object2;
                if ((object = AccessController.doPrivileged(new PrivilegedAction<Object>((SSLContext)object){
                    final /* synthetic */ SSLContext val$finalContext;
                    {
                        this.val$finalContext = sSLContext;
                    }

                    @Override
                    public final Object run() {
                        try {
                            Object object = SSLContext.class.getDeclaredField("contextSpi");
                            long l2 = PlatformDependent.objectFieldOffset((Field)object);
                            object = PlatformDependent.getObject(this.val$finalContext, l2);
                            if (object != null) {
                                Class<?> clazz = object.getClass();
                                do {
                                    try {
                                        Object object2 = clazz.getDeclaredField("trustManager");
                                        long l3 = PlatformDependent.objectFieldOffset((Field)object2);
                                        object2 = PlatformDependent.getObject(object, l3);
                                        if (object2 instanceof X509ExtendedTrustManager) {
                                            return new UnsafeTrustManagerWrapper(l2, l3);
                                        }
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {}
                                } while ((clazz = clazz.getSuperclass()) != null);
                            }
                            throw new NoSuchFieldException();
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                            return noSuchFieldException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                })) instanceof Throwable) {
                    LOGGER.debug("Unable to access wrapped TrustManager", (Throwable)object);
                } else {
                    trustManagerWrapper = (TrustManagerWrapper)object;
                }
            }
        } else {
            LOGGER.debug("Unable to access wrapped TrustManager", null);
        }
        WRAPPER = trustManagerWrapper;
    }

    private static final class UnsafeTrustManagerWrapper
    implements TrustManagerWrapper {
        private final long spiOffset;
        private final long tmOffset;

        UnsafeTrustManagerWrapper(long l2, long l3) {
            this.spiOffset = l2;
            this.tmOffset = l3;
        }

        public final X509TrustManager wrapIfNeeded(X509TrustManager x509TrustManager) {
            if (!(x509TrustManager instanceof X509ExtendedTrustManager)) {
                try {
                    Object object = OpenSslX509TrustManagerWrapper.newSSLContext();
                    ((SSLContext)object).init(null, new TrustManager[]{x509TrustManager}, null);
                    object = PlatformDependent.getObject(object, this.spiOffset);
                    if (object != null && (object = PlatformDependent.getObject(object, this.tmOffset)) instanceof X509ExtendedTrustManager) {
                        return (X509TrustManager)object;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
                    PlatformDependent.throwException(noSuchAlgorithmException);
                }
                catch (KeyManagementException keyManagementException) {
                    KeyManagementException keyManagementException2 = keyManagementException;
                    PlatformDependent.throwException(keyManagementException);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    NoSuchProviderException noSuchProviderException2 = noSuchProviderException;
                    PlatformDependent.throwException(noSuchProviderException);
                }
            }
            return x509TrustManager;
        }
    }

    private static interface TrustManagerWrapper {
        public X509TrustManager wrapIfNeeded(X509TrustManager var1);
    }
}

