/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.SslContext;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OpenSslX509Certificate
extends X509Certificate {
    private final byte[] bytes;
    private X509Certificate wrapped;

    OpenSslX509Certificate(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public final void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.unwrap().checkValidity();
    }

    @Override
    public final void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.unwrap().checkValidity(date);
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        return this.unwrap().getIssuerX500Principal();
    }

    @Override
    public final X500Principal getSubjectX500Principal() {
        return this.unwrap().getSubjectX500Principal();
    }

    @Override
    public final List<String> getExtendedKeyUsage() throws CertificateParsingException {
        return this.unwrap().getExtendedKeyUsage();
    }

    @Override
    public final Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        return this.unwrap().getSubjectAlternativeNames();
    }

    @Override
    public final Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return this.unwrap().getSubjectAlternativeNames();
    }

    @Override
    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        this.unwrap().verify(publicKey, provider);
    }

    @Override
    public final int getVersion() {
        return this.unwrap().getVersion();
    }

    @Override
    public final BigInteger getSerialNumber() {
        return this.unwrap().getSerialNumber();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.unwrap().getIssuerDN();
    }

    @Override
    public final Principal getSubjectDN() {
        return this.unwrap().getSubjectDN();
    }

    @Override
    public final Date getNotBefore() {
        return this.unwrap().getNotBefore();
    }

    @Override
    public final Date getNotAfter() {
        return this.unwrap().getNotAfter();
    }

    @Override
    public final byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.unwrap().getTBSCertificate();
    }

    @Override
    public final byte[] getSignature() {
        return this.unwrap().getSignature();
    }

    @Override
    public final String getSigAlgName() {
        return this.unwrap().getSigAlgName();
    }

    @Override
    public final String getSigAlgOID() {
        return this.unwrap().getSigAlgOID();
    }

    @Override
    public final byte[] getSigAlgParams() {
        return this.unwrap().getSigAlgParams();
    }

    @Override
    public final boolean[] getIssuerUniqueID() {
        return this.unwrap().getIssuerUniqueID();
    }

    @Override
    public final boolean[] getSubjectUniqueID() {
        return this.unwrap().getSubjectUniqueID();
    }

    @Override
    public final boolean[] getKeyUsage() {
        return this.unwrap().getKeyUsage();
    }

    @Override
    public final int getBasicConstraints() {
        return this.unwrap().getBasicConstraints();
    }

    @Override
    public final byte[] getEncoded() {
        return (byte[])this.bytes.clone();
    }

    @Override
    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.unwrap().verify(publicKey);
    }

    @Override
    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.unwrap().verify(publicKey, string);
    }

    @Override
    public final String toString() {
        return this.unwrap().toString();
    }

    @Override
    public final PublicKey getPublicKey() {
        return this.unwrap().getPublicKey();
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        return this.unwrap().hasUnsupportedCriticalExtension();
    }

    @Override
    public final Set<String> getCriticalExtensionOIDs() {
        return this.unwrap().getCriticalExtensionOIDs();
    }

    @Override
    public final Set<String> getNonCriticalExtensionOIDs() {
        return this.unwrap().getNonCriticalExtensionOIDs();
    }

    @Override
    public final byte[] getExtensionValue(String string) {
        return this.unwrap().getExtensionValue(string);
    }

    private X509Certificate unwrap() {
        X509Certificate x509Certificate = this.wrapped;
        if (x509Certificate == null) {
            try {
                x509Certificate = this.wrapped = (X509Certificate)SslContext.X509_CERT_FACTORY.generateCertificate(new ByteArrayInputStream(this.bytes));
            }
            catch (CertificateException certificateException) {
                throw new IllegalStateException(certificateException);
            }
        }
        return x509Certificate;
    }
}

