/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.OpenSslKeyMaterial;
import com.appoptics.ext.io.netty.internal.tcnative.SSL;
import com.appoptics.ext.io.netty.util.AbstractReferenceCounted;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

final class OpenSslPrivateKey
extends AbstractReferenceCounted
implements PrivateKey {
    private long privateKeyAddress;

    public final String getAlgorithm() {
        return "unknown";
    }

    public final String getFormat() {
        return null;
    }

    public final byte[] getEncoded() {
        return null;
    }

    protected final void deallocate() {
        SSL.freePrivateKey((long)this.privateKeyAddress);
        this.privateKeyAddress = 0L;
    }

    public final OpenSslPrivateKey retain() {
        super.retain();
        return this;
    }

    public final OpenSslPrivateKey touch() {
        super.touch();
        return this;
    }

    public final OpenSslPrivateKey touch(Object object) {
        return this;
    }

    public final void destroy() {
        OpenSslPrivateKey openSslPrivateKey = this;
        openSslPrivateKey.release(openSslPrivateKey.refCnt());
    }

    public final boolean isDestroyed() {
        return this.refCnt() == 0;
    }

    final OpenSslKeyMaterial newKeyMaterial(long l2, X509Certificate[] x509CertificateArray) {
        return new OpenSslPrivateKeyMaterial(l2, x509CertificateArray);
    }

    final class OpenSslPrivateKeyMaterial
    extends AbstractReferenceCounted
    implements OpenSslKeyMaterial {
        long certificateChain;
        private final X509Certificate[] x509CertificateChain;

        OpenSslPrivateKeyMaterial(long l2, X509Certificate[] x509CertificateArray) {
            this.certificateChain = l2;
            this.x509CertificateChain = x509CertificateArray == null ? EmptyArrays.EMPTY_X509_CERTIFICATES : x509CertificateArray;
            OpenSslPrivateKey.this.retain();
        }

        public final OpenSslKeyMaterial touch(Object object) {
            OpenSslPrivateKey.this.touch(object);
            return this;
        }

        public final OpenSslKeyMaterial retain() {
            super.retain();
            return this;
        }

        public final OpenSslKeyMaterial touch() {
            OpenSslPrivateKey.this.touch();
            return this;
        }

        protected final void deallocate() {
            this.releaseChain();
            OpenSslPrivateKey.this.release();
        }

        private void releaseChain() {
            SSL.freeX509Chain((long)this.certificateChain);
            this.certificateChain = 0L;
        }
    }
}

