/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.JdkSslEngine;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.org.eclipse.jetty.alpn.ALPN;
import java.util.LinkedHashSet;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

abstract class JettyAlpnSslEngine
extends JdkSslEngine {
    private static final boolean available = JettyAlpnSslEngine.initAvailable();

    static boolean isAvailable() {
        return available;
    }

    private static boolean initAvailable() {
        if (PlatformDependent.javaVersion() <= 8) {
            try {
                Class.forName("sun.security.ssl.ALPNExtension", true, null);
                return true;
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    static JettyAlpnSslEngine newClientEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ClientEngine(sSLEngine, jdkApplicationProtocolNegotiator);
    }

    static JettyAlpnSslEngine newServerEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ServerEngine(sSLEngine, jdkApplicationProtocolNegotiator);
    }

    private JettyAlpnSslEngine(SSLEngine sSLEngine) {
        super(sSLEngine);
    }

    private static final class ServerEngine
    extends JettyAlpnSslEngine {
        ServerEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator object) {
            super(sSLEngine);
            ObjectUtil.checkNotNull(object, "applicationNegotiator");
            object = ObjectUtil.checkNotNull(object.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(object.protocols())), "protocolSelector");
            ALPN.put((SSLEngine)sSLEngine, (ALPN.Provider)new ALPN.ServerProvider((JdkApplicationProtocolNegotiator.ProtocolSelector)object){
                final /* synthetic */ JdkApplicationProtocolNegotiator.ProtocolSelector val$protocolSelector;
                {
                    this.val$protocolSelector = protocolSelector;
                }
            });
        }

        public final void closeInbound() throws SSLException {
            try {
                ALPN.remove((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeInbound();
            }
        }

        public final void closeOutbound() {
            try {
                ALPN.remove((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeOutbound();
            }
        }
    }

    private static final class ClientEngine
    extends JettyAlpnSslEngine {
        ClientEngine(SSLEngine sSLEngine, final JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine);
            ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator, "applicationNegotiator");
            final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolSelectionListener = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), "protocolListener");
            ALPN.put((SSLEngine)sSLEngine, (ALPN.Provider)new ALPN.ClientProvider(){});
        }

        public final void closeInbound() throws SSLException {
            try {
                ALPN.remove((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeInbound();
            }
        }

        public final void closeOutbound() {
            try {
                ALPN.remove((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeOutbound();
            }
        }
    }
}

