/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.CipherSuiteFilter;
import com.appoptics.ext.io.netty.handler.ssl.ClientAuth;
import com.appoptics.ext.io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.JdkDefaultApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.SslContext;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkSslContext
extends SslContext {
    private static final InternalLogger logger;
    private static final String[] DEFAULT_PROTOCOLS;
    private static final List<String> DEFAULT_CIPHERS;
    private static final List<String> DEFAULT_CIPHERS_NON_TLSV13;
    private static final Set<String> SUPPORTED_CIPHERS;
    private static final Set<String> SUPPORTED_CIPHERS_NON_TLSV13;
    private static final Provider DEFAULT_PROVIDER;
    private final String[] protocols;
    private final String[] cipherSuites;
    private final List<String> unmodifiableCipherSuites;
    private final JdkApplicationProtocolNegotiator apn;
    private final ClientAuth clientAuth;
    private final SSLContext sslContext;
    private final boolean isClient;

    private static String[] defaultProtocols(SSLContext object, SSLEngine sSLEngine) {
        object = ((SSLContext)object).getDefaultSSLParameters().getProtocols();
        HashSet<String> hashSet = new HashSet<String>(((String[])object).length);
        Collections.addAll(hashSet, object);
        object = new ArrayList();
        SslUtils.addIfSupported(hashSet, (List<String>)object, "TLSv1.2", "TLSv1.1", "TLSv1");
        if (!object.isEmpty()) {
            return object.toArray(new String[0]);
        }
        return sSLEngine.getEnabledProtocols();
    }

    private static Set<String> supportedCiphers(SSLEngine sSLEngine) {
        String[] stringArray = sSLEngine.getSupportedCipherSuites();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            linkedHashSet.add(string);
            if (!string.startsWith("SSL_")) continue;
            string = "TLS_" + string.substring(4);
            try {
                sSLEngine.setEnabledCipherSuites(new String[]{string});
                linkedHashSet.add(string);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return linkedHashSet;
    }

    private static List<String> defaultCiphers(SSLEngine sSLEngine, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(set, arrayList, SslUtils.DEFAULT_CIPHER_SUITES);
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(arrayList, sSLEngine.getEnabledCipherSuites());
        return arrayList;
    }

    private static boolean isTlsV13Supported(String[] stringArray) {
        for (String string : stringArray) {
            if (!"TLSv1.3".equals(string)) continue;
            return true;
        }
        return false;
    }

    JdkSslContext(SSLContext list, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator set, ClientAuth object, String[] stringArray, boolean n2) {
        super(n2 != 0);
        this.apn = ObjectUtil.checkNotNull(set, "apn");
        this.clientAuth = ObjectUtil.checkNotNull(object, "clientAuth");
        this.sslContext = ObjectUtil.checkNotNull(list, "sslContext");
        if (DEFAULT_PROVIDER.equals(((SSLContext)((Object)list)).getProvider())) {
            String[] stringArray2 = this.protocols = stringArray == null ? DEFAULT_PROTOCOLS : stringArray;
            if (JdkSslContext.isTlsV13Supported(this.protocols)) {
                set = SUPPORTED_CIPHERS;
                list = DEFAULT_CIPHERS;
            } else {
                set = SUPPORTED_CIPHERS_NON_TLSV13;
                list = DEFAULT_CIPHERS_NON_TLSV13;
            }
        } else {
            object = ((SSLContext)((Object)list)).createSSLEngine();
            try {
                this.protocols = stringArray == null ? JdkSslContext.defaultProtocols((SSLContext)((Object)list), (SSLEngine)object) : stringArray;
                set = JdkSslContext.supportedCiphers((SSLEngine)object);
                list = JdkSslContext.defaultCiphers((SSLEngine)object, set);
                if (!JdkSslContext.isTlsV13Supported(this.protocols)) {
                    stringArray = SslUtils.DEFAULT_TLSV13_CIPHER_SUITES;
                    n2 = SslUtils.DEFAULT_TLSV13_CIPHER_SUITES.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = stringArray[i2];
                        set.remove(string);
                        list.remove(string);
                    }
                }
            }
            finally {
                ReferenceCountUtil.release(object);
            }
        }
        this.cipherSuites = ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(iterable, list, set);
        this.unmodifiableCipherSuites = Collections.unmodifiableList(Arrays.asList(this.cipherSuites));
        this.isClient = bl;
    }

    public final SSLContext context() {
        return this.sslContext;
    }

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n2) {
        JdkSslContext jdkSslContext = this;
        return jdkSslContext.configureAndWrapEngine(jdkSslContext.context().createSSLEngine(string, n2), byteBufAllocator);
    }

    private SSLEngine configureAndWrapEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator) {
        JdkApplicationProtocolNegotiator.SslEngineWrapperFactory sslEngineWrapperFactory;
        sSLEngine.setEnabledCipherSuites(this.cipherSuites);
        sSLEngine.setEnabledProtocols(this.protocols);
        sSLEngine.setUseClientMode(this.isClient());
        if (this.isServer()) {
            switch (this.clientAuth) {
                case OPTIONAL: {
                    sSLEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sSLEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + (Object)((Object)this.clientAuth));
                }
            }
        }
        if ((sslEngineWrapperFactory = this.apn.wrapperFactory()) instanceof JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory) {
            return ((JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory)sslEngineWrapperFactory).wrapSslEngine(sSLEngine, byteBufAllocator, this.apn, this.isServer());
        }
        return sslEngineWrapperFactory.wrapSslEngine(sSLEngine, this.apn, this.isServer());
    }

    @Override
    public final JdkApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig, boolean bl) {
        if (applicationProtocolConfig == null) {
            return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case ALPN: {
                if (bl) {
                    switch (applicationProtocolConfig.selectorFailureBehavior()) {
                        case FATAL_ALERT: {
                            return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                        case NO_ADVERTISE: {
                            return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
            }
            case NPN: {
                if (bl) {
                    switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                        case ACCEPT: {
                            return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                        case FATAL_ALERT: {
                            return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectorFailureBehavior()) {
                    case FATAL_ALERT: {
                        return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                    case NO_ADVERTISE: {
                        return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.protocol()) + " protocol");
    }

    static {
        LinkedHashSet<String> linkedHashSet;
        logger = InternalLoggerFactory.getInstance(JdkSslContext.class);
        try {
            linkedHashSet = SSLContext.getInstance("TLS");
            ((SSLContext)((Object)linkedHashSet)).init(null, null, null);
        }
        catch (Exception exception) {
            throw new Error("failed to initialize the default SSL context", exception);
        }
        DEFAULT_PROVIDER = ((SSLContext)((Object)linkedHashSet)).getProvider();
        SSLEngine sSLEngine = ((SSLContext)((Object)linkedHashSet)).createSSLEngine();
        DEFAULT_PROTOCOLS = JdkSslContext.defaultProtocols((SSLContext)((Object)linkedHashSet), sSLEngine);
        SUPPORTED_CIPHERS = Collections.unmodifiableSet(JdkSslContext.supportedCiphers(sSLEngine));
        DEFAULT_CIPHERS = Collections.unmodifiableList(JdkSslContext.defaultCiphers(sSLEngine, SUPPORTED_CIPHERS));
        linkedHashSet = new ArrayList<String>(DEFAULT_CIPHERS);
        linkedHashSet.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
        DEFAULT_CIPHERS_NON_TLSV13 = Collections.unmodifiableList(linkedHashSet);
        linkedHashSet = new LinkedHashSet<String>(SUPPORTED_CIPHERS);
        linkedHashSet.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
        SUPPORTED_CIPHERS_NON_TLSV13 = Collections.unmodifiableSet(linkedHashSet);
        if (logger.isDebugEnabled()) {
            logger.debug("Default protocols (JDK): {} ", (Object)Arrays.asList(DEFAULT_PROTOCOLS));
            logger.debug("Default cipher suites (JDK): {}", (Object)DEFAULT_CIPHERS);
        }
    }
}

