/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.JdkAlpnSslUtils;
import com.appoptics.ext.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.JdkSslEngine;
import com.appoptics.ext.io.netty.handler.ssl.SslUtils;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JdkAlpnSslEngine
extends JdkSslEngine {
    private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener selectionListener;
    private final AlpnSelector alpnSelector;

    JdkAlpnSslEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl) {
        super(sSLEngine);
        if (bl) {
            this.selectionListener = null;
            this.alpnSelector = new AlpnSelector(jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())));
            JdkAlpnSslUtils.setHandshakeApplicationProtocolSelector(sSLEngine, this.alpnSelector);
            return;
        }
        this.selectionListener = jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols());
        this.alpnSelector = null;
        JdkAlpnSslUtils.setApplicationProtocols(sSLEngine, jdkApplicationProtocolNegotiator.protocols());
    }

    private SSLEngineResult verifyProtocolSelection(SSLEngineResult sSLEngineResult) throws SSLException {
        if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.alpnSelector == null) {
                try {
                    String string = this.getApplicationProtocol();
                    assert (string != null);
                    if (string.isEmpty()) {
                        this.selectionListener.unsupported();
                    }
                    this.selectionListener.selected(string);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw SslUtils.toSSLHandshakeException(throwable);
                }
            } else {
                assert (this.selectionListener == null);
                this.alpnSelector.checkUnsupported();
            }
        }
        return sSLEngineResult;
    }

    @Override
    public final SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.wrap(byteBuffer, byteBuffer2));
    }

    @Override
    public final SSLEngineResult wrap(ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) throws SSLException {
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.wrap(byteBufferArray, byteBuffer));
    }

    @Override
    public final SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n2, int n3, ByteBuffer byteBuffer) throws SSLException {
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.wrap(byteBufferArray, n2, n3, byteBuffer));
    }

    @Override
    public final SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.unwrap(byteBuffer, byteBuffer2));
    }

    @Override
    public final SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) throws SSLException {
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.unwrap(byteBuffer, byteBufferArray));
    }

    @Override
    public final SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n2, int n3) throws SSLException {
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.unwrap(byteBuffer, byteBufferArray, n2, n3));
    }

    @Override
    final void setNegotiatedApplicationProtocol(String string) {
    }

    @Override
    public final String getNegotiatedApplicationProtocol() {
        String string = this.getApplicationProtocol();
        if (string != null) {
            if (string.isEmpty()) {
                return null;
            }
            return string;
        }
        return null;
    }

    @Override
    public final String getApplicationProtocol() {
        return JdkAlpnSslUtils.getApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public final String getHandshakeApplicationProtocol() {
        return JdkAlpnSslUtils.getHandshakeApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public final void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> biFunction) {
        JdkAlpnSslUtils.setHandshakeApplicationProtocolSelector(this.getWrappedEngine(), biFunction);
    }

    @Override
    public final BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return JdkAlpnSslUtils.getHandshakeApplicationProtocolSelector(this.getWrappedEngine());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AlpnSelector
    implements BiFunction<SSLEngine, List<String>, String> {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector selector;
        private boolean called;

        AlpnSelector(JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector) {
            this.selector = protocolSelector;
        }

        @Override
        public final String apply(SSLEngine object, List<String> list) {
            assert (!this.called);
            this.called = true;
            try {
                object = this.selector.select(list);
                if (object == null) {
                    return "";
                }
                return object;
            }
            catch (Exception exception) {
                return null;
            }
        }

        final void checkUnsupported() {
            if (this.called) {
                return;
            }
            String string = JdkAlpnSslEngine.this.getApplicationProtocol();
            assert (string != null);
            if (string.isEmpty()) {
                this.selector.unsupported();
            }
        }
    }
}

