/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.ssl;

import com.appoptics.ext.io.netty.handler.ssl.ConscryptAlpnSslEngine;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;

final class Conscrypt {
    private static final Method IS_CONSCRYPT_SSLENGINE = Conscrypt.loadIsConscryptEngine();
    private static final boolean CAN_INSTANCE_PROVIDER = Conscrypt.canInstanceProvider();

    private static Method loadIsConscryptEngine() {
        try {
            Class<?> clazz = Class.forName("com.appoptics.ext.org.conscrypt.Conscrypt", true, ConscryptAlpnSslEngine.class.getClassLoader());
            return clazz.getMethod("isConscrypt", SSLEngine.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static boolean canInstanceProvider() {
        try {
            Class<?> clazz = Class.forName("com.appoptics.ext.org.conscrypt.OpenSSLProvider", true, ConscryptAlpnSslEngine.class.getClassLoader());
            clazz.newInstance();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean isAvailable() {
        return CAN_INSTANCE_PROVIDER && IS_CONSCRYPT_SSLENGINE != null && (PlatformDependent.javaVersion() >= 8 && PlatformDependent.javaVersion() < 15 || PlatformDependent.isAndroid());
    }

    static boolean isEngineSupported(SSLEngine sSLEngine) {
        return Conscrypt.isAvailable() && Conscrypt.isConscryptEngine(sSLEngine);
    }

    private static boolean isConscryptEngine(SSLEngine sSLEngine) {
        try {
            return (Boolean)IS_CONSCRYPT_SSLENGINE.invoke(null, sSLEngine);
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }
}

