/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.handler.codec.http2.StreamByteDistributor;
import com.appoptics.ext.io.netty.util.collection.IntCollections;
import com.appoptics.ext.io.netty.util.collection.IntObjectHashMap;
import com.appoptics.ext.io.netty.util.collection.IntObjectMap;
import com.appoptics.ext.io.netty.util.internal.DefaultPriorityQueue;
import com.appoptics.ext.io.netty.util.internal.EmptyPriorityQueue;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PriorityQueue;
import com.appoptics.ext.io.netty.util.internal.PriorityQueueNode;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeightedFairQueueByteDistributor
implements StreamByteDistributor {
    static final int INITIAL_CHILDREN_MAP_SIZE = Math.max(1, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.http2.childrenMapSize", 2));
    private final Http2Connection.PropertyKey stateKey;
    private final IntObjectMap<State> stateOnlyMap;
    private final PriorityQueue<State> stateOnlyRemovalQueue;
    private final Http2Connection connection;
    private final State connectionState;
    private int allocationQuantum = 1024;
    private final int maxStateOnlySize;

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection) {
        this(http2Connection, 5);
    }

    public WeightedFairQueueByteDistributor(Http2Connection http2Connection, int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "maxStateOnlySize");
        if (n2 == 0) {
            this.stateOnlyMap = IntCollections.emptyMap();
            this.stateOnlyRemovalQueue = EmptyPriorityQueue.instance();
        } else {
            this.stateOnlyMap = new IntObjectHashMap<State>(n2);
            this.stateOnlyRemovalQueue = new DefaultPriorityQueue<State>(StateOnlyComparator.INSTANCE, n2 + 2);
        }
        this.maxStateOnlySize = n2;
        this.connection = http2Connection;
        this.stateKey = http2Connection.newKey();
        Http2Stream http2Stream = http2Connection.connectionStream();
        this.connectionState = new State(http2Stream, 16);
        http2Stream.setProperty(this.stateKey, this.connectionState);
        http2Connection.addListener(new Http2ConnectionAdapter(){

            public void onStreamAdded(Http2Stream http2Stream) {
                State state = (State)WeightedFairQueueByteDistributor.this.stateOnlyMap.remove(http2Stream.id());
                if (state == null) {
                    state = new State(http2Stream);
                    ArrayList<ParentChangedEvent> arrayList = new ArrayList<ParentChangedEvent>(1);
                    WeightedFairQueueByteDistributor.this.connectionState.takeChild(state, false, arrayList);
                    WeightedFairQueueByteDistributor.this.notifyParentChanged(arrayList);
                } else {
                    WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.removeTyped(state);
                    state.stream = http2Stream;
                }
                switch (http2Stream.state()) {
                    case RESERVED_REMOTE: 
                    case RESERVED_LOCAL: {
                        state.setStreamReservedOrActivated();
                    }
                }
                http2Stream.setProperty(WeightedFairQueueByteDistributor.this.stateKey, state);
            }

            public void onStreamActive(Http2Stream http2Stream) {
                WeightedFairQueueByteDistributor.this.state(http2Stream).setStreamReservedOrActivated();
            }

            public void onStreamClosed(Http2Stream http2Stream) {
                WeightedFairQueueByteDistributor.this.state(http2Stream).close();
            }

            public void onStreamRemoved(Http2Stream object) {
                object = WeightedFairQueueByteDistributor.this.state((Http2Stream)object);
                v0.stream = null;
                if (WeightedFairQueueByteDistributor.this.maxStateOnlySize == 0) {
                    ((State)object).parent.removeChild((State)object);
                    return;
                }
                if (WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.size() == WeightedFairQueueByteDistributor.this.maxStateOnlySize) {
                    State state = (State)WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.peek();
                    if (StateOnlyComparator.INSTANCE.compare(state, (State)object) >= 0) {
                        ((State)object).parent.removeChild((State)object);
                        return;
                    }
                    WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.poll();
                    state.parent.removeChild(state);
                    WeightedFairQueueByteDistributor.this.stateOnlyMap.remove(state.streamId);
                }
                WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue.add(object);
                WeightedFairQueueByteDistributor.this.stateOnlyMap.put(((State)object).streamId, object);
            }
        });
    }

    @Override
    public final void updateStreamableBytes(StreamByteDistributor.StreamState streamState) {
        this.state(streamState.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(streamState), streamState.hasFrame() && streamState.windowSize() >= 0);
    }

    @Override
    public final void updateDependencyTree(int n2, int n3, short s2, boolean bl) {
        State state;
        State state2 = this.state(n2);
        if (state2 == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            state2 = new State(n2);
            this.stateOnlyRemovalQueue.add(state2);
            this.stateOnlyMap.put(n2, state2);
        }
        if ((state = this.state(n3)) == null) {
            if (this.maxStateOnlySize == 0) {
                return;
            }
            state = new State(n3);
            this.stateOnlyRemovalQueue.add(state);
            this.stateOnlyMap.put(n3, state);
            ArrayList<ParentChangedEvent> arrayList = new ArrayList<ParentChangedEvent>(1);
            this.connectionState.takeChild(state, false, arrayList);
            this.notifyParentChanged(arrayList);
        }
        if (state2.activeCountForTree != 0 && state2.parent != null) {
            state2.parent.totalQueuedWeights += (long)(s2 - state2.weight);
        }
        state2.weight = s2;
        if (state != state2.parent || bl && state.children.size() != 1) {
            ArrayList<ParentChangedEvent> arrayList;
            if (state.isDescendantOf(state2)) {
                arrayList = new ArrayList<ParentChangedEvent>(2 + (bl ? state.children.size() : 0));
                state2.parent.takeChild(state, false, arrayList);
            } else {
                arrayList = new ArrayList(1 + (bl ? state.children.size() : 0));
            }
            state.takeChild(state2, bl, arrayList);
            this.notifyParentChanged(arrayList);
        }
        while (this.stateOnlyRemovalQueue.size() > this.maxStateOnlySize) {
            State state3 = (State)this.stateOnlyRemovalQueue.poll();
            state3.parent.removeChild(state3);
            this.stateOnlyMap.remove(state3.streamId);
        }
    }

    @Override
    public final boolean distribute(int n2, StreamByteDistributor.Writer writer) throws Http2Exception {
        int n3;
        if (this.connectionState.activeCountForTree == 0) {
            return false;
        }
        do {
            n3 = this.connectionState.activeCountForTree;
            n2 -= this.distributeToChildren(n2, writer, this.connectionState);
        } while (this.connectionState.activeCountForTree != 0 && (n2 > 0 || n3 != this.connectionState.activeCountForTree));
        return this.connectionState.activeCountForTree != 0;
    }

    public final void allocationQuantum(int n2) {
        ObjectUtil.checkPositive(n2, "allocationQuantum");
        this.allocationQuantum = n2;
    }

    private int distribute(int n2, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        if (state.isActive()) {
            int n3 = Math.min(n2, state.streamableBytes);
            state.write(n3, writer);
            if (n3 == 0 && n2 != 0) {
                State state2 = state;
                state2.updateStreamableBytes(state2.streamableBytes, false);
            }
            return n3;
        }
        return this.distributeToChildren(n2, writer, state);
    }

    private int distributeToChildren(int n2, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        long l2 = state.totalQueuedWeights;
        State state2 = state.pollPseudoTimeQueue();
        State state3 = state.peekPseudoTimeQueue();
        state2.setDistributing();
        try {
            assert (state3 == null || state3.pseudoTimeToWrite >= state2.pseudoTimeToWrite) : "nextChildState[" + state3.streamId + "].pseudoTime(" + state3.pseudoTimeToWrite + ") <  childState[" + state2.streamId + "].pseudoTime(" + state2.pseudoTimeToWrite + ")";
            n2 = this.distribute(state3 == null ? n2 : Math.min(n2, (int)Math.min((state3.pseudoTimeToWrite - state2.pseudoTimeToWrite) * (long)state2.weight / l2 + (long)this.allocationQuantum, Integer.MAX_VALUE)), writer, state2);
            state.pseudoTime += (long)n2;
            state2.updatePseudoTime(state, n2, l2);
            return n2;
        }
        finally {
            state2.unsetDistributing();
            if (state2.activeCountForTree != 0) {
                state.offerPseudoTimeQueue(state2);
            }
        }
    }

    private State state(Http2Stream http2Stream) {
        return (State)http2Stream.getProperty(this.stateKey);
    }

    private State state(int n2) {
        Http2Stream http2Stream = this.connection.stream(n2);
        if (http2Stream != null) {
            return this.state(http2Stream);
        }
        return this.stateOnlyMap.get(n2);
    }

    final void notifyParentChanged(List<ParentChangedEvent> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ParentChangedEvent parentChangedEvent = list.get(i2);
            this.stateOnlyRemovalQueue.priorityChanged(parentChangedEvent.state);
            if (parentChangedEvent.state.parent == null || parentChangedEvent.state.activeCountForTree == 0) continue;
            parentChangedEvent.state.parent.offerAndInitializePseudoTime(parentChangedEvent.state);
            parentChangedEvent.state.parent.activeCountChangeForTree(parentChangedEvent.state.activeCountForTree);
        }
    }

    private static final class ParentChangedEvent {
        final State state;
        final State oldParent;

        ParentChangedEvent(State state, State state2) {
            this.state = state;
            this.oldParent = state2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class State
    implements PriorityQueueNode {
        Http2Stream stream;
        State parent;
        IntObjectMap<State> children = IntCollections.emptyMap();
        private final PriorityQueue<State> pseudoTimeQueue;
        final int streamId;
        int streamableBytes;
        int dependencyTreeDepth;
        int activeCountForTree;
        private int pseudoTimeQueueIndex = -1;
        private int stateOnlyQueueIndex = -1;
        long pseudoTimeToWrite;
        long pseudoTime;
        long totalQueuedWeights;
        private byte flags;
        short weight = (short)16;

        State(int n2) {
            this(n2, null, 0);
        }

        State(Http2Stream http2Stream) {
            this(http2Stream, 0);
        }

        State(Http2Stream http2Stream, int n2) {
            this(http2Stream.id(), http2Stream, n2);
        }

        State(int n2, Http2Stream http2Stream, int n3) {
            this.stream = http2Stream;
            this.streamId = n2;
            this.pseudoTimeQueue = new DefaultPriorityQueue<State>(StatePseudoTimeComparator.INSTANCE, n3);
        }

        final boolean isDescendantOf(State state) {
            State state2 = this.parent;
            while (state2 != null) {
                if (state2 == state) {
                    return true;
                }
                state2 = state2.parent;
            }
            return false;
        }

        final void takeChild(State state, boolean bl, List<ParentChangedEvent> list) {
            this.takeChild(null, state, bl, list);
        }

        final void takeChild(Iterator<IntObjectMap.PrimitiveEntry<State>> object, State state, boolean bl, List<ParentChangedEvent> list) {
            State state2 = state.parent;
            if (state2 != this) {
                list.add(new ParentChangedEvent(state, state2));
                state.setParent(this);
                if (object != null) {
                    object.remove();
                } else if (state2 != null) {
                    state2.children.remove(state.streamId);
                }
                this.initChildrenIfEmpty();
                object = this.children.put(state.streamId, state);
                assert (object == null) : "A stream with the same stream ID was already in the child map.";
            }
            if (bl && !this.children.isEmpty()) {
                object = this.removeAllChildrenExcept(state).entries().iterator();
                while (object.hasNext()) {
                    Iterator<IntObjectMap.PrimitiveEntry<State>> iterator = object;
                    state.takeChild(iterator, iterator.next().value(), false, list);
                }
            }
        }

        final void removeChild(State object) {
            if (this.children.remove(((State)object).streamId) != null) {
                ArrayList<ParentChangedEvent> arrayList = new ArrayList<ParentChangedEvent>(1 + ((State)object).children.size());
                State state = object;
                arrayList.add(new ParentChangedEvent(state, state.parent));
                ((State)object).setParent(null);
                object = ((State)object).children.entries().iterator();
                while (object.hasNext()) {
                    Object object2 = object;
                    this.takeChild((Iterator<IntObjectMap.PrimitiveEntry<State>>)object2, (State)((IntObjectMap.PrimitiveEntry)object2.next()).value(), false, arrayList);
                }
                WeightedFairQueueByteDistributor.this.notifyParentChanged(arrayList);
            }
        }

        private IntObjectMap<State> removeAllChildrenExcept(State state) {
            state = this.children.remove(state.streamId);
            IntObjectMap<State> intObjectMap = this.children;
            this.initChildren();
            if (state != null) {
                this.children.put(state.streamId, state);
            }
            return intObjectMap;
        }

        private void setParent(State state) {
            if (this.activeCountForTree != 0 && this.parent != null) {
                this.parent.removePseudoTimeQueue(this);
                this.parent.activeCountChangeForTree(-this.activeCountForTree);
            }
            this.parent = state;
            this.dependencyTreeDepth = state == null ? Integer.MAX_VALUE : state.dependencyTreeDepth + 1;
        }

        private void initChildrenIfEmpty() {
            if (this.children == IntCollections.emptyMap()) {
                this.initChildren();
            }
        }

        private void initChildren() {
            this.children = new IntObjectHashMap<State>(INITIAL_CHILDREN_MAP_SIZE);
        }

        final void write(int n2, StreamByteDistributor.Writer writer) throws Http2Exception {
            assert (this.stream != null);
            try {
                writer.write(this.stream, n2);
                return;
            }
            catch (Throwable throwable) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "byte distribution write error", new Object[0]);
            }
        }

        final void activeCountChangeForTree(int n2) {
            while (true) {
                assert (state.activeCountForTree + n2 >= 0);
                state.activeCountForTree += n2;
                if (state.parent == null) break;
                assert (state.activeCountForTree != n2 || state.pseudoTimeQueueIndex == -1 || state.parent.pseudoTimeQueue.containsTyped(state)) : "State[" + state.streamId + "].activeCountForTree changed from 0 to " + n2 + " is in a pseudoTimeQueue, but not in parent[ " + state.parent.streamId + "]'s pseudoTimeQueue";
                if (state.activeCountForTree == 0) {
                    state.parent.removePseudoTimeQueue(state);
                } else if (state.activeCountForTree == n2 && !state.isDistributing()) {
                    state.parent.offerAndInitializePseudoTime(state);
                }
                State state = state.parent;
            }
        }

        final void updateStreamableBytes(int n2, boolean bl) {
            if (this.isActive() != bl) {
                if (bl) {
                    this.activeCountChangeForTree(1);
                    this.setActive();
                } else {
                    this.activeCountChangeForTree(-1);
                    this.unsetActive();
                }
            }
            this.streamableBytes = n2;
        }

        final void updatePseudoTime(State state, int n2, long l2) {
            assert (this.streamId != 0 && n2 >= 0);
            this.pseudoTimeToWrite = Math.min(this.pseudoTimeToWrite, state.pseudoTime) + (long)n2 * l2 / (long)this.weight;
        }

        final void offerAndInitializePseudoTime(State state) {
            state.pseudoTimeToWrite = this.pseudoTime;
            this.offerPseudoTimeQueue(state);
        }

        final void offerPseudoTimeQueue(State state) {
            this.pseudoTimeQueue.offer(state);
            this.totalQueuedWeights += (long)state.weight;
        }

        final State pollPseudoTimeQueue() {
            State state = (State)this.pseudoTimeQueue.poll();
            this.totalQueuedWeights -= (long)state.weight;
            return state;
        }

        final void removePseudoTimeQueue(State state) {
            if (this.pseudoTimeQueue.removeTyped(state)) {
                this.totalQueuedWeights -= (long)state.weight;
            }
        }

        final State peekPseudoTimeQueue() {
            return (State)this.pseudoTimeQueue.peek();
        }

        final void close() {
            this.updateStreamableBytes(0, false);
            this.stream = null;
        }

        final boolean wasStreamReservedOrActivated() {
            return (this.flags & 4) != 0;
        }

        final void setStreamReservedOrActivated() {
            this.flags = (byte)(this.flags | 4);
        }

        final boolean isActive() {
            return (this.flags & 1) != 0;
        }

        private void setActive() {
            this.flags = (byte)(this.flags | 1);
        }

        private void unsetActive() {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
        }

        final boolean isDistributing() {
            return (this.flags & 2) != 0;
        }

        final void setDistributing() {
            this.flags = (byte)(this.flags | 2);
        }

        final void unsetDistributing() {
            this.flags = (byte)(this.flags & 0xFFFFFFFD);
        }

        @Override
        public final int priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue) {
            if (defaultPriorityQueue == WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue) {
                return this.stateOnlyQueueIndex;
            }
            return this.pseudoTimeQueueIndex;
        }

        @Override
        public final void priorityQueueIndex(DefaultPriorityQueue<?> defaultPriorityQueue, int n2) {
            if (defaultPriorityQueue == WeightedFairQueueByteDistributor.this.stateOnlyRemovalQueue) {
                this.stateOnlyQueueIndex = n2;
                return;
            }
            this.pseudoTimeQueueIndex = n2;
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder(256 * (this.activeCountForTree > 0 ? this.activeCountForTree : 1));
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        private void toString(StringBuilder stringBuilder) {
            stringBuilder.append("{streamId ").append(this.streamId).append(" streamableBytes ").append(this.streamableBytes).append(" activeCountForTree ").append(this.activeCountForTree).append(" pseudoTimeQueueIndex ").append(this.pseudoTimeQueueIndex).append(" pseudoTimeToWrite ").append(this.pseudoTimeToWrite).append(" pseudoTime ").append(this.pseudoTime).append(" flags ").append(this.flags).append(" pseudoTimeQueue.size() ").append(this.pseudoTimeQueue.size()).append(" stateOnlyQueueIndex ").append(this.stateOnlyQueueIndex).append(" parent.streamId ").append(this.parent == null ? -1 : this.parent.streamId).append("} [");
            if (!this.pseudoTimeQueue.isEmpty()) {
                for (State state : this.pseudoTimeQueue) {
                    state.toString(stringBuilder);
                    stringBuilder.append(", ");
                }
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.setLength(stringBuilder2.length() - 2);
            }
            stringBuilder.append(']');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StatePseudoTimeComparator
    implements Serializable,
    Comparator<State> {
        private static final long serialVersionUID = -1437548640227161828L;
        static final StatePseudoTimeComparator INSTANCE = new StatePseudoTimeComparator();

        private StatePseudoTimeComparator() {
        }

        @Override
        public final int compare(State state, State state2) {
            return MathUtil.compare(state.pseudoTimeToWrite, state2.pseudoTimeToWrite);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StateOnlyComparator
    implements Serializable,
    Comparator<State> {
        private static final long serialVersionUID = -4806936913002105966L;
        static final StateOnlyComparator INSTANCE = new StateOnlyComparator();

        private StateOnlyComparator() {
        }

        @Override
        public final int compare(State state, State state2) {
            int n2 = state.wasStreamReservedOrActivated();
            if (n2 != state2.wasStreamReservedOrActivated()) {
                if (n2 != 0) {
                    return -1;
                }
                return 1;
            }
            n2 = state2.dependencyTreeDepth - state.dependencyTreeDepth;
            if (n2 != 0) {
                return n2;
            }
            return state.streamId - state2.streamId;
        }
    }
}

