/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Http2Exception
extends Exception {
    private static final long serialVersionUID = -6941186345430164209L;
    private final Http2Error error;
    private final ShutdownHint shutdownHint;

    public Http2Exception(Http2Error http2Error) {
        this(http2Error, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, ShutdownHint shutdownHint) {
        this.error = ObjectUtil.checkNotNull(http2Error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(shutdownHint, "shutdownHint");
    }

    public Http2Exception(Http2Error http2Error, String string) {
        this(http2Error, string, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, String string, ShutdownHint shutdownHint) {
        super(string);
        this.error = ObjectUtil.checkNotNull(http2Error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(shutdownHint, "shutdownHint");
    }

    public Http2Exception(Http2Error http2Error, String string, Throwable throwable) {
        this(http2Error, string, throwable, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, String string, Throwable throwable, ShutdownHint shutdownHint) {
        super(string, throwable);
        this.error = ObjectUtil.checkNotNull(http2Error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(shutdownHint, "shutdownHint");
    }

    static Http2Exception newStatic(Http2Error http2Error, String string, ShutdownHint shutdownHint) {
        if (PlatformDependent.javaVersion() >= 7) {
            return new Http2Exception(http2Error, string, shutdownHint, true);
        }
        return new Http2Exception(http2Error, string, shutdownHint);
    }

    private Http2Exception(Http2Error http2Error, String string, ShutdownHint shutdownHint, boolean bl) {
        super(string, null, false, true);
        assert (bl);
        this.error = ObjectUtil.checkNotNull(http2Error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(shutdownHint, "shutdownHint");
    }

    public Http2Error error() {
        return this.error;
    }

    public ShutdownHint shutdownHint() {
        return this.shutdownHint;
    }

    public static Http2Exception connectionError(Http2Error http2Error, String string, Object ... objectArray) {
        return new Http2Exception(http2Error, String.format(string, objectArray));
    }

    public static Http2Exception connectionError(Http2Error http2Error, Throwable throwable, String string, Object ... objectArray) {
        return new Http2Exception(http2Error, String.format(string, objectArray), throwable);
    }

    public static Http2Exception closedStreamError(Http2Error http2Error, String string, Object ... objectArray) {
        return new ClosedStreamCreationException(http2Error, String.format(string, objectArray));
    }

    public static Http2Exception streamError(int n2, Http2Error http2Error, String string, Object ... objectArray) {
        if (n2 == 0) {
            return Http2Exception.connectionError(http2Error, string, objectArray);
        }
        return new StreamException(n2, http2Error, String.format(string, objectArray));
    }

    public static Http2Exception streamError(int n2, Http2Error http2Error, Throwable throwable, String string, Object ... objectArray) {
        if (n2 == 0) {
            return Http2Exception.connectionError(http2Error, throwable, string, objectArray);
        }
        return new StreamException(n2, http2Error, String.format(string, objectArray), throwable);
    }

    public static Http2Exception headerListSizeError(int n2, Http2Error http2Error, boolean bl, String string, Object ... objectArray) {
        if (n2 == 0) {
            return Http2Exception.connectionError(http2Error, string, objectArray);
        }
        return new HeaderListSizeException(n2, http2Error, String.format(string, objectArray), bl);
    }

    public static boolean isStreamError(Http2Exception http2Exception) {
        return http2Exception instanceof StreamException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CompositeStreamException
    extends Http2Exception
    implements Iterable<StreamException> {
        private static final long serialVersionUID = 7091134858213711015L;
        private final List<StreamException> exceptions;

        public CompositeStreamException(Http2Error http2Error, int n2) {
            super(http2Error, ShutdownHint.NO_SHUTDOWN);
            this.exceptions = new ArrayList<StreamException>(n2);
        }

        public final void add(StreamException streamException) {
            this.exceptions.add(streamException);
        }

        @Override
        public final Iterator<StreamException> iterator() {
            return this.exceptions.iterator();
        }
    }

    public static final class HeaderListSizeException
    extends StreamException {
        private static final long serialVersionUID = -8807603212183882637L;
        private final boolean decode;

        HeaderListSizeException(int n2, Http2Error http2Error, String string, boolean bl) {
            super(n2, http2Error, string);
            this.decode = bl;
        }

        public final boolean duringDecode() {
            return this.decode;
        }
    }

    public static class StreamException
    extends Http2Exception {
        private static final long serialVersionUID = 602472544416984384L;
        private final int streamId;

        StreamException(int n2, Http2Error http2Error, String string) {
            super(http2Error, string, ShutdownHint.NO_SHUTDOWN);
            this.streamId = n2;
        }

        StreamException(int n2, Http2Error http2Error, String string, Throwable throwable) {
            super(http2Error, string, throwable, ShutdownHint.NO_SHUTDOWN);
            this.streamId = n2;
        }

        public int streamId() {
            return this.streamId;
        }
    }

    public static final class ClosedStreamCreationException
    extends Http2Exception {
        private static final long serialVersionUID = -6746542974372246206L;

        public ClosedStreamCreationException(Http2Error http2Error, String string) {
            super(http2Error, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShutdownHint {
        NO_SHUTDOWN,
        GRACEFUL_SHUTDOWN,
        HARD_SHUTDOWN;

    }
}

