/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.base64.Base64;
import com.appoptics.ext.io.netty.handler.codec.base64.Base64Dialect;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import com.appoptics.ext.io.netty.handler.codec.http.HttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionHandler;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2MultiplexHandler;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.collection.CharObjectMap;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Http2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler upgradeToHandler;
    private final ChannelHandler http2MultiplexHandler;

    public Http2ClientUpgradeCodec(Http2ConnectionHandler http2ConnectionHandler) {
        this(null, http2ConnectionHandler);
    }

    public Http2ClientUpgradeCodec(String string, Http2ConnectionHandler http2ConnectionHandler) {
        Http2ConnectionHandler http2ConnectionHandler2 = http2ConnectionHandler;
        this(string, http2ConnectionHandler2, http2ConnectionHandler2, null);
    }

    private Http2ClientUpgradeCodec(String string, Http2ConnectionHandler http2ConnectionHandler, ChannelHandler channelHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this.handlerName = string;
        this.connectionHandler = ObjectUtil.checkNotNull(http2ConnectionHandler, "connectionHandler");
        this.upgradeToHandler = ObjectUtil.checkNotNull(channelHandler, "upgradeToHandler");
        this.http2MultiplexHandler = http2MultiplexHandler;
    }

    @Override
    public CharSequence protocol() {
        return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
    }

    @Override
    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext object, HttpRequest httpRequest) {
        object = this.getSettingsHeaderValue((ChannelHandlerContext)object);
        httpRequest.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, object);
        return UPGRADE_HEADERS;
    }

    @Override
    public void upgradeTo(ChannelHandlerContext channelHandlerContext, FullHttpResponse object) throws Exception {
        try {
            channelHandlerContext.pipeline().addAfter(channelHandlerContext.name(), this.handlerName, this.upgradeToHandler);
            if (this.http2MultiplexHandler != null) {
                object = channelHandlerContext.pipeline().context(this.connectionHandler).name();
                channelHandlerContext.pipeline().addAfter((String)object, null, this.http2MultiplexHandler);
            }
            this.connectionHandler.onHttpClientUpgrade();
            return;
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught(http2Exception);
            channelHandlerContext.close();
            return;
        }
    }

    private CharSequence getSettingsHeaderValue(ChannelHandlerContext object) {
        ByteBuf byteBuf = null;
        ByteBuf byteBuf2 = null;
        try {
            Http2Settings object22 = this.connectionHandler.decoder().localSettings();
            int n2 = 6 * object22.size();
            byteBuf = object.alloc().buffer(n2);
            for (CharObjectMap.PrimitiveEntry primitiveEntry : object22.entries()) {
                byteBuf.writeChar(primitiveEntry.key());
                byteBuf.writeInt(((Long)primitiveEntry.value()).intValue());
            }
            byteBuf2 = Base64.encode(byteBuf, Base64Dialect.URL_SAFE);
            object = byteBuf2.toString(CharsetUtil.UTF_8);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(byteBuf);
            ReferenceCountUtil.release(byteBuf2);
            throw throwable;
        }
        ReferenceCountUtil.release(byteBuf);
        ReferenceCountUtil.release(byteBuf2);
        return object;
    }
}

