/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.handler.codec.http2.HpackHeaderField;

final class HpackDynamicTable {
    HpackHeaderField[] hpackHeaderFields;
    int head;
    int tail;
    private long size;
    private long capacity = -1L;

    HpackDynamicTable(long l2) {
        this.setCapacity(l2);
    }

    public final int length() {
        int n2 = this.head < this.tail ? this.hpackHeaderFields.length - this.tail + this.head : this.head - this.tail;
        return n2;
    }

    public final long capacity() {
        return this.capacity;
    }

    public final HpackHeaderField getEntry(int n2) {
        if (n2 <= 0 || n2 > this.length()) {
            throw new IndexOutOfBoundsException("Index " + n2 + " out of bounds for length " + this.length());
        }
        if ((n2 = this.head - n2) < 0) {
            return this.hpackHeaderFields[n2 + this.hpackHeaderFields.length];
        }
        return this.hpackHeaderFields[n2];
    }

    public final void add(HpackHeaderField hpackHeaderField) {
        int n2 = hpackHeaderField.size();
        if ((long)n2 > this.capacity) {
            this.clear();
            return;
        }
        while (this.capacity - this.size < (long)n2) {
            this.remove();
        }
        this.hpackHeaderFields[this.head++] = hpackHeaderField;
        this.size += (long)hpackHeaderField.size();
        if (this.head == this.hpackHeaderFields.length) {
            this.head = 0;
        }
    }

    public final HpackHeaderField remove() {
        HpackHeaderField hpackHeaderField = this.hpackHeaderFields[this.tail];
        if (hpackHeaderField == null) {
            return null;
        }
        this.size -= (long)hpackHeaderField.size();
        this.hpackHeaderFields[this.tail++] = null;
        if (this.tail == this.hpackHeaderFields.length) {
            this.tail = 0;
        }
        return hpackHeaderField;
    }

    public final void clear() {
        while (this.tail != this.head) {
            this.hpackHeaderFields[this.tail++] = null;
            if (this.tail != this.hpackHeaderFields.length) continue;
            this.tail = 0;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0L;
    }

    public final void setCapacity(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("capacity is invalid: " + l2);
        }
        if (this.capacity == l2) {
            return;
        }
        this.capacity = l2;
        if (l2 == 0L) {
            this.clear();
        } else {
            while (this.size > l2) {
                this.remove();
            }
        }
        int n2 = (int)(l2 / 32L);
        if (l2 % 32L != 0L) {
            ++n2;
        }
        if (this.hpackHeaderFields != null && this.hpackHeaderFields.length == n2) {
            return;
        }
        HpackHeaderField[] hpackHeaderFieldArray = new HpackHeaderField[n2];
        int n3 = this.length();
        n2 = this.tail;
        for (int i2 = 0; i2 < n3; ++i2) {
            HpackHeaderField hpackHeaderField;
            hpackHeaderFieldArray[i2] = hpackHeaderField = this.hpackHeaderFields[n2++];
            if (n2 != this.hpackHeaderFields.length) continue;
            n2 = 0;
        }
        this.tail = 0;
        this.head = this.tail + n3;
        this.hpackHeaderFields = hpackHeaderFieldArray;
    }
}

