/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2RemoteFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamVisitor;
import com.appoptics.ext.io.netty.handler.codec.http2.StreamByteDistributor;
import com.appoptics.ext.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;

public class DefaultHttp2RemoteFlowController
implements Http2RemoteFlowController {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2RemoteFlowController.class);
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private final StreamByteDistributor streamByteDistributor;
    private final FlowState connectionState;
    private int initialWindowSize = 65535;
    private WritabilityMonitor monitor;
    private ChannelHandlerContext ctx;

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection) {
        this(http2Connection, (Http2RemoteFlowController.Listener)null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, StreamByteDistributor streamByteDistributor) {
        this(http2Connection, streamByteDistributor, null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, Http2RemoteFlowController.Listener listener) {
        this(http2Connection, new WeightedFairQueueByteDistributor(http2Connection), listener);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, StreamByteDistributor streamByteDistributor, Http2RemoteFlowController.Listener listener) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.streamByteDistributor = ObjectUtil.checkNotNull(streamByteDistributor, "streamWriteDistributor");
        this.stateKey = http2Connection.newKey();
        this.connectionState = new FlowState(http2Connection.connectionStream());
        http2Connection.connectionStream().setProperty(this.stateKey, this.connectionState);
        this.listener(listener);
        this.monitor.windowSize(this.connectionState, this.initialWindowSize);
        http2Connection.addListener(new Http2ConnectionAdapter(){

            public void onStreamAdded(Http2Stream http2Stream) {
                http2Stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, new FlowState(http2Stream));
            }

            public void onStreamActive(Http2Stream http2Stream) {
                DefaultHttp2RemoteFlowController.this.monitor.windowSize(DefaultHttp2RemoteFlowController.this.state(http2Stream), DefaultHttp2RemoteFlowController.this.initialWindowSize);
            }

            public void onStreamClosed(Http2Stream http2Stream) {
                DefaultHttp2RemoteFlowController.this.state(http2Stream).cancel(Http2Error.STREAM_CLOSED, null);
            }

            public void onStreamHalfClosed(Http2Stream http2Stream) {
                if (Http2Stream.State.HALF_CLOSED_LOCAL == http2Stream.state()) {
                    DefaultHttp2RemoteFlowController.this.state(http2Stream).cancel(Http2Error.STREAM_CLOSED, null);
                }
            }
        });
    }

    public void channelHandlerContext(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
        this.ctx = ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
        this.channelWritabilityChanged();
        if (this.isChannelWritable()) {
            this.writePendingBytes();
        }
    }

    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }

    public void initialWindowSize(int n2) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.initialWindowSize(n2);
    }

    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    public int windowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).windowSize();
    }

    public void channelWritabilityChanged() throws Http2Exception {
        this.monitor.channelWritabilityChange();
    }

    public void updateDependencyTree(int n2, int n3, short s2, boolean bl) {
        assert (s2 > 0 && s2 <= 256) : "Invalid weight";
        assert (n2 != n3) : "A stream cannot depend on itself";
        assert (n2 > 0 && n3 >= 0) : "childStreamId must be > 0. parentStreamId must be >= 0.";
        this.streamByteDistributor.updateDependencyTree(n2, n3, s2, bl);
    }

    private boolean isChannelWritable() {
        return this.ctx != null && this.isChannelWritable0();
    }

    private boolean isChannelWritable0() {
        return this.ctx.channel().isWritable();
    }

    public void listener(Http2RemoteFlowController.Listener listener) {
        this.monitor = listener == null ? new WritabilityMonitor() : new ListenerWritabilityMonitor(listener);
    }

    public void incrementWindowSize(Http2Stream http2Stream, int n2) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.incrementWindowSize(this.state(http2Stream), n2);
    }

    public void addFlowControlled(Http2Stream http2Stream, Http2RemoteFlowController.FlowControlled flowControlled) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull(flowControlled, "frame");
        try {
            this.monitor.enqueueFrame(this.state(http2Stream), flowControlled);
            return;
        }
        catch (Throwable throwable) {
            flowControlled.error(this.ctx, throwable);
            return;
        }
    }

    public boolean hasFlowControlled(Http2Stream http2Stream) {
        return this.state(http2Stream).hasFrame();
    }

    private FlowState state(Http2Stream http2Stream) {
        return (FlowState)http2Stream.getProperty(this.stateKey);
    }

    private int connectionWindowSize() {
        return this.connectionState.windowSize();
    }

    private int minUsableChannelBytes() {
        return Math.max(this.ctx.channel().config().getWriteBufferLowWaterMark(), 32768);
    }

    private int maxUsableChannelBytes() {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.ctx.channel().bytesBeforeUnwritable());
        n2 = n2 > 0 ? Math.max(n2, this.minUsableChannelBytes()) : 0;
        return Math.min(this.connectionState.windowSize(), n2);
    }

    private int writableBytes() {
        return Math.min(this.connectionWindowSize(), this.maxUsableChannelBytes());
    }

    public void writePendingBytes() throws Http2Exception {
        this.monitor.writePendingBytes();
    }

    private final class ListenerWritabilityMonitor
    extends WritabilityMonitor
    implements Http2StreamVisitor {
        private final Http2RemoteFlowController.Listener listener;

        ListenerWritabilityMonitor(Http2RemoteFlowController.Listener listener) {
            this.listener = listener;
        }

        public final boolean visit(Http2Stream object) throws Http2Exception {
            if (this.isWritable((FlowState)(object = DefaultHttp2RemoteFlowController.this.state((Http2Stream)object))) != ((FlowState)object).markedWritability()) {
                this.notifyWritabilityChanged((FlowState)object);
            }
            return true;
        }

        final void windowSize(FlowState flowState, int n2) {
            super.windowSize(flowState, n2);
            try {
                this.checkStateWritability(flowState);
                return;
            }
            catch (Http2Exception http2Exception) {
                throw new RuntimeException("Caught unexpected exception from window", http2Exception);
            }
        }

        final void incrementWindowSize(FlowState flowState, int n2) throws Http2Exception {
            super.incrementWindowSize(flowState, n2);
            this.checkStateWritability(flowState);
        }

        final void initialWindowSize(int n2) throws Http2Exception {
            super.initialWindowSize(n2);
            if (this.isWritableConnection()) {
                this.checkAllWritabilityChanged();
            }
        }

        final void enqueueFrame(FlowState flowState, Http2RemoteFlowController.FlowControlled flowControlled) throws Http2Exception {
            super.enqueueFrame(flowState, flowControlled);
            this.checkConnectionThenStreamWritabilityChanged(flowState);
        }

        final void stateCancelled(FlowState flowState) {
            try {
                this.checkConnectionThenStreamWritabilityChanged(flowState);
                return;
            }
            catch (Http2Exception http2Exception) {
                throw new RuntimeException("Caught unexpected exception from checkAllWritabilityChanged", http2Exception);
            }
        }

        final void channelWritabilityChange() throws Http2Exception {
            if (DefaultHttp2RemoteFlowController.this.connectionState.markedWritability() != DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.checkAllWritabilityChanged();
            }
        }

        private void checkStateWritability(FlowState flowState) throws Http2Exception {
            if (this.isWritable(flowState) != flowState.markedWritability()) {
                if (flowState == DefaultHttp2RemoteFlowController.this.connectionState) {
                    this.checkAllWritabilityChanged();
                    return;
                }
                this.notifyWritabilityChanged(flowState);
            }
        }

        private void notifyWritabilityChanged(FlowState flowState) {
            FlowState flowState2 = flowState;
            flowState2.markedWritability(!flowState2.markedWritability());
            try {
                this.listener.writabilityChanged(flowState.stream);
                return;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener.writabilityChanged", throwable);
                return;
            }
        }

        private void checkConnectionThenStreamWritabilityChanged(FlowState flowState) throws Http2Exception {
            if (this.isWritableConnection() != DefaultHttp2RemoteFlowController.this.connectionState.markedWritability()) {
                this.checkAllWritabilityChanged();
                return;
            }
            if (this.isWritable(flowState) != flowState.markedWritability()) {
                this.notifyWritabilityChanged(flowState);
            }
        }

        private void checkAllWritabilityChanged() throws Http2Exception {
            DefaultHttp2RemoteFlowController.this.connectionState.markedWritability(this.isWritableConnection());
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(this);
        }
    }

    private class WritabilityMonitor
    implements StreamByteDistributor.Writer {
        private boolean inWritePendingBytes;
        private long totalPendingBytes;

        private WritabilityMonitor() {
        }

        public final void write(Http2Stream http2Stream, int n2) {
            DefaultHttp2RemoteFlowController.this.state(http2Stream).writeAllocatedBytes(n2);
        }

        void channelWritabilityChange() throws Http2Exception {
        }

        void stateCancelled(FlowState flowState) {
        }

        void windowSize(FlowState flowState, int n2) {
            flowState.windowSize(n2);
        }

        void incrementWindowSize(FlowState flowState, int n2) throws Http2Exception {
            flowState.incrementStreamWindow(n2);
        }

        void enqueueFrame(FlowState flowState, Http2RemoteFlowController.FlowControlled flowControlled) throws Http2Exception {
            flowState.enqueueFrame(flowControlled);
        }

        final void incrementPendingBytes(int n2) {
            this.totalPendingBytes += (long)n2;
        }

        final boolean isWritable(FlowState flowState) {
            return this.isWritableConnection() && flowState.isWritable();
        }

        final void writePendingBytes() throws Http2Exception {
            if (this.inWritePendingBytes) {
                return;
            }
            this.inWritePendingBytes = true;
            try {
                int n2 = DefaultHttp2RemoteFlowController.this.writableBytes();
                while (DefaultHttp2RemoteFlowController.this.streamByteDistributor.distribute(n2, this) && (n2 = DefaultHttp2RemoteFlowController.this.writableBytes()) > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable0()) {
                }
                return;
            }
            finally {
                this.inWritePendingBytes = false;
            }
        }

        void initialWindowSize(int n2) throws Http2Exception {
            ObjectUtil.checkPositiveOrZero(n2, "newWindowSize");
            final int n3 = n2 - DefaultHttp2RemoteFlowController.this.initialWindowSize;
            DefaultHttp2RemoteFlowController.this.initialWindowSize = n2;
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(new Http2StreamVisitor(){

                public boolean visit(Http2Stream http2Stream) throws Http2Exception {
                    DefaultHttp2RemoteFlowController.this.state(http2Stream).incrementStreamWindow(n3);
                    return true;
                }
            });
            if (n3 > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.writePendingBytes();
            }
        }

        final boolean isWritableConnection() {
            return (long)DefaultHttp2RemoteFlowController.this.connectionState.windowSize() - this.totalPendingBytes > 0L && DefaultHttp2RemoteFlowController.this.isChannelWritable();
        }
    }

    private final class FlowState
    implements StreamByteDistributor.StreamState {
        private final Http2Stream stream;
        private final Deque<Http2RemoteFlowController.FlowControlled> pendingWriteQueue;
        private int window;
        private long pendingBytes;
        private boolean markedWritable;
        private boolean writing;
        private boolean cancelled;

        FlowState(Http2Stream http2Stream) {
            this.stream = http2Stream;
            this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController.FlowControlled>(2);
        }

        final boolean isWritable() {
            return (long)this.windowSize() > this.pendingBytes() && !this.cancelled;
        }

        public final Http2Stream stream() {
            return this.stream;
        }

        final boolean markedWritability() {
            return this.markedWritable;
        }

        final void markedWritability(boolean bl) {
            this.markedWritable = bl;
        }

        public final int windowSize() {
            return this.window;
        }

        final void windowSize(int n2) {
            this.window = n2;
        }

        final int writeAllocatedBytes(int n2) {
            int n3 = n2;
            try {
                int n4;
                Http2RemoteFlowController.FlowControlled flowControlled;
                assert (!this.writing);
                this.writing = true;
                boolean bl = false;
                while (!(this.cancelled || (flowControlled = this.peek()) == null || (n4 = Math.min(n2, this.writableWindow())) <= 0 && flowControlled.size() > 0)) {
                    bl = true;
                    int n5 = flowControlled.size();
                    try {
                        flowControlled.write(DefaultHttp2RemoteFlowController.this.ctx, Math.max(0, n4));
                        if (flowControlled.size() != 0) continue;
                        this.pendingWriteQueue.remove();
                        flowControlled.writeComplete();
                    }
                    finally {
                        n2 -= n5 - flowControlled.size();
                    }
                }
                if (!bl) {
                    this.writing = false;
                    n2 = n3 - n2;
                    this.decrementPendingBytes(n2, false);
                    this.decrementFlowControlWindow(n2);
                    if (this.cancelled) {
                        this.cancel(Http2Error.INTERNAL_ERROR, null);
                    }
                    return -1;
                }
                this.writing = false;
                n2 = n3 - n2;
                this.decrementPendingBytes(n2, false);
                this.decrementFlowControlWindow(n2);
                if (this.cancelled) {
                    this.cancel(Http2Error.INTERNAL_ERROR, null);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.cancelled = true;
                    Throwable throwable2 = throwable;
                    this.writing = false;
                    n2 = n3 - n2;
                    this.decrementPendingBytes(n2, false);
                    this.decrementFlowControlWindow(n2);
                    if (this.cancelled) {
                        this.cancel(Http2Error.INTERNAL_ERROR, throwable2);
                    }
                }
                catch (Throwable throwable3) {
                    this.writing = false;
                    n2 = n3 - n2;
                    this.decrementPendingBytes(n2, false);
                    this.decrementFlowControlWindow(n2);
                    if (this.cancelled) {
                        this.cancel(Http2Error.INTERNAL_ERROR, null);
                    }
                    throw throwable3;
                }
            }
            return n2;
        }

        final int incrementStreamWindow(int n2) throws Http2Exception {
            if (n2 > 0 && Integer.MAX_VALUE - n2 < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
            }
            this.window += n2;
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            return this.window;
        }

        private int writableWindow() {
            return Math.min(this.window, DefaultHttp2RemoteFlowController.this.connectionWindowSize());
        }

        public final long pendingBytes() {
            return this.pendingBytes;
        }

        final void enqueueFrame(Http2RemoteFlowController.FlowControlled flowControlled) {
            Http2RemoteFlowController.FlowControlled flowControlled2 = this.pendingWriteQueue.peekLast();
            if (flowControlled2 == null) {
                this.enqueueFrameWithoutMerge(flowControlled);
                return;
            }
            int n2 = flowControlled2.size();
            if (flowControlled2.merge(DefaultHttp2RemoteFlowController.this.ctx, flowControlled)) {
                this.incrementPendingBytes(flowControlled2.size() - n2, true);
                return;
            }
            this.enqueueFrameWithoutMerge(flowControlled);
        }

        private void enqueueFrameWithoutMerge(Http2RemoteFlowController.FlowControlled flowControlled) {
            this.pendingWriteQueue.offer(flowControlled);
            this.incrementPendingBytes(flowControlled.size(), true);
        }

        public final boolean hasFrame() {
            return !this.pendingWriteQueue.isEmpty();
        }

        private Http2RemoteFlowController.FlowControlled peek() {
            return this.pendingWriteQueue.peek();
        }

        final void cancel(Http2Error object, Throwable throwable) {
            this.cancelled = true;
            if (this.writing) {
                return;
            }
            Http2RemoteFlowController.FlowControlled flowControlled = this.pendingWriteQueue.poll();
            if (flowControlled != null) {
                object = Http2Exception.streamError(this.stream.id(), object, throwable, "Stream closed before write could take place", new Object[0]);
                do {
                    this.writeError(flowControlled, (Http2Exception)object);
                } while ((flowControlled = this.pendingWriteQueue.poll()) != null);
            }
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            DefaultHttp2RemoteFlowController.this.monitor.stateCancelled(this);
        }

        private void incrementPendingBytes(int n2, boolean bl) {
            this.pendingBytes += (long)n2;
            DefaultHttp2RemoteFlowController.this.monitor.incrementPendingBytes(n2);
            if (bl) {
                DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            }
        }

        private void decrementPendingBytes(int n2, boolean bl) {
            this.incrementPendingBytes(-n2, bl);
        }

        private void decrementFlowControlWindow(int n2) {
            try {
                n2 = -n2;
                DefaultHttp2RemoteFlowController.this.connectionState.incrementStreamWindow(n2);
                this.incrementStreamWindow(n2);
                return;
            }
            catch (Http2Exception http2Exception) {
                throw new IllegalStateException("Invalid window state when writing frame: " + http2Exception.getMessage(), http2Exception);
            }
        }

        private void writeError(Http2RemoteFlowController.FlowControlled flowControlled, Http2Exception http2Exception) {
            assert (DefaultHttp2RemoteFlowController.this.ctx != null);
            this.decrementPendingBytes(flowControlled.size(), true);
            flowControlled.error(DefaultHttp2RemoteFlowController.this.ctx, http2Exception);
        }
    }
}

