/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.handler.codec.DecoderResult;
import com.appoptics.ext.io.netty.handler.codec.MessageAggregator;
import com.appoptics.ext.io.netty.handler.codec.TooLongFrameException;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpObject;
import com.appoptics.ext.io.netty.handler.codec.http.EmptyHttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpContent;
import com.appoptics.ext.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderValues;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessageUtil;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMethod;
import com.appoptics.ext.io.netty.handler.codec.http.HttpObject;
import com.appoptics.ext.io.netty.handler.codec.http.HttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseStatus;
import com.appoptics.ext.io.netty.handler.codec.http.HttpStatusClass;
import com.appoptics.ext.io.netty.handler.codec.http.HttpUtil;
import com.appoptics.ext.io.netty.handler.codec.http.HttpVersion;
import com.appoptics.ext.io.netty.handler.codec.http.LastHttpContent;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpObjectAggregator
extends MessageAggregator<HttpObject, HttpMessage, HttpContent, FullHttpMessage> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpObjectAggregator.class);
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private final boolean closeOnExpectationFailed;

    public HttpObjectAggregator(int n2) {
        this(n2, false);
    }

    public HttpObjectAggregator(int n2, boolean bl) {
        super(n2);
        this.closeOnExpectationFailed = bl;
    }

    @Override
    protected boolean isStartMessage(HttpObject httpObject) throws Exception {
        return httpObject instanceof HttpMessage;
    }

    @Override
    protected boolean isContentMessage(HttpObject httpObject) throws Exception {
        return httpObject instanceof HttpContent;
    }

    @Override
    protected boolean isLastContentMessage(HttpContent httpContent) throws Exception {
        return httpContent instanceof LastHttpContent;
    }

    @Override
    protected boolean isAggregated(HttpObject httpObject) throws Exception {
        return httpObject instanceof FullHttpMessage;
    }

    @Override
    protected boolean isContentLengthInvalid(HttpMessage httpMessage, int n2) {
        try {
            return HttpUtil.getContentLength(httpMessage, -1L) > (long)n2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static Object continueResponse(HttpMessage httpMessage, int n2, ChannelPipeline channelPipeline) {
        if (HttpUtil.isUnsupportedExpectation(httpMessage)) {
            channelPipeline.fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
            return EXPECTATION_FAILED.retainedDuplicate();
        }
        if (HttpUtil.is100ContinueExpected(httpMessage)) {
            if (HttpUtil.getContentLength(httpMessage, -1L) <= (long)n2) {
                return CONTINUE.retainedDuplicate();
            }
            channelPipeline.fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
            return TOO_LARGE.retainedDuplicate();
        }
        return null;
    }

    @Override
    protected Object newContinueResponse(HttpMessage httpMessage, int n2, ChannelPipeline channelPipeline) {
        Object object = HttpObjectAggregator.continueResponse(httpMessage, n2, channelPipeline);
        if (object != null) {
            httpMessage.headers().remove(HttpHeaderNames.EXPECT);
        }
        return object;
    }

    @Override
    protected boolean closeAfterContinueResponse(Object object) {
        return this.closeOnExpectationFailed && this.ignoreContentAfterContinueResponse(object);
    }

    @Override
    protected boolean ignoreContentAfterContinueResponse(Object object) {
        if (object instanceof HttpResponse) {
            object = (HttpResponse)object;
            return object.status().codeClass().equals((Object)HttpStatusClass.CLIENT_ERROR);
        }
        return false;
    }

    @Override
    protected FullHttpMessage beginAggregation(HttpMessage httpMessage, ByteBuf byteBuf) throws Exception {
        assert (!(httpMessage instanceof FullHttpMessage));
        HttpUtil.setTransferEncodingChunked(httpMessage, false);
        if (httpMessage instanceof HttpRequest) {
            httpMessage = new AggregatedFullHttpRequest((HttpRequest)httpMessage, byteBuf, null);
        } else if (httpMessage instanceof HttpResponse) {
            httpMessage = new AggregatedFullHttpResponse((HttpResponse)httpMessage, byteBuf, null);
        } else {
            throw new Error();
        }
        return httpMessage;
    }

    @Override
    protected void aggregate(FullHttpMessage fullHttpMessage, HttpContent httpContent) throws Exception {
        if (httpContent instanceof LastHttpContent) {
            ((AggregatedFullHttpMessage)fullHttpMessage).setTrailingHeaders(((LastHttpContent)httpContent).trailingHeaders());
        }
    }

    @Override
    protected void finishAggregation(FullHttpMessage fullHttpMessage) throws Exception {
        if (!HttpUtil.isContentLengthSet(fullHttpMessage)) {
            fullHttpMessage.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(fullHttpMessage.content().readableBytes()));
        }
    }

    @Override
    protected void handleOversizedMessage(final ChannelHandlerContext channelHandlerContext, HttpMessage object) throws Exception {
        if (object instanceof HttpRequest) {
            if (object instanceof FullHttpMessage || !HttpUtil.is100ContinueExpected((HttpMessage)object) && !HttpUtil.isKeepAlive((HttpMessage)object)) {
                object = channelHandlerContext.writeAndFlush(TOO_LARGE_CLOSE.retainedDuplicate());
                object.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (!channelFuture.isSuccess()) {
                            logger.debug("Failed to send a 413 Request Entity Too Large.", channelFuture.cause());
                        }
                        channelHandlerContext.close();
                    }
                });
                return;
            }
            channelHandlerContext.writeAndFlush(TOO_LARGE.retainedDuplicate()).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (!channelFuture.isSuccess()) {
                        logger.debug("Failed to send a 413 Request Entity Too Large.", channelFuture.cause());
                        channelHandlerContext.close();
                    }
                }
            });
            return;
        }
        if (object instanceof HttpResponse) {
            channelHandlerContext.close();
            throw new TooLongFrameException("Response entity too large: " + object);
        }
        throw new IllegalStateException();
    }

    static {
        EXPECTATION_FAILED.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }

    private static final class AggregatedFullHttpResponse
    extends AggregatedFullHttpMessage
    implements FullHttpResponse {
        AggregatedFullHttpResponse(HttpResponse httpResponse, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            super(httpResponse, byteBuf, httpHeaders);
        }

        public final FullHttpResponse retainedDuplicate() {
            AggregatedFullHttpResponse aggregatedFullHttpResponse = this;
            return aggregatedFullHttpResponse.replace(aggregatedFullHttpResponse.content().retainedDuplicate());
        }

        public final FullHttpResponse replace(ByteBuf referenceCounted) {
            referenceCounted = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), (ByteBuf)referenceCounted, this.headers().copy(), this.trailingHeaders().copy());
            ((DefaultHttpObject)((Object)referenceCounted)).setDecoderResult(this.decoderResult());
            return referenceCounted;
        }

        public final HttpResponseStatus getStatus() {
            return ((HttpResponse)this.message).status();
        }

        public final HttpResponseStatus status() {
            return this.getStatus();
        }

        public final FullHttpResponse retain() {
            super.retain();
            return this;
        }

        public final FullHttpResponse touch(Object object) {
            super.touch(object);
            return this;
        }

        public final FullHttpResponse touch() {
            super.touch();
            return this;
        }

        public final String toString() {
            return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
        }
    }

    private static final class AggregatedFullHttpRequest
    extends AggregatedFullHttpMessage
    implements FullHttpRequest {
        AggregatedFullHttpRequest(HttpRequest httpRequest, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            super(httpRequest, byteBuf, httpHeaders);
        }

        public final FullHttpRequest retain() {
            super.retain();
            return this;
        }

        public final FullHttpRequest touch() {
            super.touch();
            return this;
        }

        public final FullHttpRequest touch(Object object) {
            super.touch(object);
            return this;
        }

        public final HttpMethod getMethod() {
            return ((HttpRequest)this.message).method();
        }

        public final String getUri() {
            return ((HttpRequest)this.message).uri();
        }

        public final HttpMethod method() {
            return this.getMethod();
        }

        public final String uri() {
            return this.getUri();
        }

        public final String toString() {
            return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
        }
    }

    private static abstract class AggregatedFullHttpMessage
    implements FullHttpMessage {
        protected final HttpMessage message;
        private final ByteBuf content;
        private HttpHeaders trailingHeaders;

        AggregatedFullHttpMessage(HttpMessage httpMessage, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            this.message = httpMessage;
            this.content = byteBuf;
            this.trailingHeaders = httpHeaders;
        }

        public HttpHeaders trailingHeaders() {
            HttpHeaders httpHeaders = this.trailingHeaders;
            if (httpHeaders == null) {
                return EmptyHttpHeaders.INSTANCE;
            }
            return httpHeaders;
        }

        void setTrailingHeaders(HttpHeaders httpHeaders) {
            this.trailingHeaders = httpHeaders;
        }

        public HttpVersion getProtocolVersion() {
            return this.message.protocolVersion();
        }

        public HttpVersion protocolVersion() {
            return this.message.protocolVersion();
        }

        public HttpHeaders headers() {
            return this.message.headers();
        }

        public DecoderResult decoderResult() {
            return this.message.decoderResult();
        }

        public void setDecoderResult(DecoderResult decoderResult) {
            this.message.setDecoderResult(decoderResult);
        }

        public ByteBuf content() {
            return this.content;
        }

        public int refCnt() {
            return this.content.refCnt();
        }

        public FullHttpMessage retain() {
            this.content.retain();
            return this;
        }

        public FullHttpMessage touch(Object object) {
            this.content.touch(object);
            return this;
        }

        public FullHttpMessage touch() {
            this.content.touch();
            return this;
        }

        public boolean release() {
            return this.content.release();
        }
    }
}

