/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.DefaultChannelPromise;
import com.appoptics.ext.io.netty.channel.EventLoop;
import com.appoptics.ext.io.netty.channel.EventLoopGroup;
import com.appoptics.ext.io.netty.util.concurrent.RejectedExecutionHandler;
import com.appoptics.ext.io.netty.util.concurrent.SingleThreadEventExecutor;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import java.util.Queue;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleThreadEventLoop
extends SingleThreadEventExecutor
implements EventLoop {
    protected static final int DEFAULT_MAX_PENDING_TASKS = Math.max(16, SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.eventLoop.maxPendingTasks", Integer.MAX_VALUE));
    private final Queue<Runnable> tailTasks;

    protected SingleThreadEventLoop(EventLoopGroup eventLoopGroup, Executor executor, boolean bl, Queue<Runnable> queue, Queue<Runnable> queue2, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventLoopGroup, executor, bl, queue, rejectedExecutionHandler);
        this.tailTasks = ObjectUtil.checkNotNull(queue2, "tailTaskQueue");
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, this));
    }

    public ChannelFuture register(ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(channelPromise, "promise");
        channelPromise.channel().unsafe().register(this, channelPromise);
        return channelPromise;
    }

    @Override
    protected void afterRunningAllTasks() {
        SingleThreadEventLoop singleThreadEventLoop = this;
        singleThreadEventLoop.runAllTasksFrom(singleThreadEventLoop.tailTasks);
    }

    @Override
    protected boolean hasTasks() {
        return super.hasTasks() || !this.tailTasks.isEmpty();
    }
}

