/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.VoidChannelPromise;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PromiseNotificationUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegatingChannelPromiseNotifier
implements ChannelFutureListener,
ChannelPromise {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DelegatingChannelPromiseNotifier.class);
    private final ChannelPromise delegate;
    private final boolean logNotifyFailure;

    public DelegatingChannelPromiseNotifier(ChannelPromise channelPromise) {
        ChannelPromise channelPromise2 = channelPromise;
        this(channelPromise2, !(channelPromise2 instanceof VoidChannelPromise));
    }

    public DelegatingChannelPromiseNotifier(ChannelPromise channelPromise, boolean bl) {
        this.delegate = ObjectUtil.checkNotNull(channelPromise, "delegate");
        this.logNotifyFailure = bl;
    }

    @Override
    public final void operationComplete(ChannelFuture object) throws Exception {
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (object.isSuccess()) {
            object = (Void)object.get();
            PromiseNotificationUtil.trySuccess(this.delegate, object, internalLogger);
            return;
        }
        if (object.isCancelled()) {
            PromiseNotificationUtil.tryCancel(this.delegate, internalLogger);
            return;
        }
        object = object.cause();
        PromiseNotificationUtil.tryFailure(this.delegate, (Throwable)object, internalLogger);
    }

    @Override
    public final Channel channel() {
        return this.delegate.channel();
    }

    @Override
    public final ChannelPromise setSuccess(Void void_) {
        this.delegate.setSuccess(void_);
        return this;
    }

    @Override
    public final ChannelPromise setSuccess() {
        this.delegate.setSuccess();
        return this;
    }

    @Override
    public final boolean trySuccess() {
        return this.delegate.trySuccess();
    }

    @Override
    public final boolean trySuccess(Void void_) {
        return this.delegate.trySuccess(void_);
    }

    @Override
    public final ChannelPromise setFailure(Throwable throwable) {
        this.delegate.setFailure(throwable);
        return this;
    }

    @Override
    public final ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        this.delegate.addListener(genericFutureListener);
        return this;
    }

    @Override
    public final ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        this.delegate.removeListener(genericFutureListener);
        return this;
    }

    @Override
    public final boolean tryFailure(Throwable throwable) {
        return this.delegate.tryFailure(throwable);
    }

    @Override
    public final boolean setUncancellable() {
        return this.delegate.setUncancellable();
    }

    @Override
    public final ChannelPromise await() throws InterruptedException {
        this.delegate.await();
        return this;
    }

    @Override
    public final boolean isVoid() {
        return this.delegate.isVoid();
    }

    @Override
    public final ChannelPromise unvoid() {
        if (this.isVoid()) {
            return new DelegatingChannelPromiseNotifier(this.delegate.unvoid());
        }
        return this;
    }

    @Override
    public final boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.await(l2, timeUnit);
    }

    @Override
    public final Void getNow() {
        return (Void)this.delegate.getNow();
    }

    @Override
    public final boolean cancel(boolean bl) {
        return this.delegate.cancel(bl);
    }

    @Override
    public final boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public final Void get() throws InterruptedException, ExecutionException {
        return (Void)this.delegate.get();
    }

    @Override
    public final Void get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Void)this.delegate.get(l2, timeUnit);
    }

    @Override
    public final boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    @Override
    public final Throwable cause() {
        return this.delegate.cause();
    }
}

