/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.channel.ChannelConfig;
import com.appoptics.ext.io.netty.channel.MaxMessagesRecvByteBufAllocator;
import com.appoptics.ext.io.netty.channel.RecvByteBufAllocator;
import com.appoptics.ext.io.netty.util.UncheckedBooleanSupplier;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

public abstract class DefaultMaxMessagesRecvByteBufAllocator
implements MaxMessagesRecvByteBufAllocator {
    private volatile int maxMessagesPerRead;
    private volatile boolean respectMaybeMoreData = true;

    public DefaultMaxMessagesRecvByteBufAllocator() {
        this(1);
    }

    public DefaultMaxMessagesRecvByteBufAllocator(int n2) {
        this.maxMessagesPerRead(n2);
    }

    public int maxMessagesPerRead() {
        return this.maxMessagesPerRead;
    }

    public MaxMessagesRecvByteBufAllocator maxMessagesPerRead(int n2) {
        ObjectUtil.checkPositive(n2, "maxMessagesPerRead");
        this.maxMessagesPerRead = n2;
        return this;
    }

    public abstract class MaxMessageHandle
    implements RecvByteBufAllocator.ExtendedHandle {
        private ChannelConfig config;
        private int maxMessagePerRead;
        private int totalMessages;
        private int totalBytesRead;
        private int attemptedBytesRead;
        private int lastBytesRead;
        private final boolean respectMaybeMoreData;
        private final UncheckedBooleanSupplier defaultMaybeMoreSupplier;

        public MaxMessageHandle() {
            this.respectMaybeMoreData = DefaultMaxMessagesRecvByteBufAllocator.this.respectMaybeMoreData;
            this.defaultMaybeMoreSupplier = new UncheckedBooleanSupplier(){

                public boolean get() {
                    return MaxMessageHandle.this.attemptedBytesRead == MaxMessageHandle.this.lastBytesRead;
                }
            };
        }

        public void reset(ChannelConfig channelConfig) {
            this.config = channelConfig;
            this.maxMessagePerRead = DefaultMaxMessagesRecvByteBufAllocator.this.maxMessagesPerRead();
            MaxMessageHandle maxMessageHandle = this;
            maxMessageHandle.totalBytesRead = 0;
            maxMessageHandle.totalMessages = 0;
        }

        public ByteBuf allocate(ByteBufAllocator byteBufAllocator) {
            return byteBufAllocator.ioBuffer(this.guess());
        }

        public final void incMessagesRead(int n2) {
            this.totalMessages += n2;
        }

        public void lastBytesRead(int n2) {
            this.lastBytesRead = n2;
            if (n2 > 0) {
                this.totalBytesRead += n2;
            }
        }

        public final int lastBytesRead() {
            return this.lastBytesRead;
        }

        public boolean continueReading() {
            MaxMessageHandle maxMessageHandle = this;
            return maxMessageHandle.continueReading(maxMessageHandle.defaultMaybeMoreSupplier);
        }

        public boolean continueReading(UncheckedBooleanSupplier uncheckedBooleanSupplier) {
            return this.config.isAutoRead() && (!this.respectMaybeMoreData || uncheckedBooleanSupplier.get()) && this.totalMessages < this.maxMessagePerRead && this.totalBytesRead > 0;
        }

        public void readComplete() {
        }

        public int attemptedBytesRead() {
            return this.attemptedBytesRead;
        }

        public void attemptedBytesRead(int n2) {
            this.attemptedBytesRead = n2;
        }

        protected final int totalBytesRead() {
            if (this.totalBytesRead < 0) {
                return Integer.MAX_VALUE;
            }
            return this.totalBytesRead;
        }
    }
}

