/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.SwappedByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledDirectByteBuf;
import com.appoptics.ext.io.netty.buffer.UnsafeByteBufUtil;
import com.appoptics.ext.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

public class UnpooledUnsafeDirectByteBuf
extends UnpooledDirectByteBuf {
    long memoryAddress;

    public UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(byteBufAllocator, n2, n3);
    }

    final void setByteBuffer(ByteBuffer byteBuffer, boolean bl) {
        super.setByteBuffer(byteBuffer, bl);
        this.memoryAddress = PlatformDependent.directBufferAddress(byteBuffer);
    }

    public boolean hasMemoryAddress() {
        return true;
    }

    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    public byte getByte(int n2) {
        this.checkIndex(n2);
        return this._getByte(n2);
    }

    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.addr(n2));
    }

    public short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this._getShort(n2);
    }

    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.addr(n2));
    }

    protected short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n2));
    }

    public int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMedium(n2);
    }

    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n2));
    }

    public int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this._getInt(n2);
    }

    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.addr(n2));
    }

    protected int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n2));
    }

    public long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this._getLong(n2);
    }

    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.addr(n2));
    }

    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    void getBytes(int n2, byte[] byArray, int n3, int n4, boolean bl) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byArray, n3, n4);
    }

    void getBytes(int n2, ByteBuffer byteBuffer, boolean bl) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.getBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byteBuffer);
    }

    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex(n2);
        this._setByte(n2, n3);
        return this;
    }

    protected void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte(this.addr(n2), n3);
    }

    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShort(n2, n3);
        return this;
    }

    protected void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort(this.addr(n2), n3);
    }

    protected void _setShortLE(int n2, int n3) {
        UnsafeByteBufUtil.setShortLE(this.addr(n2), n3);
    }

    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMedium(n2, n3);
        return this;
    }

    protected void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium(this.addr(n2), n3);
    }

    protected void _setMediumLE(int n2, int n3) {
        UnsafeByteBufUtil.setMediumLE(this.addr(n2), n3);
    }

    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setInt(n2, n3);
        return this;
    }

    protected void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt(this.addr(n2), n3);
    }

    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLong(n2, l2);
        return this;
    }

    protected void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n2), l2);
    }

    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        UnpooledUnsafeDirectByteBuf unpooledUnsafeDirectByteBuf = this;
        UnsafeByteBufUtil.setBytes(unpooledUnsafeDirectByteBuf, unpooledUnsafeDirectByteBuf.addr(n2), n2, byteBuffer);
        return this;
    }

    final long addr(int n2) {
        return this.memoryAddress + (long)n2;
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    public ByteBuf setZero(int n2, int n3) {
        this.checkIndex(n2, n3);
        UnsafeByteBufUtil.setZero(this.addr(n2), n3);
        return this;
    }

    public ByteBuf writeZero(int n2) {
        this.ensureWritable(n2);
        int n3 = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(n3), n2);
        this.writerIndex = n3 + n2;
        return this;
    }
}

