/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.CompositeByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledDirectByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledHeapByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import com.appoptics.ext.io.netty.util.internal.LongCounter;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;

public final class UnpooledByteBufAllocator
extends AbstractByteBufAllocator {
    private final UnpooledByteBufAllocatorMetric metric = new UnpooledByteBufAllocatorMetric();
    private final boolean disableLeakDetector;
    private final boolean noCleaner;
    public static final UnpooledByteBufAllocator DEFAULT = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    public UnpooledByteBufAllocator(boolean bl) {
        this(bl, false);
    }

    public UnpooledByteBufAllocator(boolean bl, boolean bl2) {
        this(bl, bl2, PlatformDependent.useDirectBufferNoCleaner());
    }

    public UnpooledByteBufAllocator(boolean bl, boolean bl2, boolean bl3) {
        super(bl);
        this.disableLeakDetector = bl2;
        this.noCleaner = bl3 && PlatformDependent.hasUnsafe() && PlatformDependent.hasDirectBufferNoCleanerConstructor();
    }

    protected final ByteBuf newHeapBuffer(int n2, int n3) {
        if (PlatformDependent.hasUnsafe()) {
            return new InstrumentedUnpooledUnsafeHeapByteBuf(this, n2, n3);
        }
        return new InstrumentedUnpooledHeapByteBuf(this, n2, n3);
    }

    protected final ByteBuf newDirectBuffer(int n2, int n3) {
        UnpooledDirectByteBuf unpooledDirectByteBuf = PlatformDependent.hasUnsafe() ? (this.noCleaner ? new InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(this, n2, n3) : new InstrumentedUnpooledUnsafeDirectByteBuf(this, n2, n3)) : new InstrumentedUnpooledDirectByteBuf(this, n2, n3);
        if (this.disableLeakDetector) {
            return unpooledDirectByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(unpooledDirectByteBuf);
    }

    public final CompositeByteBuf compositeHeapBuffer(int n2) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, false, n2);
        if (this.disableLeakDetector) {
            return compositeByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    public final CompositeByteBuf compositeDirectBuffer(int n2) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, true, n2);
        if (this.disableLeakDetector) {
            return compositeByteBuf;
        }
        return UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    public final boolean isDirectBufferPooled() {
        return false;
    }

    final void incrementDirect(int n2) {
        this.metric.directCounter.add(n2);
    }

    final void decrementDirect(int n2) {
        this.metric.directCounter.add(-n2);
    }

    final void incrementHeap(int n2) {
        this.metric.heapCounter.add(n2);
    }

    final void decrementHeap(int n2) {
        this.metric.heapCounter.add(-n2);
    }

    private static final class UnpooledByteBufAllocatorMetric {
        final LongCounter directCounter = PlatformDependent.newLongCounter();
        final LongCounter heapCounter = PlatformDependent.newLongCounter();

        private UnpooledByteBufAllocatorMetric() {
        }

        public final long usedHeapMemory() {
            return this.heapCounter.value();
        }

        public final long usedDirectMemory() {
            return this.directCounter.value();
        }

        public final String toString() {
            return StringUtil.simpleClassName(this) + "(usedHeapMemory: " + this.usedHeapMemory() + "; usedDirectMemory: " + this.usedDirectMemory() + ')';
        }
    }

    private static final class InstrumentedUnpooledDirectByteBuf
    extends UnpooledDirectByteBuf {
        InstrumentedUnpooledDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super(unpooledByteBufAllocator, n2, n3);
        }

        protected final ByteBuffer allocateDirect(int n2) {
            ByteBuffer byteBuffer = super.allocateDirect(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        protected final void freeDirect(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)this.alloc()).decrementDirect(n2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        InstrumentedUnpooledUnsafeDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super(unpooledByteBufAllocator, n2, n3);
        }

        protected final ByteBuffer allocateDirect(int n2) {
            ByteBuffer byteBuffer = super.allocateDirect(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        protected final void freeDirect(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)this.alloc()).decrementDirect(n2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf
    extends UnpooledUnsafeNoCleanerDirectByteBuf {
        InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super(unpooledByteBufAllocator, n2, n3);
        }

        protected final ByteBuffer allocateDirect(int n2) {
            ByteBuffer byteBuffer = super.allocateDirect(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementDirect(byteBuffer.capacity());
            return byteBuffer;
        }

        final ByteBuffer reallocateDirect(ByteBuffer byteBuffer, int n2) {
            int n3 = byteBuffer.capacity();
            byteBuffer = super.reallocateDirect(byteBuffer, n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementDirect(byteBuffer.capacity() - n3);
            return byteBuffer;
        }

        protected final void freeDirect(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.capacity();
            super.freeDirect(byteBuffer);
            ((UnpooledByteBufAllocator)this.alloc()).decrementDirect(n2);
        }
    }

    private static final class InstrumentedUnpooledHeapByteBuf
    extends UnpooledHeapByteBuf {
        InstrumentedUnpooledHeapByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n2, n3);
        }

        protected final byte[] allocateArray(int n2) {
            byte[] byArray = super.allocateArray(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementHeap(byArray.length);
            return byArray;
        }

        protected final void freeArray(byte[] byArray) {
            int n2 = byArray.length;
            super.freeArray(byArray);
            ((UnpooledByteBufAllocator)this.alloc()).decrementHeap(n2);
        }
    }

    private static final class InstrumentedUnpooledUnsafeHeapByteBuf
    extends UnpooledUnsafeHeapByteBuf {
        InstrumentedUnpooledUnsafeHeapByteBuf(UnpooledByteBufAllocator unpooledByteBufAllocator, int n2, int n3) {
            super((ByteBufAllocator)unpooledByteBufAllocator, n2, n3);
        }

        protected final byte[] allocateArray(int n2) {
            byte[] byArray = super.allocateArray(n2);
            ((UnpooledByteBufAllocator)this.alloc()).incrementHeap(byArray.length);
            return byArray;
        }

        protected final void freeArray(byte[] byArray) {
            int n2 = byArray.length;
            super.freeArray(byArray);
            ((UnpooledByteBufAllocator)this.alloc()).decrementHeap(n2);
        }
    }
}

