/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

@Deprecated
public class SwappedByteBuf
extends ByteBuf {
    private final ByteBuf buf;
    private final ByteOrder order;

    public SwappedByteBuf(ByteBuf byteBuf) {
        this.buf = ObjectUtil.checkNotNull(byteBuf, "buf");
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            this.order = ByteOrder.LITTLE_ENDIAN;
            return;
        }
        this.order = ByteOrder.BIG_ENDIAN;
    }

    public ByteOrder order() {
        return this.order;
    }

    public ByteBuf order(ByteOrder byteOrder) {
        if (ObjectUtil.checkNotNull(byteOrder, "endianness") == this.order) {
            return this;
        }
        return this.buf;
    }

    public ByteBuf unwrap() {
        return this.buf;
    }

    public ByteBufAllocator alloc() {
        return this.buf.alloc();
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public ByteBuf capacity(int n2) {
        this.buf.capacity(n2);
        return this;
    }

    public int maxCapacity() {
        return this.buf.maxCapacity();
    }

    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer(this);
    }

    public boolean isDirect() {
        return this.buf.isDirect();
    }

    public int readerIndex() {
        return this.buf.readerIndex();
    }

    public ByteBuf readerIndex(int n2) {
        this.buf.readerIndex(n2);
        return this;
    }

    public int writerIndex() {
        return this.buf.writerIndex();
    }

    public ByteBuf writerIndex(int n2) {
        this.buf.writerIndex(n2);
        return this;
    }

    public ByteBuf setIndex(int n2, int n3) {
        this.buf.setIndex(n2, n3);
        return this;
    }

    public int readableBytes() {
        return this.buf.readableBytes();
    }

    public int writableBytes() {
        return this.buf.writableBytes();
    }

    public int maxWritableBytes() {
        return this.buf.maxWritableBytes();
    }

    public int maxFastWritableBytes() {
        return this.buf.maxFastWritableBytes();
    }

    public boolean isReadable() {
        return this.buf.isReadable();
    }

    public boolean isWritable(int n2) {
        return this.buf.isWritable(n2);
    }

    public ByteBuf clear() {
        this.buf.clear();
        return this;
    }

    public ByteBuf markReaderIndex() {
        this.buf.markReaderIndex();
        return this;
    }

    public ByteBuf resetReaderIndex() {
        this.buf.resetReaderIndex();
        return this;
    }

    public ByteBuf discardSomeReadBytes() {
        this.buf.discardSomeReadBytes();
        return this;
    }

    public ByteBuf ensureWritable(int n2) {
        this.buf.ensureWritable(n2);
        return this;
    }

    public int ensureWritable(int n2, boolean bl) {
        return this.buf.ensureWritable(n2, bl);
    }

    public byte getByte(int n2) {
        return this.buf.getByte(n2);
    }

    public short getUnsignedByte(int n2) {
        return this.buf.getUnsignedByte(n2);
    }

    public short getShort(int n2) {
        return ByteBufUtil.swapShort(this.buf.getShort(n2));
    }

    public short getShortLE(int n2) {
        return this.buf.getShort(n2);
    }

    public int getUnsignedShort(int n2) {
        return this.getShort(n2) & 0xFFFF;
    }

    public int getUnsignedShortLE(int n2) {
        return this.getShortLE(n2) & 0xFFFF;
    }

    public int getMedium(int n2) {
        return ByteBufUtil.swapMedium(this.buf.getMedium(n2));
    }

    public int getUnsignedMedium(int n2) {
        return this.getMedium(n2) & 0xFFFFFF;
    }

    public int getInt(int n2) {
        return ByteBufUtil.swapInt(this.buf.getInt(n2));
    }

    public int getIntLE(int n2) {
        return this.buf.getInt(n2);
    }

    public long getUnsignedInt(int n2) {
        return (long)this.getInt(n2) & 0xFFFFFFFFL;
    }

    public long getUnsignedIntLE(int n2) {
        return (long)this.getIntLE(n2) & 0xFFFFFFFFL;
    }

    public long getLong(int n2) {
        return ByteBufUtil.swapLong(this.buf.getLong(n2));
    }

    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.buf.getBytes(n2, byteBuf, n3, n4);
        return this;
    }

    public ByteBuf getBytes(int n2, byte[] byArray) {
        this.buf.getBytes(n2, byArray);
        return this;
    }

    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.buf.getBytes(n2, byArray, n3, n4);
        return this;
    }

    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.buf.getBytes(n2, byteBuffer);
        return this;
    }

    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        return this.buf.getBytes(n2, gatheringByteChannel, n3);
    }

    public ByteBuf setByte(int n2, int n3) {
        this.buf.setByte(n2, n3);
        return this;
    }

    public ByteBuf setShort(int n2, int n3) {
        this.buf.setShort(n2, ByteBufUtil.swapShort((short)n3));
        return this;
    }

    public ByteBuf setShortLE(int n2, int n3) {
        this.buf.setShort(n2, (short)n3);
        return this;
    }

    public ByteBuf setMedium(int n2, int n3) {
        this.buf.setMedium(n2, ByteBufUtil.swapMedium(n3));
        return this;
    }

    public ByteBuf setMediumLE(int n2, int n3) {
        this.buf.setMedium(n2, n3);
        return this;
    }

    public ByteBuf setInt(int n2, int n3) {
        this.buf.setInt(n2, ByteBufUtil.swapInt(n3));
        return this;
    }

    public ByteBuf setLong(int n2, long l2) {
        this.buf.setLong(n2, ByteBufUtil.swapLong(l2));
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.buf.setBytes(n2, byteBuf, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.buf.setBytes(n2, byArray, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.buf.setBytes(n2, byteBuffer);
        return this;
    }

    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        return this.buf.setBytes(n2, scatteringByteChannel, n3);
    }

    public ByteBuf setZero(int n2, int n3) {
        this.buf.setZero(n2, n3);
        return this;
    }

    public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        return this.buf.setCharSequence(n2, charSequence, charset);
    }

    public byte readByte() {
        return this.buf.readByte();
    }

    public short readUnsignedByte() {
        return this.buf.readUnsignedByte();
    }

    public short readShort() {
        return ByteBufUtil.swapShort(this.buf.readShort());
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readMedium() {
        return ByteBufUtil.swapMedium(this.buf.readMedium());
    }

    public int readUnsignedMedium() {
        return this.readMedium() & 0xFFFFFF;
    }

    public int readInt() {
        return ByteBufUtil.swapInt(this.buf.readInt());
    }

    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() {
        return ByteBufUtil.swapLong(this.buf.readLong());
    }

    public ByteBuf readBytes(int n2) {
        return this.buf.readBytes(n2).order(this.order());
    }

    public ByteBuf readSlice(int n2) {
        return this.buf.readSlice(n2).order(this.order);
    }

    public ByteBuf readRetainedSlice(int n2) {
        return this.buf.readRetainedSlice(n2).order(this.order);
    }

    public ByteBuf readBytes(byte[] byArray) {
        this.buf.readBytes(byArray);
        return this;
    }

    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.buf.readBytes(byArray, n2, n3);
        return this;
    }

    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        return this.buf.readBytes(gatheringByteChannel, n2);
    }

    public ByteBuf skipBytes(int n2) {
        this.buf.skipBytes(n2);
        return this;
    }

    public ByteBuf writeByte(int n2) {
        this.buf.writeByte(n2);
        return this;
    }

    public ByteBuf writeShort(int n2) {
        this.buf.writeShort(ByteBufUtil.swapShort((short)n2));
        return this;
    }

    public ByteBuf writeShortLE(int n2) {
        this.buf.writeShort((short)n2);
        return this;
    }

    public ByteBuf writeMedium(int n2) {
        this.buf.writeMedium(ByteBufUtil.swapMedium(n2));
        return this;
    }

    public ByteBuf writeMediumLE(int n2) {
        this.buf.writeMedium(n2);
        return this;
    }

    public ByteBuf writeInt(int n2) {
        this.buf.writeInt(ByteBufUtil.swapInt(n2));
        return this;
    }

    public ByteBuf writeLong(long l2) {
        this.buf.writeLong(ByteBufUtil.swapLong(l2));
        return this;
    }

    public ByteBuf writeChar(int n2) {
        this.writeShort(n2);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf) {
        this.buf.writeBytes(byteBuf);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        this.buf.writeBytes(byteBuf, n2);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        this.buf.writeBytes(byteBuf, n2, n3);
        return this;
    }

    public ByteBuf writeBytes(byte[] byArray) {
        this.buf.writeBytes(byArray);
        return this;
    }

    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        this.buf.writeBytes(byArray, n2, n3);
        return this;
    }

    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        this.buf.writeBytes(byteBuffer);
        return this;
    }

    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) throws IOException {
        return this.buf.writeBytes(scatteringByteChannel, n2);
    }

    public ByteBuf writeZero(int n2) {
        this.buf.writeZero(n2);
        return this;
    }

    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        return this.buf.writeCharSequence(charSequence, charset);
    }

    public int forEachByte(ByteProcessor byteProcessor) {
        return this.buf.forEachByte(byteProcessor);
    }

    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        return this.buf.forEachByte(n2, n3, byteProcessor);
    }

    public ByteBuf slice() {
        return this.buf.slice().order(this.order);
    }

    public ByteBuf retainedSlice() {
        return this.buf.retainedSlice().order(this.order);
    }

    public ByteBuf slice(int n2, int n3) {
        return this.buf.slice(n2, n3).order(this.order);
    }

    public ByteBuf duplicate() {
        return this.buf.duplicate().order(this.order);
    }

    public ByteBuf retainedDuplicate() {
        return this.buf.retainedDuplicate().order(this.order);
    }

    public int nioBufferCount() {
        return this.buf.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.buf.nioBuffer().order(this.order);
    }

    public ByteBuffer nioBuffer(int n2, int n3) {
        return this.buf.nioBuffer(n2, n3).order(this.order);
    }

    public ByteBuffer internalNioBuffer(int n2, int n3) {
        return this.nioBuffer(n2, n3);
    }

    public ByteBuffer[] nioBuffers() {
        ByteBuffer[] byteBufferArray = this.buf.nioBuffers();
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            byteBufferArray[i2] = byteBufferArray[i2].order(this.order);
        }
        return byteBufferArray;
    }

    public ByteBuffer[] nioBuffers(int n2, int n3) {
        ByteBuffer[] byteBufferArray = this.buf.nioBuffers(n2, n3);
        for (n3 = 0; n3 < byteBufferArray.length; ++n3) {
            byteBufferArray[n3] = byteBufferArray[n3].order(this.order);
        }
        return byteBufferArray;
    }

    public boolean hasArray() {
        return this.buf.hasArray();
    }

    public byte[] array() {
        return this.buf.array();
    }

    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.buf.hasMemoryAddress();
    }

    public boolean isContiguous() {
        return this.buf.isContiguous();
    }

    public long memoryAddress() {
        return this.buf.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.buf.toString(charset);
    }

    public String toString(int n2, int n3, Charset charset) {
        return this.buf.toString(n2, n3, charset);
    }

    public int refCnt() {
        return this.buf.refCnt();
    }

    final boolean isAccessible() {
        return this.buf.isAccessible();
    }

    public ByteBuf retain() {
        this.buf.retain();
        return this;
    }

    public ByteBuf touch() {
        this.buf.touch();
        return this;
    }

    public ByteBuf touch(Object object) {
        this.buf.touch(object);
        return this;
    }

    public boolean release() {
        return this.buf.release();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ByteBuf) {
            return ByteBufUtil.equals(this, (ByteBuf)object);
        }
        return false;
    }

    public int compareTo(ByteBuf byteBuf) {
        return ByteBufUtil.compare(this, byteBuf);
    }

    public String toString() {
        return "Swapped(" + this.buf + ')';
    }
}

