/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBuf;
import com.appoptics.ext.io.netty.buffer.AbstractPooledDerivedByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.SwappedByteBuf;
import com.appoptics.ext.io.netty.buffer.WrappedByteBuf;
import com.appoptics.ext.io.netty.util.ResourceLeakTracker;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleLeakAwareByteBuf
extends WrappedByteBuf {
    private final ByteBuf trackedByteBuf;
    final ResourceLeakTracker<ByteBuf> leak;

    SimpleLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        super(byteBuf);
        this.trackedByteBuf = ObjectUtil.checkNotNull(byteBuf2, "trackedByteBuf");
        this.leak = ObjectUtil.checkNotNull(resourceLeakTracker, "leak");
    }

    SimpleLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        ByteBuf byteBuf2 = byteBuf;
        this(byteBuf2, byteBuf2, resourceLeakTracker);
    }

    @Override
    public ByteBuf slice() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf retainedSlice() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.retainedSlice());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.retainedDuplicate());
    }

    @Override
    public ByteBuf readRetainedSlice(int n2) {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.unwrappedDerived(super.readRetainedSlice(n2));
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.slice(n2, n3));
    }

    @Override
    public ByteBuf duplicate() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.duplicate());
    }

    @Override
    public ByteBuf readSlice(int n2) {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.readSlice(n2));
    }

    @Override
    public ByteBuf asReadOnly() {
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.asReadOnly());
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        if (super.release()) {
            this.closeLeak();
            return true;
        }
        return false;
    }

    private void closeLeak() {
        boolean bl = this.leak.close(this.trackedByteBuf);
        assert (bl);
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (this.order() == byteOrder) {
            return this;
        }
        SimpleLeakAwareByteBuf simpleLeakAwareByteBuf = this;
        return simpleLeakAwareByteBuf.newSharedLeakAwareByteBuf(super.order(byteOrder));
    }

    private ByteBuf unwrappedDerived(ByteBuf byteBuf) {
        Object object = SimpleLeakAwareByteBuf.unwrapSwapped(byteBuf);
        if (object instanceof AbstractPooledDerivedByteBuf) {
            ((AbstractPooledDerivedByteBuf)object).parent(this);
            object = AbstractByteBuf.leakDetector.track(byteBuf);
            if (object == null) {
                return byteBuf;
            }
            return this.newLeakAwareByteBuf(byteBuf, (ResourceLeakTracker<ByteBuf>)object);
        }
        return this.newSharedLeakAwareByteBuf(byteBuf);
    }

    private static ByteBuf unwrapSwapped(ByteBuf byteBuf) {
        if (byteBuf instanceof SwappedByteBuf) {
            while ((byteBuf = byteBuf.unwrap()) instanceof SwappedByteBuf) {
            }
            return byteBuf;
        }
        return byteBuf;
    }

    private SimpleLeakAwareByteBuf newSharedLeakAwareByteBuf(ByteBuf byteBuf) {
        return this.newLeakAwareByteBuf(byteBuf, this.trackedByteBuf, this.leak);
    }

    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        ByteBuf byteBuf2 = byteBuf;
        return this.newLeakAwareByteBuf(byteBuf2, byteBuf2, resourceLeakTracker);
    }

    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        return new SimpleLeakAwareByteBuf(byteBuf, byteBuf2, resourceLeakTracker);
    }
}

