/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.PoolArena;
import com.appoptics.ext.io.netty.buffer.PoolChunk;
import com.appoptics.ext.io.netty.buffer.PoolChunkListMetric;
import com.appoptics.ext.io.netty.buffer.PoolChunkMetric;
import com.appoptics.ext.io.netty.buffer.PoolThreadCache;
import com.appoptics.ext.io.netty.buffer.PooledByteBuf;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PoolChunkList<T>
implements PoolChunkListMetric {
    private static final Iterator<PoolChunkMetric> EMPTY_METRICS = Collections.emptyList().iterator();
    private final PoolArena<T> arena;
    private final PoolChunkList<T> nextList;
    private final int minUsage;
    private final int maxUsage;
    private final int maxCapacity;
    private PoolChunk<T> head;
    private final int freeMinThreshold;
    private final int freeMaxThreshold;
    private PoolChunkList<T> prevList;

    PoolChunkList(PoolArena<T> poolArena, PoolChunkList<T> poolChunkList, int n2, int n3, int n4) {
        assert (n2 <= n3);
        this.arena = poolArena;
        this.nextList = poolChunkList;
        this.minUsage = n2;
        this.maxUsage = n3;
        this.maxCapacity = PoolChunkList.calculateMaxCapacity(n2, n4);
        this.freeMinThreshold = n3 == 100 ? 0 : (int)((double)n4 * (100.0 - (double)n3 + 0.99999999) / 100.0);
        this.freeMaxThreshold = n2 == 100 ? 0 : (int)((double)n4 * (100.0 - (double)n2 + 0.99999999) / 100.0);
    }

    private static int calculateMaxCapacity(int n2, int n3) {
        if ((n2 = PoolChunkList.minUsage0(n2)) == 100) {
            return 0;
        }
        return (int)((long)n3 * (100L - (long)n2) / 100L);
    }

    final void prevList(PoolChunkList<T> poolChunkList) {
        assert (this.prevList == null);
        this.prevList = poolChunkList;
    }

    final boolean allocate(PooledByteBuf<T> pooledByteBuf, int n2, int n3, PoolThreadCache poolThreadCache) {
        if (n3 > this.maxCapacity) {
            return false;
        }
        PoolChunk<T> poolChunk = this.head;
        while (poolChunk != null) {
            if (poolChunk.allocate(pooledByteBuf, n2, n3, poolThreadCache)) {
                if (poolChunk.freeBytes <= this.freeMinThreshold) {
                    this.remove(poolChunk);
                    this.nextList.add(poolChunk);
                }
                return true;
            }
            poolChunk = poolChunk.next;
        }
        return false;
    }

    final boolean free(PoolChunk<T> poolChunk, long l2, ByteBuffer byteBuffer) {
        poolChunk.free(l2, byteBuffer);
        if (poolChunk.freeBytes > this.freeMaxThreshold) {
            this.remove(poolChunk);
            return this.move0(poolChunk);
        }
        return true;
    }

    private boolean move(PoolChunk<T> poolChunk) {
        assert (poolChunk.usage() < this.maxUsage);
        if (poolChunk.freeBytes > this.freeMaxThreshold) {
            return this.move0(poolChunk);
        }
        this.add0(poolChunk);
        return true;
    }

    private boolean move0(PoolChunk<T> poolChunk) {
        if (this.prevList == null) {
            assert (poolChunk.usage() == 0);
            return false;
        }
        return super.move(poolChunk);
    }

    final void add(PoolChunk<T> poolChunk) {
        while (poolChunk.freeBytes <= poolChunkList.freeMinThreshold) {
            PoolChunkList<T> poolChunkList = poolChunkList.nextList;
        }
        poolChunkList.add0(poolChunk);
    }

    final void add0(PoolChunk<T> poolChunk) {
        poolChunk.parent = this;
        if (this.head == null) {
            this.head = poolChunk;
            poolChunk.prev = null;
            poolChunk.next = null;
            return;
        }
        poolChunk.prev = null;
        poolChunk.next = this.head;
        this.head.prev = poolChunk;
        this.head = poolChunk;
    }

    private void remove(PoolChunk<T> poolChunk) {
        if (poolChunk == this.head) {
            this.head = poolChunk.next;
            if (this.head != null) {
                this.head.prev = null;
                return;
            }
        } else {
            PoolChunk poolChunk2;
            poolChunk.prev.next = poolChunk2 = poolChunk.next;
            if (poolChunk2 != null) {
                poolChunk2.prev = poolChunk.prev;
            }
        }
    }

    private static int minUsage0(int n2) {
        return Math.max(1, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<PoolChunkMetric> iterator() {
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            if (this.head == null) {
                return EMPTY_METRICS;
            }
            ArrayList<PoolChunk<T>> arrayList = new ArrayList<PoolChunk<T>>();
            PoolChunk<T> poolChunk = this.head;
            do {
                arrayList.add(poolChunk);
            } while ((poolChunk = poolChunk.next) != null);
            return arrayList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            if (this.head == null) {
                return "none";
            }
            PoolChunk<T> poolChunk = this.head;
            while (true) {
                stringBuilder.append(poolChunk);
                poolChunk = poolChunk.next;
                if (poolChunk == null) break;
                stringBuilder.append(StringUtil.NEWLINE);
            }
        }
        return stringBuilder.toString();
    }

    final void destroy(PoolArena<T> poolArena) {
        PoolChunk<T> poolChunk = this.head;
        while (poolChunk != null) {
            poolArena.destroyChunk(poolChunk);
            poolChunk = poolChunk.next;
        }
        this.head = null;
    }
}

