/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.EmptyArrays;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public final class EmptyByteBuf
extends ByteBuf {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocateDirect(0);
    private static final long EMPTY_BYTE_BUFFER_ADDRESS;
    private final ByteBufAllocator alloc;
    private final ByteOrder order;
    private final String str;
    private EmptyByteBuf swapped;

    public EmptyByteBuf(ByteBufAllocator byteBufAllocator) {
        this(byteBufAllocator, ByteOrder.BIG_ENDIAN);
    }

    private EmptyByteBuf(ByteBufAllocator byteBufAllocator, ByteOrder byteOrder) {
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        this.order = byteOrder;
        this.str = StringUtil.simpleClassName(this) + (byteOrder == ByteOrder.BIG_ENDIAN ? "BE" : "LE");
    }

    public final int capacity() {
        return 0;
    }

    public final ByteBuf capacity(int n2) {
        throw new ReadOnlyBufferException();
    }

    public final ByteBufAllocator alloc() {
        return this.alloc;
    }

    public final ByteOrder order() {
        return this.order;
    }

    public final ByteBuf unwrap() {
        return null;
    }

    public final ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer(this);
    }

    public final boolean isReadOnly() {
        return false;
    }

    public final boolean isDirect() {
        return true;
    }

    public final int maxCapacity() {
        return 0;
    }

    public final ByteBuf order(ByteOrder byteOrder) {
        if (ObjectUtil.checkNotNull(byteOrder, "endianness") == this.order()) {
            return this;
        }
        EmptyByteBuf emptyByteBuf = this.swapped;
        if (emptyByteBuf != null) {
            return emptyByteBuf;
        }
        this.swapped = emptyByteBuf = new EmptyByteBuf(this.alloc(), byteOrder);
        return emptyByteBuf;
    }

    public final int readerIndex() {
        return 0;
    }

    public final ByteBuf readerIndex(int n2) {
        return this.checkIndex(n2);
    }

    public final int writerIndex() {
        return 0;
    }

    public final ByteBuf writerIndex(int n2) {
        return this.checkIndex(n2);
    }

    public final ByteBuf setIndex(int n2, int n3) {
        this.checkIndex(n2);
        this.checkIndex(n3);
        return this;
    }

    public final int readableBytes() {
        return 0;
    }

    public final int writableBytes() {
        return 0;
    }

    public final int maxWritableBytes() {
        return 0;
    }

    public final boolean isReadable() {
        return false;
    }

    public final ByteBuf clear() {
        return this;
    }

    public final ByteBuf markReaderIndex() {
        return this;
    }

    public final ByteBuf resetReaderIndex() {
        return this;
    }

    public final ByteBuf discardSomeReadBytes() {
        return this;
    }

    public final ByteBuf ensureWritable(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "minWritableBytes");
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    public final int ensureWritable(int n2, boolean bl) {
        ObjectUtil.checkPositiveOrZero(n2, "minWritableBytes");
        if (n2 == 0) {
            return 0;
        }
        return 1;
    }

    public final byte getByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final short getUnsignedByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final short getShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final short getShortLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final int getUnsignedShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final int getUnsignedShortLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final int getMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final int getUnsignedMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final int getInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final int getIntLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final long getUnsignedInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final long getUnsignedIntLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final long getLong(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    public final ByteBuf getBytes(int n2, byte[] byArray) {
        return this.checkIndex(n2, byArray.length);
    }

    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        return this.checkIndex(n2, byteBuffer.remaining());
    }

    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        return 0;
    }

    public final ByteBuf setByte(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf setShort(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf setShortLE(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf setMedium(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf setMediumLE(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf setInt(int n2, int n3) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf setLong(int n2, long l2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        return this.checkIndex(n2, n4);
    }

    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        return this.checkIndex(n2, byteBuffer.remaining());
    }

    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        return 0;
    }

    public final ByteBuf setZero(int n2, int n3) {
        return this.checkIndex(n2, n3);
    }

    public final int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    public final byte readByte() {
        throw new IndexOutOfBoundsException();
    }

    public final short readUnsignedByte() {
        throw new IndexOutOfBoundsException();
    }

    public final short readShort() {
        throw new IndexOutOfBoundsException();
    }

    public final int readUnsignedShort() {
        throw new IndexOutOfBoundsException();
    }

    public final int readMedium() {
        throw new IndexOutOfBoundsException();
    }

    public final int readUnsignedMedium() {
        throw new IndexOutOfBoundsException();
    }

    public final int readInt() {
        throw new IndexOutOfBoundsException();
    }

    public final long readUnsignedInt() {
        throw new IndexOutOfBoundsException();
    }

    public final long readLong() {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf readBytes(int n2) {
        return this.checkLength(n2);
    }

    public final ByteBuf readSlice(int n2) {
        return this.checkLength(n2);
    }

    public final ByteBuf readRetainedSlice(int n2) {
        return this.checkLength(n2);
    }

    public final ByteBuf readBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    public final ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        return this.checkLength(n3);
    }

    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkLength(n2);
        return 0;
    }

    public final ByteBuf skipBytes(int n2) {
        return this.checkLength(n2);
    }

    public final ByteBuf writeByte(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf writeShort(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf writeShortLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf writeMedium(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf writeMediumLE(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf writeInt(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf writeLong(long l2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf writeChar(int n2) {
        throw new IndexOutOfBoundsException();
    }

    public final ByteBuf writeBytes(ByteBuf byteBuf) {
        return this.checkLength(byteBuf.readableBytes());
    }

    public final ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        return this.checkLength(n2);
    }

    public final ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        return this.checkLength(n3);
    }

    public final ByteBuf writeBytes(byte[] byArray) {
        return this.checkLength(byArray.length);
    }

    public final ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        return this.checkLength(n3);
    }

    public final ByteBuf writeBytes(ByteBuffer byteBuffer) {
        return this.checkLength(byteBuffer.remaining());
    }

    public final int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) {
        this.checkLength(n2);
        return 0;
    }

    public final ByteBuf writeZero(int n2) {
        return this.checkLength(n2);
    }

    public final int writeCharSequence(CharSequence charSequence, Charset charset) {
        throw new IndexOutOfBoundsException();
    }

    public final int forEachByte(ByteProcessor byteProcessor) {
        return -1;
    }

    public final int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex(n2, n3);
        return -1;
    }

    public final ByteBuf slice() {
        return this;
    }

    public final ByteBuf retainedSlice() {
        return this;
    }

    public final ByteBuf slice(int n2, int n3) {
        return this.checkIndex(n2, n3);
    }

    public final ByteBuf duplicate() {
        return this;
    }

    public final ByteBuf retainedDuplicate() {
        return this;
    }

    public final int nioBufferCount() {
        return 1;
    }

    public final ByteBuffer nioBuffer() {
        return EMPTY_BYTE_BUFFER;
    }

    public final ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.nioBuffer();
    }

    public final ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{EMPTY_BYTE_BUFFER};
    }

    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.nioBuffers();
    }

    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        return EMPTY_BYTE_BUFFER;
    }

    public final boolean hasArray() {
        return true;
    }

    public final byte[] array() {
        return EmptyArrays.EMPTY_BYTES;
    }

    public final int arrayOffset() {
        return 0;
    }

    public final boolean hasMemoryAddress() {
        return EMPTY_BYTE_BUFFER_ADDRESS != 0L;
    }

    public final long memoryAddress() {
        if (this.hasMemoryAddress()) {
            return EMPTY_BYTE_BUFFER_ADDRESS;
        }
        throw new UnsupportedOperationException();
    }

    public final boolean isContiguous() {
        return true;
    }

    public final String toString(Charset charset) {
        return "";
    }

    public final String toString(int n2, int n3, Charset charset) {
        this.checkIndex(n2, n3);
        return this.toString(charset);
    }

    public final int hashCode() {
        return 1;
    }

    public final boolean equals(Object object) {
        return object instanceof ByteBuf && !((ByteBuf)object).isReadable();
    }

    public final int compareTo(ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            return -1;
        }
        return 0;
    }

    public final String toString() {
        return this.str;
    }

    public final boolean isWritable(int n2) {
        return false;
    }

    public final int refCnt() {
        return 1;
    }

    public final ByteBuf retain() {
        return this;
    }

    public final ByteBuf touch() {
        return this;
    }

    public final ByteBuf touch(Object object) {
        return this;
    }

    public final boolean release() {
        return false;
    }

    private ByteBuf checkIndex(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkIndex(int n2, int n3) {
        ObjectUtil.checkPositiveOrZero(n3, "length");
        if (n2 != 0 || n3 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private ByteBuf checkLength(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "length");
        if (n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    static {
        long l2 = 0L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                l2 = PlatformDependent.directBufferAddress(EMPTY_BYTE_BUFFER);
            }
        }
        catch (Throwable throwable) {}
        EMPTY_BYTE_BUFFER_ADDRESS = l2;
    }
}

