/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.buffer.SwappedByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.buffer.UnpooledDuplicatedByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledSlicedByteBuf;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.IllegalReferenceCountException;
import com.appoptics.ext.io.netty.util.ResourceLeakDetector;
import com.appoptics.ext.io.netty.util.ResourceLeakDetectorFactory;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public abstract class AbstractByteBuf
extends ByteBuf {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractByteBuf.class);
    static final boolean checkAccessible = SystemPropertyUtil.contains("com.appoptics.ext.io.netty.buffer.checkAccessible") ? SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.buffer.checkAccessible", true) : SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.buffer.bytebuf.checkAccessible", true);
    private static final boolean checkBounds = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.buffer.checkBounds", true);
    static final ResourceLeakDetector<ByteBuf> leakDetector;
    int readerIndex;
    int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private int maxCapacity;

    protected AbstractByteBuf(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "maxCapacity");
        this.maxCapacity = n2;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteBuf asReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return Unpooled.unmodifiableBuffer(this);
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    protected final void maxCapacity(int n2) {
        this.maxCapacity = n2;
    }

    public int readerIndex() {
        return this.readerIndex;
    }

    private static void checkIndexBounds(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > n3 || n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", n2, n3, n4));
        }
    }

    public ByteBuf readerIndex(int n2) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(n2, this.writerIndex, this.capacity());
        }
        this.readerIndex = n2;
        return this;
    }

    public int writerIndex() {
        return this.writerIndex;
    }

    public ByteBuf writerIndex(int n2) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(this.readerIndex, n2, this.capacity());
        }
        this.writerIndex = n2;
        return this;
    }

    public ByteBuf setIndex(int n2, int n3) {
        if (checkBounds) {
            AbstractByteBuf.checkIndexBounds(n2, n3, this.capacity());
        }
        this.setIndex0(n2, n3);
        return this;
    }

    public ByteBuf clear() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.writerIndex = 0;
        abstractByteBuf.readerIndex = 0;
        return this;
    }

    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    public boolean isWritable(int n2) {
        return this.capacity() - this.writerIndex >= n2;
    }

    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    public int maxWritableBytes() {
        return this.maxCapacity() - this.writerIndex;
    }

    public ByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    public ByteBuf resetReaderIndex() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.readerIndex(abstractByteBuf.markedReaderIndex);
        return this;
    }

    public ByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    public ByteBuf discardSomeReadBytes() {
        if (this.readerIndex > 0) {
            if (this.readerIndex == this.writerIndex) {
                this.ensureAccessible();
                AbstractByteBuf abstractByteBuf = this;
                abstractByteBuf.adjustMarkers(abstractByteBuf.readerIndex);
                AbstractByteBuf abstractByteBuf2 = this;
                abstractByteBuf2.readerIndex = 0;
                abstractByteBuf2.writerIndex = 0;
                return this;
            }
            if (this.readerIndex >= this.capacity() >>> 1) {
                AbstractByteBuf abstractByteBuf = this;
                this.setBytes(0, abstractByteBuf, abstractByteBuf.readerIndex, this.writerIndex - this.readerIndex);
                this.writerIndex -= this.readerIndex;
                AbstractByteBuf abstractByteBuf3 = this;
                abstractByteBuf3.adjustMarkers(abstractByteBuf3.readerIndex);
                this.readerIndex = 0;
                return this;
            }
        }
        this.ensureAccessible();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void adjustMarkers(int n2) {
        int n3 = this.markedReaderIndex;
        if (n3 > n2) {
            this.markedReaderIndex = n3 - n2;
            this.markedWriterIndex -= n2;
            return;
        }
        this.markedReaderIndex = 0;
        n3 = this.markedWriterIndex;
        if (n3 <= n2) {
            this.markedWriterIndex = 0;
            return;
        }
        this.markedWriterIndex = n3 - n2;
    }

    protected final void trimIndicesToCapacity(int n2) {
        if (this.writerIndex() > n2) {
            AbstractByteBuf abstractByteBuf = this;
            abstractByteBuf.setIndex0(Math.min(abstractByteBuf.readerIndex(), n2), n2);
        }
    }

    public ByteBuf ensureWritable(int n2) {
        this.ensureWritable0(ObjectUtil.checkPositiveOrZero(n2, "minWritableBytes"));
        return this;
    }

    final void ensureWritable0(int n2) {
        int n3 = this.writerIndex();
        int n4 = n3 + n2;
        if (n4 <= this.capacity()) {
            this.ensureAccessible();
            return;
        }
        if (checkBounds && n4 > this.maxCapacity) {
            this.ensureAccessible();
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", n3, n2, this.maxCapacity, this));
        }
        int n5 = this.maxFastWritableBytes();
        n2 = n5 >= n2 ? n3 + n5 : this.alloc().calculateNewCapacity(n4, this.maxCapacity);
        this.capacity(n2);
    }

    public int ensureWritable(int n2, boolean n3) {
        int n4;
        this.ensureAccessible();
        ObjectUtil.checkPositiveOrZero(n2, "minWritableBytes");
        if (n2 <= this.writableBytes()) {
            return 0;
        }
        int n5 = this.maxCapacity();
        if (n2 > n5 - (n4 = this.writerIndex())) {
            if (n3 == 0 || this.capacity() == n5) {
                return 1;
            }
            this.capacity(n5);
            return 3;
        }
        n3 = this.maxFastWritableBytes();
        n2 = n3 >= n2 ? n4 + n3 : this.alloc().calculateNewCapacity(n4 + n2, n5);
        this.capacity(n2);
        return 2;
    }

    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == this.order()) {
            return this;
        }
        ObjectUtil.checkNotNull(byteOrder, "endianness");
        return this.newSwappedByteBuf();
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        return new SwappedByteBuf(this);
    }

    public byte getByte(int n2) {
        this.checkIndex(n2);
        return this._getByte(n2);
    }

    protected abstract byte _getByte(int var1);

    public short getUnsignedByte(int n2) {
        return (short)(this.getByte(n2) & 0xFF);
    }

    public short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this._getShort(n2);
    }

    protected abstract short _getShort(int var1);

    public short getShortLE(int n2) {
        this.checkIndex(n2, 2);
        return this._getShortLE(n2);
    }

    protected abstract short _getShortLE(int var1);

    public int getUnsignedShort(int n2) {
        return this.getShort(n2) & 0xFFFF;
    }

    public int getUnsignedShortLE(int n2) {
        return this.getShortLE(n2) & 0xFFFF;
    }

    public int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMedium(n2);
    }

    protected abstract int _getUnsignedMedium(int var1);

    public int getMedium(int n2) {
        if (((n2 = this.getUnsignedMedium(n2)) & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    public int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this._getInt(n2);
    }

    protected abstract int _getInt(int var1);

    public int getIntLE(int n2) {
        this.checkIndex(n2, 4);
        return this._getIntLE(n2);
    }

    protected abstract int _getIntLE(int var1);

    public long getUnsignedInt(int n2) {
        return (long)this.getInt(n2) & 0xFFFFFFFFL;
    }

    public long getUnsignedIntLE(int n2) {
        return (long)this.getIntLE(n2) & 0xFFFFFFFFL;
    }

    public long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this._getLong(n2);
    }

    protected abstract long _getLong(int var1);

    public ByteBuf getBytes(int n2, byte[] byArray) {
        this.getBytes(n2, byArray, 0, byArray.length);
        return this;
    }

    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex(n2);
        this._setByte(n2, n3);
        return this;
    }

    protected abstract void _setByte(int var1, int var2);

    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShort(n2, n3);
        return this;
    }

    protected abstract void _setShort(int var1, int var2);

    public ByteBuf setShortLE(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShortLE(n2, n3);
        return this;
    }

    protected abstract void _setShortLE(int var1, int var2);

    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMedium(n2, n3);
        return this;
    }

    protected abstract void _setMedium(int var1, int var2);

    public ByteBuf setMediumLE(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMediumLE(n2, n3);
        return this;
    }

    protected abstract void _setMediumLE(int var1, int var2);

    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setInt(n2, n3);
        return this;
    }

    protected abstract void _setInt(int var1, int var2);

    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLong(n2, l2);
        return this;
    }

    protected abstract void _setLong(int var1, long var2);

    public ByteBuf setBytes(int n2, byte[] byArray) {
        this.setBytes(n2, byArray, 0, byArray.length);
        return this;
    }

    private static void checkReadableBounds(ByteBuf byteBuf, int n2) {
        if (n2 > byteBuf.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", n2, byteBuf.readableBytes(), byteBuf));
        }
    }

    public ByteBuf setZero(int n2, int n3) {
        if (n3 == 0) {
            return this;
        }
        this.checkIndex(n2, n3);
        int n4 = n3 >>> 3;
        n3 &= 7;
        while (n4 > 0) {
            this._setLong(n2, 0L);
            n2 += 8;
            --n4;
        }
        if (n3 == 4) {
            this._setInt(n2, 0);
        } else if (n3 < 4) {
            for (n4 = n3; n4 > 0; --n4) {
                this._setByte(n2, 0);
                ++n2;
            }
        } else {
            this._setInt(n2, 0);
            n2 += 4;
            for (n4 = n3 - 4; n4 > 0; --n4) {
                this._setByte(n2, 0);
                ++n2;
            }
        }
        return this;
    }

    public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        return this.setCharSequence0(n2, charSequence, charset, false);
    }

    private int setCharSequence0(int n2, CharSequence charSequence, Charset object, boolean bl) {
        if (((Charset)object).equals(CharsetUtil.UTF_8)) {
            int n3 = ByteBufUtil.utf8MaxBytes(charSequence);
            if (bl) {
                this.ensureWritable0(n3);
                this.checkIndex0(n2, n3);
            } else {
                this.checkIndex(n2, n3);
            }
            CharSequence charSequence2 = charSequence;
            return ByteBufUtil.writeUtf8(this, n2, charSequence2, charSequence2.length());
        }
        if (((Charset)object).equals(CharsetUtil.US_ASCII) || ((Charset)object).equals(CharsetUtil.ISO_8859_1)) {
            int n4 = charSequence.length();
            if (bl) {
                this.ensureWritable0(n4);
                this.checkIndex0(n2, n4);
            } else {
                this.checkIndex(n2, n4);
            }
            return ByteBufUtil.writeAscii(this, n2, charSequence, n4);
        }
        object = charSequence.toString().getBytes((Charset)object);
        if (bl) {
            this.ensureWritable0(((Object)object).length);
        }
        this.setBytes(n2, (byte[])object);
        return ((Object)object).length;
    }

    public byte readByte() {
        this.checkReadableBytes0(1);
        int n2 = this.readerIndex;
        byte by = this._getByte(n2);
        this.readerIndex = n2 + 1;
        return by;
    }

    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    public short readShort() {
        this.checkReadableBytes0(2);
        AbstractByteBuf abstractByteBuf = this;
        short s2 = abstractByteBuf._getShort(abstractByteBuf.readerIndex);
        this.readerIndex += 2;
        return s2;
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readMedium() {
        int n2 = this.readUnsignedMedium();
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    public int readUnsignedMedium() {
        this.checkReadableBytes0(3);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf._getUnsignedMedium(abstractByteBuf.readerIndex);
        this.readerIndex += 3;
        return n2;
    }

    public int readInt() {
        this.checkReadableBytes0(4);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf._getInt(abstractByteBuf.readerIndex);
        this.readerIndex += 4;
        return n2;
    }

    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() {
        this.checkReadableBytes0(8);
        AbstractByteBuf abstractByteBuf = this;
        long l2 = abstractByteBuf._getLong(abstractByteBuf.readerIndex);
        this.readerIndex += 8;
        return l2;
    }

    public ByteBuf readBytes(int n2) {
        this.checkReadableBytes(n2);
        if (n2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = this.alloc().buffer(n2, this.maxCapacity);
        AbstractByteBuf abstractByteBuf = this;
        byteBuf.writeBytes(abstractByteBuf, abstractByteBuf.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    public ByteBuf readSlice(int n2) {
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        ByteBuf byteBuf = abstractByteBuf.slice(abstractByteBuf.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    public ByteBuf readRetainedSlice(int n2) {
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        ByteBuf byteBuf = abstractByteBuf.retainedSlice(abstractByteBuf.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, byArray, n2, n3);
        this.readerIndex += n3;
        return this;
    }

    public ByteBuf readBytes(byte[] byArray) {
        this.readBytes(byArray, 0, byArray.length);
        return this;
    }

    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        int n3 = abstractByteBuf.getBytes(abstractByteBuf.readerIndex, gatheringByteChannel, n2);
        this.readerIndex += n3;
        return n3;
    }

    public ByteBuf skipBytes(int n2) {
        this.checkReadableBytes(n2);
        this.readerIndex += n2;
        return this;
    }

    public ByteBuf writeByte(int n2) {
        this.ensureWritable0(1);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setByte(abstractByteBuf.writerIndex++, n2);
        return this;
    }

    public ByteBuf writeShort(int n2) {
        this.ensureWritable0(2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setShort(abstractByteBuf.writerIndex, n2);
        this.writerIndex += 2;
        return this;
    }

    public ByteBuf writeShortLE(int n2) {
        this.ensureWritable0(2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setShortLE(abstractByteBuf.writerIndex, n2);
        this.writerIndex += 2;
        return this;
    }

    public ByteBuf writeMedium(int n2) {
        this.ensureWritable0(3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setMedium(abstractByteBuf.writerIndex, n2);
        this.writerIndex += 3;
        return this;
    }

    public ByteBuf writeMediumLE(int n2) {
        this.ensureWritable0(3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setMediumLE(abstractByteBuf.writerIndex, n2);
        this.writerIndex += 3;
        return this;
    }

    public ByteBuf writeInt(int n2) {
        this.ensureWritable0(4);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setInt(abstractByteBuf.writerIndex, n2);
        this.writerIndex += 4;
        return this;
    }

    public ByteBuf writeLong(long l2) {
        this.ensureWritable0(8);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setLong(abstractByteBuf.writerIndex, l2);
        this.writerIndex += 8;
        return this;
    }

    public ByteBuf writeChar(int n2) {
        this.writeShort(n2);
        return this;
    }

    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        this.ensureWritable(n3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byArray, n2, n3);
        this.writerIndex += n3;
        return this;
    }

    public ByteBuf writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        this.writeBytes(byteBuf2, byteBuf2.readableBytes());
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        if (checkBounds) {
            AbstractByteBuf.checkReadableBounds(byteBuf, n2);
        }
        ByteBuf byteBuf2 = byteBuf;
        this.writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.readerIndex() + n2);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        this.ensureWritable(n3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byteBuf, n2, n3);
        this.writerIndex += n3;
        return this;
    }

    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.ensureWritable0(n2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byteBuffer);
        this.writerIndex += n2;
        return this;
    }

    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) throws IOException {
        this.ensureWritable(n2);
        AbstractByteBuf abstractByteBuf = this;
        int n3 = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, scatteringByteChannel, n2);
        if (n3 > 0) {
            this.writerIndex += n3;
        }
        return n3;
    }

    public ByteBuf writeZero(int n2) {
        if (n2 == 0) {
            return this;
        }
        this.ensureWritable(n2);
        int n3 = this.writerIndex;
        this.checkIndex0(n3, n2);
        int n4 = n2 >>> 3;
        n2 &= 7;
        while (n4 > 0) {
            this._setLong(n3, 0L);
            n3 += 8;
            --n4;
        }
        if (n2 == 4) {
            this._setInt(n3, 0);
            n3 += 4;
        } else if (n2 < 4) {
            for (n4 = n2; n4 > 0; --n4) {
                this._setByte(n3, 0);
                ++n3;
            }
        } else {
            this._setInt(n3, 0);
            n3 += 4;
            for (n4 = n2 - 4; n4 > 0; --n4) {
                this._setByte(n3, 0);
                ++n3;
            }
        }
        this.writerIndex = n3;
        return this;
    }

    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf.setCharSequence0(abstractByteBuf.writerIndex, charSequence, charset, true);
        this.writerIndex += n2;
        return n2;
    }

    public ByteBuf duplicate() {
        this.ensureAccessible();
        return new UnpooledDuplicatedByteBuf(this);
    }

    public ByteBuf retainedDuplicate() {
        return this.duplicate().retain();
    }

    public ByteBuf slice() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.slice(abstractByteBuf.readerIndex, this.readableBytes());
    }

    public ByteBuf retainedSlice() {
        return this.slice().retain();
    }

    public ByteBuf slice(int n2, int n3) {
        this.ensureAccessible();
        return new UnpooledSlicedByteBuf(this, n2, n3);
    }

    public ByteBuf retainedSlice(int n2, int n3) {
        return this.slice(n2, n3).retain();
    }

    public ByteBuffer nioBuffer() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.nioBuffer(abstractByteBuf.readerIndex, this.readableBytes());
    }

    public ByteBuffer[] nioBuffers() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.nioBuffers(abstractByteBuf.readerIndex, this.readableBytes());
    }

    public String toString(Charset charset) {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.toString(abstractByteBuf.readerIndex, this.readableBytes(), charset);
    }

    public String toString(int n2, int n3, Charset charset) {
        return ByteBufUtil.decodeString(this, n2, n3, charset);
    }

    public int forEachByte(ByteProcessor object) {
        this.ensureAccessible();
        try {
            AbstractByteBuf abstractByteBuf = this;
            return abstractByteBuf.forEachByteAsc0(abstractByteBuf.readerIndex, this.writerIndex, (ByteProcessor)object);
        }
        catch (Exception exception) {
            object = exception;
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex(n2, n3);
        try {
            int n4 = n2;
            return this.forEachByteAsc0(n4, n4 + n3, byteProcessor);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    int forEachByteAsc0(int n2, int n3, ByteProcessor byteProcessor) throws Exception {
        while (n2 < n3) {
            if (!byteProcessor.process(this._getByte(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int hashCode() {
        return ByteBufUtil.hashCode(this);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ByteBuf && ByteBufUtil.equals(this, (ByteBuf)object);
    }

    public int compareTo(ByteBuf byteBuf) {
        return ByteBufUtil.compare(this, byteBuf);
    }

    public String toString() {
        ByteBuf byteBuf;
        if (this.refCnt() == 0) {
            return StringUtil.simpleClassName(this) + "(freed)";
        }
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            stringBuilder.append('/').append(this.maxCapacity);
        }
        if ((byteBuf = this.unwrap()) != null) {
            stringBuilder.append(", unwrapped: ").append(byteBuf);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected final void checkIndex(int n2) {
        this.checkIndex(n2, 1);
    }

    protected final void checkIndex(int n2, int n3) {
        this.ensureAccessible();
        this.checkIndex0(n2, n3);
    }

    private static void checkRangeBounds(String string, int n2, int n3, int n4) {
        if (MathUtil.isOutOfBounds(n2, n3, n4)) {
            throw new IndexOutOfBoundsException(String.format("%s: %d, length: %d (expected: range(0, %d))", string, n2, n3, n4));
        }
    }

    final void checkIndex0(int n2, int n3) {
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("index", n2, n3, this.capacity());
        }
    }

    protected final void checkSrcIndex(int n2, int n3, int n4, int n5) {
        this.checkIndex(n2, n3);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("srcIndex", n4, n3, n5);
        }
    }

    protected final void checkDstIndex(int n2, int n3, int n4, int n5) {
        this.checkIndex(n2, n3);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("dstIndex", n4, n3, n5);
        }
    }

    protected final void checkDstIndex(int n2, int n3, int n4) {
        this.checkReadableBytes(n2);
        if (checkBounds) {
            AbstractByteBuf.checkRangeBounds("dstIndex", n3, n2, n4);
        }
    }

    protected final void checkReadableBytes(int n2) {
        this.checkReadableBytes0(ObjectUtil.checkPositiveOrZero(n2, "minimumReadableBytes"));
    }

    protected final void checkNewCapacity(int n2) {
        this.ensureAccessible();
        if (checkBounds && (n2 < 0 || n2 > this.maxCapacity())) {
            throw new IllegalArgumentException("newCapacity: " + n2 + " (expected: 0-" + this.maxCapacity() + ')');
        }
    }

    private void checkReadableBytes0(int n2) {
        this.ensureAccessible();
        if (checkBounds && this.readerIndex > this.writerIndex - n2) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, n2, this.writerIndex, this));
        }
    }

    protected final void ensureAccessible() {
        if (checkAccessible && !this.isAccessible()) {
            throw new IllegalReferenceCountException(0);
        }
    }

    final void setIndex0(int n2, int n3) {
        this.readerIndex = n2;
        this.writerIndex = n3;
    }

    final void discardMarks() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.markedWriterIndex = 0;
        abstractByteBuf.markedReaderIndex = 0;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)"com.appoptics.ext.io.netty.buffer.checkAccessible", (Object)checkAccessible);
            logger.debug("-D{}: {}", (Object)"com.appoptics.ext.io.netty.buffer.checkBounds", (Object)checkBounds);
        }
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ByteBuf.class);
    }
}

