/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.Grpc;
import com.appoptics.ext.io.grpc.InternalChannelz;
import com.appoptics.ext.io.grpc.SecurityLevel;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.TlsChannelCredentials;
import com.appoptics.ext.io.grpc.TlsServerCredentials;
import com.appoptics.ext.io.grpc.internal.GrpcAttributes;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.ObjectPool;
import com.appoptics.ext.io.grpc.netty.GrpcHttp2ConnectionHandler;
import com.appoptics.ext.io.grpc.netty.JettyTlsUtil;
import com.appoptics.ext.io.grpc.netty.NettyClientTransport;
import com.appoptics.ext.io.grpc.netty.ProtocolNegotiationEvent;
import com.appoptics.ext.io.grpc.netty.ProtocolNegotiator;
import com.appoptics.ext.io.grpc.netty.Utils;
import com.appoptics.ext.io.netty.channel.ChannelDuplexHandler;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelInboundHandlerAdapter;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpClientCodec;
import com.appoptics.ext.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMethod;
import com.appoptics.ext.io.netty.handler.codec.http.HttpVersion;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import com.appoptics.ext.io.netty.handler.proxy.HttpProxyHandler;
import com.appoptics.ext.io.netty.handler.proxy.ProxyConnectionEvent;
import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.handler.ssl.OpenSslEngine;
import com.appoptics.ext.io.netty.handler.ssl.SslCompletionEvent;
import com.appoptics.ext.io.netty.handler.ssl.SslContext;
import com.appoptics.ext.io.netty.handler.ssl.SslHandler;
import com.appoptics.ext.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.appoptics.ext.io.netty.handler.ssl.SslProvider;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.AttributeMap;
import com.tracelytics.a.d.a.a.d;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProtocolNegotiators {
    private static final Logger log = Logger.getLogger(ProtocolNegotiators.class.getName());
    private static final EnumSet<TlsChannelCredentials.Feature> understoodTlsFeatures = EnumSet.noneOf(TlsChannelCredentials.Feature.class);
    private static final EnumSet<TlsServerCredentials.Feature> understoodServerTlsFeatures = EnumSet.noneOf(TlsServerCredentials.Feature.class);

    private ProtocolNegotiators() {
    }

    static ChannelLogger negotiationLogger(ChannelHandlerContext channelHandlerContext) {
        return ProtocolNegotiators.negotiationLogger(channelHandlerContext.channel());
    }

    private static ChannelLogger negotiationLogger(AttributeMap object) {
        object = object.attr(NettyClientTransport.LOGGER_KEY);
        if ((object = object.get()) != null) {
            return object;
        }
        final class NoopChannelLogger
        extends ChannelLogger {
            NoopChannelLogger() {
            }

            public final void log(ChannelLogger.ChannelLogLevel channelLogLevel, String string) {
            }

            public final void log(ChannelLogger.ChannelLogLevel channelLogLevel, String string, Object ... objectArray) {
            }
        }
        return new NoopChannelLogger();
    }

    public static ProtocolNegotiator httpProxy(final SocketAddress socketAddress, final String string, final String string2, final ProtocolNegotiator protocolNegotiator) {
        b.a(protocolNegotiator, (Object)"negotiator");
        b.a(socketAddress, (Object)"proxyAddress");
        final AsciiString asciiString = protocolNegotiator.scheme();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ProxyNegotiator
        implements ProtocolNegotiator {
            ProxyNegotiator() {
            }

            @Override
            public ChannelHandler newHandler(GrpcHttp2ConnectionHandler channelHandler) {
                channelHandler = protocolNegotiator.newHandler((GrpcHttp2ConnectionHandler)channelHandler);
                return new ProxyProtocolNegotiationHandler(socketAddress, string, string2, channelHandler);
            }

            @Override
            public AsciiString scheme() {
                return asciiString;
            }

            @Override
            public void close() {
                protocolNegotiator.close();
            }
        }
        return new ProxyNegotiator();
    }

    static HostPort parseAuthority(String string) {
        int n2;
        URI uRI = GrpcUtil.authorityToUri(b.a(string, (Object)"authority"));
        if (uRI.getHost() != null) {
            string = uRI.getHost();
            n2 = uRI.getPort();
        } else {
            n2 = -1;
        }
        return new HostPort(string, n2);
    }

    public static ProtocolNegotiator tls(SslContext sslContext, ObjectPool<? extends Executor> objectPool) {
        return new ClientTlsProtocolNegotiator(sslContext, objectPool);
    }

    public static ProtocolNegotiator plaintextUpgrade() {
        return new PlaintextUpgradeProtocolNegotiator();
    }

    public static ProtocolNegotiator plaintext() {
        return new PlaintextProtocolNegotiator();
    }

    private static RuntimeException unavailableException(String string) {
        return Status.UNAVAILABLE.withDescription(string).asRuntimeException();
    }

    static void logSslEngineDetails(Level level, ChannelHandlerContext object, String charSequence, Throwable throwable) {
        if (!log.isLoggable(level)) {
            return;
        }
        object = object.pipeline().get(SslHandler.class);
        SSLEngine sSLEngine = ((SslHandler)object).engine();
        charSequence = new StringBuilder((String)charSequence);
        ((StringBuilder)charSequence).append("\nSSLEngine Details: [\n");
        if (sSLEngine instanceof OpenSslEngine) {
            ((StringBuilder)charSequence).append("    OpenSSL, ");
            ((StringBuilder)charSequence).append("Version: 0x").append(Integer.toHexString(OpenSsl.version()));
            ((StringBuilder)charSequence).append(" (").append(OpenSsl.versionString()).append("), ");
            ((StringBuilder)charSequence).append("ALPN supported: ").append(SslProvider.isAlpnSupported(SslProvider.OPENSSL));
        } else if (JettyTlsUtil.isJettyAlpnConfigured()) {
            ((StringBuilder)charSequence).append("    Jetty ALPN");
        } else if (JettyTlsUtil.isJettyNpnConfigured()) {
            ((StringBuilder)charSequence).append("    Jetty NPN");
        } else if (JettyTlsUtil.isJava9AlpnAvailable()) {
            ((StringBuilder)charSequence).append("    JDK9 ALPN");
        }
        ((StringBuilder)charSequence).append("\n    TLS Protocol: ");
        ((StringBuilder)charSequence).append(sSLEngine.getSession().getProtocol());
        ((StringBuilder)charSequence).append("\n    Application Protocol: ");
        ((StringBuilder)charSequence).append(((SslHandler)object).applicationProtocol());
        ((StringBuilder)charSequence).append("\n    Need Client Auth: ");
        ((StringBuilder)charSequence).append(sSLEngine.getNeedClientAuth());
        ((StringBuilder)charSequence).append("\n    Want Client Auth: ");
        ((StringBuilder)charSequence).append(sSLEngine.getWantClientAuth());
        ((StringBuilder)charSequence).append("\n    Supported protocols=");
        ((StringBuilder)charSequence).append(Arrays.toString(sSLEngine.getSupportedProtocols()));
        ((StringBuilder)charSequence).append("\n    Enabled protocols=");
        ((StringBuilder)charSequence).append(Arrays.toString(sSLEngine.getEnabledProtocols()));
        ((StringBuilder)charSequence).append("\n    Supported ciphers=");
        ((StringBuilder)charSequence).append(Arrays.toString(sSLEngine.getSupportedCipherSuites()));
        ((StringBuilder)charSequence).append("\n    Enabled ciphers=");
        ((StringBuilder)charSequence).append(Arrays.toString(sSLEngine.getEnabledCipherSuites()));
        ((StringBuilder)charSequence).append("\n]");
        log.log(level, ((StringBuilder)charSequence).toString(), throwable);
    }

    static class ProtocolNegotiationHandler
    extends ChannelDuplexHandler {
        private final ChannelHandler next;
        private final String negotiatorName;
        private ProtocolNegotiationEvent pne;

        protected ProtocolNegotiationHandler(ChannelHandler channelHandler) {
            this.next = b.a(channelHandler, (Object)"next");
            this.negotiatorName = this.getClass().getSimpleName().replace("Handler", "");
        }

        public final void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
            ProtocolNegotiators.negotiationLogger(channelHandlerContext).log(ChannelLogger.ChannelLogLevel.DEBUG, "{0} started", this.negotiatorName);
            this.handlerAdded0(channelHandlerContext);
        }

        protected void handlerAdded0(ChannelHandlerContext channelHandlerContext) throws Exception {
            super.handlerAdded(channelHandlerContext);
        }

        public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            if (object instanceof ProtocolNegotiationEvent) {
                Object object2 = object;
                ProtocolNegotiationEvent protocolNegotiationEvent = this.pne;
                String string = "pre-existing negotiation: %s < %s";
                boolean bl = this.pne == null;
                if (!bl) {
                    throw new IllegalStateException(d.a(string, protocolNegotiationEvent, object2));
                }
                this.pne = (ProtocolNegotiationEvent)object;
                this.protocolNegotiationEventTriggered(channelHandlerContext);
                return;
            }
            this.userEventTriggered0(channelHandlerContext, object);
        }

        protected void userEventTriggered0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            super.userEventTriggered(channelHandlerContext, object);
        }

        protected void protocolNegotiationEventTriggered(ChannelHandlerContext channelHandlerContext) {
        }

        protected final ProtocolNegotiationEvent getProtocolNegotiationEvent() {
            b.b(this.pne != null, "previous protocol negotiation event hasn't triggered");
            return this.pne;
        }

        protected final void replaceProtocolNegotiationEvent(ProtocolNegotiationEvent protocolNegotiationEvent) {
            b.b(this.pne != null, "previous protocol negotiation event hasn't triggered");
            this.pne = b.a(protocolNegotiationEvent);
        }

        protected final void fireProtocolNegotiationEvent(ChannelHandlerContext channelHandlerContext) {
            b.b(this.pne != null, "previous protocol negotiation event hasn't triggered");
            ProtocolNegotiators.negotiationLogger(channelHandlerContext).log(ChannelLogger.ChannelLogLevel.INFO, "{0} completed", this.negotiatorName);
            channelHandlerContext.pipeline().replace(channelHandlerContext.name(), null, this.next);
            channelHandlerContext.fireUserEventTriggered(this.pne);
        }
    }

    static final class WaitUntilActiveHandler
    extends ProtocolNegotiationHandler {
        boolean protocolNegotiationEventReceived;

        WaitUntilActiveHandler(ChannelHandler channelHandler) {
            super(channelHandler);
        }

        public final void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            if (this.protocolNegotiationEventReceived) {
                this.replaceOnActive(channelHandlerContext);
                this.fireProtocolNegotiationEvent(channelHandlerContext);
            }
            super.channelActive(channelHandlerContext);
        }

        protected final void protocolNegotiationEventTriggered(ChannelHandlerContext channelHandlerContext) {
            this.protocolNegotiationEventReceived = true;
            if (channelHandlerContext.channel().isActive()) {
                this.replaceOnActive(channelHandlerContext);
                this.fireProtocolNegotiationEvent(channelHandlerContext);
            }
        }

        private void replaceOnActive(ChannelHandlerContext object) {
            ProtocolNegotiationEvent protocolNegotiationEvent = this.getProtocolNegotiationEvent();
            object = protocolNegotiationEvent.getAttributes().toBuilder().set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, object.channel().localAddress()).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, object.channel().remoteAddress()).set(GrpcAttributes.ATTR_SECURITY_LEVEL, SecurityLevel.NONE).build();
            this.replaceProtocolNegotiationEvent(protocolNegotiationEvent.withAttributes((Attributes)object));
        }
    }

    static final class PlaintextProtocolNegotiator
    implements ProtocolNegotiator {
        PlaintextProtocolNegotiator() {
        }

        public final ChannelHandler newHandler(GrpcHttp2ConnectionHandler channelInboundHandlerAdapter) {
            channelInboundHandlerAdapter = new GrpcNegotiationHandler((GrpcHttp2ConnectionHandler)channelInboundHandlerAdapter);
            channelInboundHandlerAdapter = new WaitUntilActiveHandler(channelInboundHandlerAdapter);
            return channelInboundHandlerAdapter;
        }

        public final void close() {
        }

        public final AsciiString scheme() {
            return Utils.HTTP;
        }
    }

    static final class GrpcNegotiationHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler next;

        public GrpcNegotiationHandler(GrpcHttp2ConnectionHandler grpcHttp2ConnectionHandler) {
            this.next = b.a(grpcHttp2ConnectionHandler, (Object)"next");
        }

        public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            if (object instanceof ProtocolNegotiationEvent) {
                object = (ProtocolNegotiationEvent)object;
                channelHandlerContext.pipeline().replace(channelHandlerContext.name(), null, this.next);
                this.next.handleProtocolNegotiationCompleted(((ProtocolNegotiationEvent)object).getAttributes(), ((ProtocolNegotiationEvent)object).getSecurity());
                return;
            }
            super.userEventTriggered(channelHandlerContext, object);
        }
    }

    static final class Http2UpgradeAndGrpcHandler
    extends ChannelInboundHandlerAdapter {
        private final String authority;
        private final GrpcHttp2ConnectionHandler next;
        private ProtocolNegotiationEvent pne;

        Http2UpgradeAndGrpcHandler(String string, GrpcHttp2ConnectionHandler grpcHttp2ConnectionHandler) {
            this.authority = b.a(string, (Object)"authority");
            this.next = b.a(grpcHttp2ConnectionHandler, (Object)"next");
        }

        public final void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
            ProtocolNegotiators.negotiationLogger(channelHandlerContext).log(ChannelLogger.ChannelLogLevel.INFO, "Http2Upgrade started");
            Object object = new HttpClientCodec();
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), null, (ChannelHandler)object);
            Http2ClientUpgradeCodec http2ClientUpgradeCodec = new Http2ClientUpgradeCodec(this.next);
            object = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)object, http2ClientUpgradeCodec, 1000);
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), null, (ChannelHandler)object);
            object = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            ((DefaultHttpMessage)object).headers().add(HttpHeaderNames.HOST, (Object)this.authority);
            channelHandlerContext.writeAndFlush(object).addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            super.handlerAdded(channelHandlerContext);
        }

        public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            if (object instanceof ProtocolNegotiationEvent) {
                b.b(this.pne == null, "negotiation already started");
                this.pne = (ProtocolNegotiationEvent)object;
                return;
            }
            if (object == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                b.b(this.pne != null, "negotiation not yet complete");
                ProtocolNegotiators.negotiationLogger(channelHandlerContext).log(ChannelLogger.ChannelLogLevel.INFO, "Http2Upgrade finished");
                channelHandlerContext.pipeline().remove(channelHandlerContext.name());
                this.next.handleProtocolNegotiationCompleted(this.pne.getAttributes(), this.pne.getSecurity());
                return;
            }
            if (object == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                channelHandlerContext.fireExceptionCaught(ProtocolNegotiators.unavailableException("HTTP/2 upgrade rejected"));
                return;
            }
            super.userEventTriggered(channelHandlerContext, object);
        }
    }

    static final class PlaintextUpgradeProtocolNegotiator
    implements ProtocolNegotiator {
        PlaintextUpgradeProtocolNegotiator() {
        }

        public final AsciiString scheme() {
            return Utils.HTTP;
        }

        public final ChannelHandler newHandler(GrpcHttp2ConnectionHandler channelInboundHandlerAdapter) {
            channelInboundHandlerAdapter = new Http2UpgradeAndGrpcHandler(channelInboundHandlerAdapter.getAuthority(), (GrpcHttp2ConnectionHandler)channelInboundHandlerAdapter);
            return new WaitUntilActiveHandler(channelInboundHandlerAdapter);
        }

        public final void close() {
        }
    }

    static final class HostPort {
        final String host;
        final int port;

        public HostPort(String string, int n2) {
            this.host = string;
            this.port = n2;
        }
    }

    static final class ClientTlsHandler
    extends ProtocolNegotiationHandler {
        private final SslContext sslContext;
        private final String host;
        private final int port;
        private Executor executor;

        ClientTlsHandler(ChannelHandler object, SslContext sslContext, String string, Executor executor) {
            super((ChannelHandler)object);
            this.sslContext = b.a(sslContext, (Object)"sslContext");
            object = ProtocolNegotiators.parseAuthority(string);
            this.host = ((HostPort)object).host;
            this.port = ((HostPort)object).port;
            this.executor = executor;
        }

        protected final void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
            SSLEngine sSLEngine = this.sslContext.newEngine(channelHandlerContext.alloc(), this.host, this.port);
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sSLEngine.setSSLParameters(sSLParameters);
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), null, this.executor != null ? new SslHandler(sSLEngine, false, this.executor) : new SslHandler(sSLEngine, false));
        }

        protected final void userEventTriggered0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            block5: {
                block1: {
                    block4: {
                        block2: {
                            block3: {
                                if (!(object instanceof SslHandshakeCompletionEvent)) break block1;
                                if (!((SslCompletionEvent)(object = (SslHandshakeCompletionEvent)object)).isSuccess()) break block2;
                                object = channelHandlerContext.pipeline().get(SslHandler.class);
                                if (!this.sslContext.applicationProtocolNegotiator().protocols().contains(((SslHandler)object).applicationProtocol())) break block3;
                                ProtocolNegotiators.logSslEngineDetails(Level.FINER, channelHandlerContext, "TLS negotiation succeeded.", null);
                                this.propagateTlsComplete(channelHandlerContext, ((SslHandler)object).engine().getSession());
                                break block4;
                            }
                            object = ProtocolNegotiators.unavailableException("Failed ALPN negotiation: Unable to find compatible protocol");
                            ProtocolNegotiators.logSslEngineDetails(Level.FINE, channelHandlerContext, "TLS negotiation failed.", (Throwable)object);
                            channelHandlerContext.fireExceptionCaught((Throwable)object);
                            break block5;
                        }
                        if ((object = ((SslCompletionEvent)object).cause()) instanceof ClosedChannelException) {
                            object = Status.UNAVAILABLE.withDescription("Connection closed while performing TLS negotiation").withCause((Throwable)object).asRuntimeException();
                        }
                        channelHandlerContext.fireExceptionCaught((Throwable)object);
                    }
                    return;
                }
                super.userEventTriggered0(channelHandlerContext, object);
            }
        }

        private void propagateTlsComplete(ChannelHandlerContext channelHandlerContext, SSLSession object) {
            InternalChannelz.Security security = new InternalChannelz.Security(new InternalChannelz.Tls((SSLSession)object));
            ProtocolNegotiationEvent protocolNegotiationEvent = this.getProtocolNegotiationEvent();
            object = protocolNegotiationEvent.getAttributes().toBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, SecurityLevel.PRIVACY_AND_INTEGRITY).set(Grpc.TRANSPORT_ATTR_SSL_SESSION, object).build();
            this.replaceProtocolNegotiationEvent(protocolNegotiationEvent.withAttributes((Attributes)object).withSecurity(security));
            this.fireProtocolNegotiationEvent(channelHandlerContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ClientTlsProtocolNegotiator
    implements ProtocolNegotiator {
        private final SslContext sslContext;
        private final ObjectPool<? extends Executor> executorPool;
        private Executor executor;

        public ClientTlsProtocolNegotiator(SslContext sslContext, ObjectPool<? extends Executor> objectPool) {
            this.sslContext = b.a(sslContext, (Object)"sslContext");
            this.executorPool = objectPool;
            if (this.executorPool != null) {
                this.executor = this.executorPool.getObject();
            }
        }

        @Override
        public final AsciiString scheme() {
            return Utils.HTTPS;
        }

        @Override
        public final ChannelHandler newHandler(GrpcHttp2ConnectionHandler channelInboundHandlerAdapter) {
            GrpcNegotiationHandler grpcNegotiationHandler = new GrpcNegotiationHandler((GrpcHttp2ConnectionHandler)channelInboundHandlerAdapter);
            channelInboundHandlerAdapter = new ClientTlsHandler(grpcNegotiationHandler, this.sslContext, channelInboundHandlerAdapter.getAuthority(), this.executor);
            return new WaitUntilActiveHandler(channelInboundHandlerAdapter);
        }

        @Override
        public final void close() {
            if (this.executorPool != null && this.executor != null) {
                this.executorPool.returnObject(this.executor);
            }
        }
    }

    static final class ProxyProtocolNegotiationHandler
    extends ProtocolNegotiationHandler {
        private final SocketAddress address;
        private final String userName;
        private final String password;

        public ProxyProtocolNegotiationHandler(SocketAddress socketAddress, String string, String string2, ChannelHandler channelHandler) {
            super(channelHandler);
            this.address = b.a(socketAddress, (Object)"address");
            this.userName = string;
            this.password = string2;
        }

        protected final void protocolNegotiationEventTriggered(ChannelHandlerContext channelHandlerContext) {
            HttpProxyHandler httpProxyHandler = this.userName == null || this.password == null ? new HttpProxyHandler(this.address) : new HttpProxyHandler(this.address, this.userName, this.password);
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), null, httpProxyHandler);
        }

        protected final void userEventTriggered0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            if (object instanceof ProxyConnectionEvent) {
                this.fireProtocolNegotiationEvent(channelHandlerContext);
                return;
            }
            super.userEventTriggered(channelHandlerContext, object);
        }
    }
}

