/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.a.c;
import com.appoptics.ext.io.a.d;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.InternalKnownTransport;
import com.appoptics.ext.io.grpc.InternalMethodDescriptor;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.AbstractClientStream;
import com.appoptics.ext.io.grpc.internal.Http2ClientStreamTransportState;
import com.appoptics.ext.io.grpc.internal.StatsTraceContext;
import com.appoptics.ext.io.grpc.internal.TransportTracer;
import com.appoptics.ext.io.grpc.internal.WritableBuffer;
import com.appoptics.ext.io.grpc.netty.CancelClientStreamCommand;
import com.appoptics.ext.io.grpc.netty.CreateStreamCommand;
import com.appoptics.ext.io.grpc.netty.NettyClientHandler;
import com.appoptics.ext.io.grpc.netty.NettyClientTransport;
import com.appoptics.ext.io.grpc.netty.NettyReadableBuffer;
import com.appoptics.ext.io.grpc.netty.NettyWritableBuffer;
import com.appoptics.ext.io.grpc.netty.NettyWritableBufferAllocator;
import com.appoptics.ext.io.grpc.netty.SendGrpcFrameCommand;
import com.appoptics.ext.io.grpc.netty.StreamIdHolder;
import com.appoptics.ext.io.grpc.netty.Utils;
import com.appoptics.ext.io.grpc.netty.WriteQueue;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.EventLoop;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.tracelytics.a.d.a.d.a;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NettyClientStream
extends AbstractClientStream {
    private static final InternalMethodDescriptor methodDescriptorAccessor = new InternalMethodDescriptor(NettyClientTransport.class.getName().contains("grpc.netty.shaded") ? InternalKnownTransport.NETTY_SHADED : InternalKnownTransport.NETTY);
    private final Sink sink = new Sink();
    private final TransportState state;
    private final WriteQueue writeQueue;
    private final MethodDescriptor<?, ?> method;
    private AsciiString authority;
    private final AsciiString scheme;
    private final AsciiString userAgent;

    NettyClientStream(TransportState transportState, MethodDescriptor<?, ?> methodDescriptor, Metadata metadata, Channel channel, AsciiString asciiString, AsciiString asciiString2, AsciiString asciiString3, StatsTraceContext statsTraceContext, TransportTracer transportTracer, CallOptions callOptions, boolean bl) {
        super(new NettyWritableBufferAllocator(channel.alloc()), statsTraceContext, transportTracer, metadata, callOptions, bl && methodDescriptor.isSafe());
        this.state = b.a(transportState, (Object)"transportState");
        this.writeQueue = transportState.handler.getWriteQueue();
        this.method = b.a(methodDescriptor, (Object)"method");
        this.authority = b.a(asciiString, (Object)"authority");
        this.scheme = b.a(asciiString2, (Object)"scheme");
        this.userAgent = asciiString3;
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractClientStreamSink() {
        return this.sink;
    }

    @Override
    public void setAuthority(String string) {
        this.authority = AsciiString.of(b.a(string, (Object)"authority"));
    }

    @Override
    public Attributes getAttributes() {
        return this.state.handler.getAttributes();
    }

    public static abstract class TransportState
    extends Http2ClientStreamTransportState
    implements StreamIdHolder {
        private final String methodName;
        private final NettyClientHandler handler;
        private final EventLoop eventLoop;
        private int id;
        private Http2Stream http2Stream;
        private d tag;

        protected TransportState(NettyClientHandler nettyClientHandler, EventLoop eventLoop, int n2, StatsTraceContext statsTraceContext, TransportTracer transportTracer, String string) {
            super(n2, statsTraceContext, transportTracer);
            this.methodName = b.a(string, (Object)"methodName");
            this.handler = b.a(nettyClientHandler, (Object)"handler");
            this.eventLoop = b.a(eventLoop, (Object)"eventLoop");
            this.tag = c.c(string);
        }

        public int id() {
            return this.id;
        }

        public void setId(int n2) {
            b.a(n2 > 0, "id must be positive %s", n2);
            b.b(this.id == 0, "id has been previously set: %s", this.id);
            this.id = n2;
            this.tag = c.a(this.methodName, n2);
        }

        void setNonExistent() {
            b.b(this.id == 0, "Id has been previously set: %s", this.id);
            this.id = -1;
        }

        boolean isNonExistent() {
            return this.id == -1;
        }

        public void setHttp2Stream(Http2Stream http2Stream) {
            b.a(http2Stream, (Object)"http2Stream");
            b.b(this.http2Stream == null, "Can only set http2Stream once");
            this.http2Stream = http2Stream;
            this.onStreamAllocated();
            this.getTransportTracer().reportLocalStreamStarted();
        }

        public Http2Stream http2Stream() {
            return this.http2Stream;
        }

        protected abstract Status statusFromFailedFuture(ChannelFuture var1);

        protected void http2ProcessingFailed(Status status, boolean bl, Metadata metadata) {
            this.transportReportStatus(status, bl, metadata);
            this.handler.getWriteQueue().enqueue(new CancelClientStreamCommand(this, status), true);
        }

        public void runOnTransportThread(Runnable runnable) {
            if (this.eventLoop.inEventLoop()) {
                runnable.run();
                return;
            }
            this.eventLoop.execute(runnable);
        }

        public void bytesRead(int n2) {
            this.handler.returnProcessedBytes(this.http2Stream, n2);
            this.handler.getWriteQueue().scheduleFlush();
        }

        public void deframeFailed(Throwable throwable) {
            this.http2ProcessingFailed(Status.fromThrowable(throwable), true, new Metadata());
        }

        void transportHeadersReceived(Http2Headers http2Headers, boolean bl) {
            if (bl) {
                if (!this.isOutboundClosed()) {
                    this.handler.getWriteQueue().enqueue(new CancelClientStreamCommand(this, null), true);
                }
                this.transportTrailersReceived(Utils.convertTrailers(http2Headers));
                return;
            }
            this.transportHeadersReceived(Utils.convertHeaders(http2Headers));
        }

        void transportDataReceived(ByteBuf byteBuf, boolean bl) {
            this.transportDataReceived(new NettyReadableBuffer(byteBuf.retain()), bl);
        }

        public final d tag() {
            return this.tag;
        }
    }

    private class Sink
    implements AbstractClientStream.Sink {
        private Sink() {
        }

        public void writeHeaders(Metadata metadata, byte[] byArray) {
            c.a("NettyClientStream$Sink.writeHeaders");
            try {
                this.writeHeadersInternal(metadata, byArray);
                return;
            }
            finally {
                c.b("NettyClientStream$Sink.writeHeaders");
            }
        }

        private void writeHeadersInternal(Metadata object, byte[] object2) {
            boolean bl;
            AsciiString asciiString = (AsciiString)methodDescriptorAccessor.geRawMethodName(NettyClientStream.this.method);
            if (asciiString == null) {
                asciiString = new AsciiString("/" + NettyClientStream.this.method.getFullMethodName());
                methodDescriptorAccessor.setRawMethodName(NettyClientStream.this.method, asciiString);
            }
            if (bl = object2 != null) {
                asciiString = new AsciiString(asciiString + "?" + a.b().a((byte[])object2));
                object2 = Utils.HTTP_GET_METHOD;
            } else {
                object2 = Utils.HTTP_METHOD;
            }
            object = Utils.convertClientHeaders((Metadata)object, NettyClientStream.this.scheme, asciiString, NettyClientStream.this.authority, (AsciiString)object2, NettyClientStream.this.userAgent);
            object2 = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (!channelFuture.isSuccess()) {
                        Status status = NettyClientStream.this.transportState().handler.getLifecycleManager().getShutdownStatus();
                        if (status == null) {
                            status = NettyClientStream.this.transportState().statusFromFailedFuture(channelFuture);
                        }
                        NettyClientStream.this.transportState().transportReportStatus(status, true, new Metadata());
                    }
                }
            };
            NettyClientStream.this.writeQueue.enqueue(new CreateStreamCommand((Http2Headers)object, NettyClientStream.this.transportState(), NettyClientStream.this.shouldBeCountedForInUse(), bl), !NettyClientStream.this.method.getType().clientSendsOneMessage() || bl).addListener((GenericFutureListener<? extends Future<? super Void>>)object2);
        }

        private void writeFrameInternal(WritableBuffer object, boolean bl, boolean bl2, final int n2) {
            b.a(n2 >= 0);
            object = object == null ? Unpooled.EMPTY_BUFFER : ((NettyWritableBuffer)object).bytebuf().touch();
            final int n3 = ((ByteBuf)object).readableBytes();
            if (n3 > 0) {
                NettyClientStream.this.onSendingBytes(n3);
                NettyClientStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyClientStream.this.transportState(), (ByteBuf)object, bl), bl2).addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (channelFuture.isSuccess() && NettyClientStream.this.transportState().http2Stream() != null) {
                            NettyClientStream.this.transportState().onSentBytes(n3);
                            NettyClientStream.this.getTransportTracer().reportMessageSent(n2);
                        }
                    }
                });
                return;
            }
            NettyClientStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyClientStream.this.transportState(), (ByteBuf)object, bl), bl2);
        }

        public void writeFrame(WritableBuffer writableBuffer, boolean bl, boolean bl2, int n2) {
            c.a("NettyClientStream$Sink.writeFrame");
            try {
                this.writeFrameInternal(writableBuffer, bl, bl2, n2);
                return;
            }
            finally {
                c.b("NettyClientStream$Sink.writeFrame");
            }
        }

        public void cancel(Status status) {
            c.a("NettyClientStream$Sink.cancel");
            try {
                NettyClientStream.this.writeQueue.enqueue(new CancelClientStreamCommand(NettyClientStream.this.transportState(), status), true);
                return;
            }
            finally {
                c.b("NettyClientStream$Sink.cancel");
            }
        }
    }
}

