/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.HttpConnectProxiedSocketAddress;
import com.appoptics.ext.io.grpc.ManagedChannelBuilder;
import com.appoptics.ext.io.grpc.internal.AbstractManagedChannelImplBuilder;
import com.appoptics.ext.io.grpc.internal.AtomicBackoff;
import com.appoptics.ext.io.grpc.internal.ClientTransportFactory;
import com.appoptics.ext.io.grpc.internal.ConnectionClientTransport;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.ManagedChannelImplBuilder;
import com.appoptics.ext.io.grpc.internal.ObjectPool;
import com.appoptics.ext.io.grpc.internal.SharedResourcePool;
import com.appoptics.ext.io.grpc.internal.TransportTracer;
import com.appoptics.ext.io.grpc.netty.GrpcSslContexts;
import com.appoptics.ext.io.grpc.netty.NegotiationType;
import com.appoptics.ext.io.grpc.netty.NettyClientTransport;
import com.appoptics.ext.io.grpc.netty.ProtocolNegotiator;
import com.appoptics.ext.io.grpc.netty.ProtocolNegotiators;
import com.appoptics.ext.io.grpc.netty.Utils;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFactory;
import com.appoptics.ext.io.netty.channel.ChannelOption;
import com.appoptics.ext.io.netty.channel.EventLoopGroup;
import com.appoptics.ext.io.netty.channel.ReflectiveChannelFactory;
import com.appoptics.ext.io.netty.handler.ssl.SslContext;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NettyChannelBuilder
extends AbstractManagedChannelImplBuilder<NettyChannelBuilder> {
    private static final boolean DEFAULT_AUTO_FLOW_CONTROL;
    private static final long AS_LARGE_AS_INFINITE;
    private static final ChannelFactory<? extends Channel> DEFAULT_CHANNEL_FACTORY;
    private static final ObjectPool<? extends EventLoopGroup> DEFAULT_EVENT_LOOP_GROUP_POOL;
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private ChannelFactory<? extends Channel> channelFactory = DEFAULT_CHANNEL_FACTORY;
    private ObjectPool<? extends EventLoopGroup> eventLoopGroupPool = DEFAULT_EVENT_LOOP_GROUP_POOL;
    private boolean autoFlowControl = DEFAULT_AUTO_FLOW_CONTROL;
    private int flowControlWindow = 0x100000;
    private int maxInboundMessageSize = 0x400000;
    private int maxHeaderListSize = 8192;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private boolean keepAliveWithoutCalls;
    private ProtocolNegotiator.ClientFactory protocolNegotiatorFactory = new DefaultProtocolNegotiator();
    private final boolean freezeProtocolNegotiatorFactory;
    private LocalSocketPicker localSocketPicker;
    private final boolean useGetForSafeMethods = false;

    public static NettyChannelBuilder forAddress(String string, int n2) {
        return NettyChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(string, n2));
    }

    public static NettyChannelBuilder forTarget(String string) {
        return new NettyChannelBuilder(string);
    }

    NettyChannelBuilder(String string) {
        this.managedChannelImplBuilder = new ManagedChannelImplBuilder(string, new NettyChannelTransportFactoryBuilder(), new NettyChannelDefaultPortProvider());
        this.freezeProtocolNegotiatorFactory = false;
    }

    @Override
    protected final ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    public final NettyChannelBuilder sslContext(SslContext sslContext) {
        b.b(!this.freezeProtocolNegotiatorFactory, "Cannot change security when using ChannelCredentials");
        if (sslContext != null) {
            b.a(sslContext.isClient(), (Object)"Server SSL context can not be used for client channel");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        if (!(this.protocolNegotiatorFactory instanceof DefaultProtocolNegotiator)) {
            return this;
        }
        ((DefaultProtocolNegotiator)this.protocolNegotiatorFactory).sslContext = sslContext;
        return this;
    }

    final ClientTransportFactory buildTransportFactory() {
        this.assertEventLoopAndChannelType();
        ProtocolNegotiator protocolNegotiator = this.protocolNegotiatorFactory.newNegotiator();
        return new NettyTransportFactory(protocolNegotiator, this.channelFactory, this.channelOptions, this.eventLoopGroupPool, this.autoFlowControl, this.flowControlWindow, this.maxInboundMessageSize, this.maxHeaderListSize, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, this.transportTracerFactory, this.localSocketPicker, false);
    }

    final void assertEventLoopAndChannelType() {
        boolean bl = this.channelFactory != DEFAULT_CHANNEL_FACTORY && this.eventLoopGroupPool != DEFAULT_EVENT_LOOP_GROUP_POOL;
        boolean bl2 = this.channelFactory == DEFAULT_CHANNEL_FACTORY && this.eventLoopGroupPool == DEFAULT_EVENT_LOOP_GROUP_POOL;
        b.b(bl || bl2, "Both EventLoopGroup and ChannelType should be provided or neither should be");
    }

    static ProtocolNegotiator createProtocolNegotiatorByType(NegotiationType negotiationType, SslContext sslContext, ObjectPool<? extends Executor> objectPool) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return ProtocolNegotiators.plaintext();
            }
            case PLAINTEXT_UPGRADE: {
                return ProtocolNegotiators.plaintextUpgrade();
            }
            case TLS: {
                return ProtocolNegotiators.tls(sslContext, objectPool);
            }
        }
        throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)negotiationType));
    }

    static {
        AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
        DEFAULT_CHANNEL_FACTORY = new ReflectiveChannelFactory<Channel>(Utils.DEFAULT_CLIENT_CHANNEL_TYPE);
        DEFAULT_EVENT_LOOP_GROUP_POOL = SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
        String string = System.getenv("GRPC_EXPERIMENTAL_AUTOFLOWCONTROL");
        if (string == null) {
            string = "true";
        }
        DEFAULT_AUTO_FLOW_CONTROL = Boolean.parseBoolean(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NettyTransportFactory
    implements ClientTransportFactory {
        private final ProtocolNegotiator protocolNegotiator;
        private final ChannelFactory<? extends Channel> channelFactory;
        private final Map<ChannelOption<?>, ?> channelOptions;
        private final ObjectPool<? extends EventLoopGroup> groupPool;
        private final EventLoopGroup group;
        private final boolean autoFlowControl;
        private final int flowControlWindow;
        private final int maxMessageSize;
        private final int maxHeaderListSize;
        private final AtomicBackoff keepAliveTimeNanos;
        private final long keepAliveTimeoutNanos;
        private final boolean keepAliveWithoutCalls;
        private final TransportTracer.Factory transportTracerFactory;
        private final LocalSocketPicker localSocketPicker;
        private final boolean useGetForSafeMethods;
        private boolean closed;

        NettyTransportFactory(ProtocolNegotiator protocolNegotiator, ChannelFactory<? extends Channel> channelFactory, Map<ChannelOption<?>, ?> map, ObjectPool<? extends EventLoopGroup> objectPool, boolean bl, int n2, int n3, int n4, long l2, long l3, boolean bl2, TransportTracer.Factory factory, LocalSocketPicker localSocketPicker, boolean bl3) {
            this.protocolNegotiator = b.a(protocolNegotiator, (Object)"protocolNegotiator");
            this.channelFactory = channelFactory;
            this.channelOptions = new HashMap(map);
            this.groupPool = objectPool;
            this.group = objectPool.getObject();
            this.autoFlowControl = bl;
            this.flowControlWindow = n2;
            this.maxMessageSize = n3;
            this.maxHeaderListSize = n4;
            this.keepAliveTimeNanos = new AtomicBackoff("keepalive time nanos", l2);
            this.keepAliveTimeoutNanos = l3;
            this.keepAliveWithoutCalls = bl2;
            this.transportTracerFactory = factory;
            this.localSocketPicker = localSocketPicker != null ? localSocketPicker : new LocalSocketPicker();
            this.useGetForSafeMethods = bl3;
        }

        @Override
        public final ConnectionClientTransport newClientTransport(SocketAddress object, ClientTransportFactory.ClientTransportOptions clientTransportOptions, ChannelLogger channelLogger) {
            b.b(!this.closed, "The transport factory is closed.");
            ProtocolNegotiator protocolNegotiator = this.protocolNegotiator;
            Object object2 = clientTransportOptions.getHttpConnectProxiedSocketAddress();
            if (object2 != null) {
                object = ((HttpConnectProxiedSocketAddress)object2).getTargetAddress();
                protocolNegotiator = ProtocolNegotiators.httpProxy(((HttpConnectProxiedSocketAddress)object2).getProxyAddress(), ((HttpConnectProxiedSocketAddress)object2).getUsername(), ((HttpConnectProxiedSocketAddress)object2).getPassword(), this.protocolNegotiator);
            }
            object2 = this.keepAliveTimeNanos.getState();
            Runnable runnable = new Runnable((AtomicBackoff.State)object2){
                final /* synthetic */ AtomicBackoff.State val$keepAliveTimeNanosState;
                {
                    this.val$keepAliveTimeNanosState = state;
                }

                public void run() {
                    this.val$keepAliveTimeNanosState.backoff();
                }
            };
            object = new NettyClientTransport((SocketAddress)object, this.channelFactory, this.channelOptions, this.group, protocolNegotiator, this.autoFlowControl, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, ((AtomicBackoff.State)object2).get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, clientTransportOptions.getAuthority(), clientTransportOptions.getUserAgent(), runnable, this.transportTracerFactory.create(), clientTransportOptions.getEagAttributes(), this.localSocketPicker, channelLogger, this.useGetForSafeMethods);
            return object;
        }

        @Override
        public final ScheduledExecutorService getScheduledExecutorService() {
            return this.group;
        }

        @Override
        public final void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.protocolNegotiator.close();
            this.groupPool.returnObject(this.group);
        }
    }

    private final class DefaultProtocolNegotiator
    implements ProtocolNegotiator.ClientFactory {
        private NegotiationType negotiationType = NegotiationType.TLS;
        private SslContext sslContext;

        private DefaultProtocolNegotiator() {
        }

        public final ProtocolNegotiator newNegotiator() {
            SslContext sslContext = this.sslContext;
            if (this.negotiationType == NegotiationType.TLS && sslContext == null) {
                try {
                    sslContext = GrpcSslContexts.forClient().build();
                }
                catch (SSLException sSLException) {
                    throw new RuntimeException(sSLException);
                }
            }
            return NettyChannelBuilder.createProtocolNegotiatorByType(this.negotiationType, sslContext, NettyChannelBuilder.this.managedChannelImplBuilder.getOffloadExecutorPool());
        }

        public final int getDefaultPort() {
            switch (this.negotiationType) {
                case PLAINTEXT: 
                case PLAINTEXT_UPGRADE: {
                    return 80;
                }
                case TLS: {
                    return 443;
                }
            }
            throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
        }
    }

    public static class LocalSocketPicker {
        public SocketAddress createSocketAddress(SocketAddress socketAddress, Attributes attributes) {
            return null;
        }
    }

    private final class NettyChannelDefaultPortProvider
    implements ManagedChannelImplBuilder.ChannelBuilderDefaultPortProvider {
        private NettyChannelDefaultPortProvider() {
        }

        public final int getDefaultPort() {
            return NettyChannelBuilder.this.protocolNegotiatorFactory.getDefaultPort();
        }
    }

    private final class NettyChannelTransportFactoryBuilder
    implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
        private NettyChannelTransportFactoryBuilder() {
        }

        public final ClientTransportFactory buildClientTransportFactory() {
            return NettyChannelBuilder.this.buildTransportFactory();
        }
    }
}

