/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.internal.ConscryptLoader;
import com.appoptics.ext.io.grpc.netty.JettyTlsUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2SecurityUtil;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.appoptics.ext.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import com.appoptics.ext.io.netty.handler.ssl.OpenSsl;
import com.appoptics.ext.io.netty.handler.ssl.SslContextBuilder;
import com.appoptics.ext.io.netty.handler.ssl.SslProvider;
import com.appoptics.ext.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrpcSslContexts {
    private static final Logger logger = Logger.getLogger(GrpcSslContexts.class.getName());
    private static final List<String> NEXT_PROTOCOL_VERSIONS = Collections.unmodifiableList(Arrays.asList("h2"));
    private static final ApplicationProtocolConfig ALPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)NEXT_PROTOCOL_VERSIONS);
    private static final ApplicationProtocolConfig NPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)NEXT_PROTOCOL_VERSIONS);
    private static final ApplicationProtocolConfig NPN_AND_ALPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN_AND_ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)NEXT_PROTOCOL_VERSIONS);

    private GrpcSslContexts() {
    }

    public static SslContextBuilder forClient() {
        return GrpcSslContexts.configure(SslContextBuilder.forClient());
    }

    public static SslContextBuilder configure(SslContextBuilder sslContextBuilder) {
        return GrpcSslContexts.configure(sslContextBuilder, GrpcSslContexts.defaultSslProvider());
    }

    public static SslContextBuilder configure(SslContextBuilder sslContextBuilder, SslProvider object) {
        switch (object) {
            case JDK: {
                object = GrpcSslContexts.findJdkProvider();
                if (object == null) {
                    throw new IllegalArgumentException("Could not find Jetty NPN/ALPN or Conscrypt as installed JDK providers");
                }
                return GrpcSslContexts.configure(sslContextBuilder, (Provider)object);
            }
            case OPENSSL: {
                object = OpenSsl.isAlpnSupported() ? NPN_AND_ALPN : NPN;
                return sslContextBuilder.sslProvider(SslProvider.OPENSSL).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig((ApplicationProtocolConfig)object);
            }
        }
        throw new IllegalArgumentException("Unsupported provider: " + (Object)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SslContextBuilder configure(SslContextBuilder sslContextBuilder, Provider provider) {
        ApplicationProtocolConfig applicationProtocolConfig;
        if ("SunJSSE".equals(provider.getName())) {
            if (JettyTlsUtil.isJettyAlpnConfigured()) {
                applicationProtocolConfig = ALPN;
                return sslContextBuilder.sslProvider(SslProvider.JDK).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(applicationProtocolConfig).sslContextProvider(provider);
            } else if (JettyTlsUtil.isJettyNpnConfigured()) {
                applicationProtocolConfig = NPN;
                return sslContextBuilder.sslProvider(SslProvider.JDK).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(applicationProtocolConfig).sslContextProvider(provider);
            } else {
                if (!JettyTlsUtil.isJava9AlpnAvailable()) throw new IllegalArgumentException(provider.getName() + " selected, but Java 9+ and Jetty NPN/ALPN unavailable");
                applicationProtocolConfig = ALPN;
            }
            return sslContextBuilder.sslProvider(SslProvider.JDK).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(applicationProtocolConfig).sslContextProvider(provider);
        } else if ("IBMJSSE2".equals(provider.getName())) {
            if (!JettyTlsUtil.isJava9AlpnAvailable()) throw new IllegalArgumentException(provider.getName() + " selected, but Java 9+ ALPN unavailable");
            applicationProtocolConfig = ALPN;
            return sslContextBuilder.sslProvider(SslProvider.JDK).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(applicationProtocolConfig).sslContextProvider(provider);
        } else {
            if (!ConscryptLoader.isConscrypt(provider)) throw new IllegalArgumentException("Unknown provider; can't configure: " + provider);
            applicationProtocolConfig = ALPN;
        }
        return sslContextBuilder.sslProvider(SslProvider.JDK).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(applicationProtocolConfig).sslContextProvider(provider);
    }

    private static SslProvider defaultSslProvider() {
        if (OpenSsl.isAvailable()) {
            logger.log(Level.FINE, "Selecting OPENSSL");
            return SslProvider.OPENSSL;
        }
        Provider provider = GrpcSslContexts.findJdkProvider();
        if (provider != null) {
            logger.log(Level.FINE, "Selecting JDK with provider {0}", provider);
            return SslProvider.JDK;
        }
        logger.log(Level.INFO, "Java 9 ALPN API unavailable (this may be normal)");
        logger.log(Level.INFO, "netty-tcnative unavailable (this may be normal)", OpenSsl.unavailabilityCause());
        logger.log(Level.INFO, "Conscrypt not found (this may be normal)", ConscryptHolder.UNAVAILABILITY_CAUSE);
        logger.log(Level.INFO, "Jetty ALPN unavailable (this may be normal)", JettyTlsUtil.getJettyAlpnUnavailabilityCause());
        throw new IllegalStateException("Could not find TLS ALPN provider; no working netty-tcnative, Conscrypt, or Jetty NPN/ALPN available");
    }

    private static Provider findJdkProvider() {
        for (Provider provider : Security.getProviders("SSLContext.TLS")) {
            if (!("SunJSSE".equals(provider.getName()) ? JettyTlsUtil.isJettyAlpnConfigured() || JettyTlsUtil.isJettyNpnConfigured() || JettyTlsUtil.isJava9AlpnAvailable() : ("IBMJSSE2".equals(provider.getName()) ? JettyTlsUtil.isJava9AlpnAvailable() : ConscryptLoader.isConscrypt(provider)))) continue;
            return provider;
        }
        if (ConscryptHolder.PROVIDER != null) {
            return ConscryptHolder.PROVIDER;
        }
        return null;
    }

    static void ensureAlpnAndH2Enabled(ApplicationProtocolNegotiator applicationProtocolNegotiator) {
        b.a(applicationProtocolNegotiator != null, (Object)"ALPN must be configured");
        b.a(applicationProtocolNegotiator.protocols() != null && !applicationProtocolNegotiator.protocols().isEmpty(), (Object)"ALPN must be enabled and list HTTP/2 as a supported protocol.");
        b.a(applicationProtocolNegotiator.protocols().contains("h2"), "This ALPN config does not support HTTP/2. Expected %s, but got %s'.", "h2", applicationProtocolNegotiator.protocols());
    }

    private static class ConscryptHolder {
        static final Provider PROVIDER;
        static final Throwable UNAVAILABILITY_CAUSE;

        static {
            Throwable throwable;
            Provider provider;
            try {
                provider = ConscryptLoader.newProvider();
                throwable = null;
            }
            catch (Throwable throwable2) {
                provider = null;
                throwable = throwable2;
            }
            PROVIDER = provider;
            UNAVAILABILITY_CAUSE = throwable;
        }
    }
}

