/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.grpc.netty.AbstractHttp2Headers;
import com.appoptics.ext.io.grpc.netty.Utils;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GrpcHttp2OutboundHeaders
extends AbstractHttp2Headers {
    private final AsciiString[] normalHeaders;
    private final AsciiString[] preHeaders;
    private static final AsciiString[] EMPTY = new AsciiString[0];

    static GrpcHttp2OutboundHeaders clientRequestHeaders(byte[][] byArray, AsciiString asciiStringArray, AsciiString asciiString, AsciiString asciiString2, AsciiString asciiString3, AsciiString asciiString4) {
        asciiStringArray = new AsciiString[]{Http2Headers.PseudoHeaderName.AUTHORITY.value(), asciiStringArray, Http2Headers.PseudoHeaderName.PATH.value(), asciiString, Http2Headers.PseudoHeaderName.METHOD.value(), asciiString2, Http2Headers.PseudoHeaderName.SCHEME.value(), asciiString3, Utils.CONTENT_TYPE_HEADER, Utils.CONTENT_TYPE_GRPC, Utils.TE_HEADER, Utils.TE_TRAILERS, Utils.USER_AGENT, asciiString4};
        return new GrpcHttp2OutboundHeaders(asciiStringArray, byArray);
    }

    private GrpcHttp2OutboundHeaders(AsciiString[] asciiStringArray, byte[][] byArray) {
        this.normalHeaders = new AsciiString[byArray.length];
        for (int i2 = 0; i2 < this.normalHeaders.length; ++i2) {
            this.normalHeaders[i2] = new AsciiString(byArray[i2], false);
        }
        this.preHeaders = asciiStringArray;
    }

    @Override
    public final CharSequence status() {
        if (this.preHeaders.length >= 2 && this.preHeaders[0] == Http2Headers.PseudoHeaderName.STATUS.value()) {
            return this.preHeaders[1];
        }
        return null;
    }

    @Override
    public final Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new Itr();
    }

    @Override
    public final int size() {
        return (this.normalHeaders.length + this.preHeaders.length) / 2;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String string = "";
        for (Object object : this) {
            CharSequence charSequence = object.getKey();
            object = object.getValue();
            stringBuilder.append(string);
            stringBuilder.append(charSequence).append(": ").append((CharSequence)object);
            string = ", ";
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<Map.Entry<CharSequence, CharSequence>>,
    Map.Entry<CharSequence, CharSequence> {
        private int idx;
        private AsciiString[] current;
        private AsciiString key;
        private AsciiString value;

        private Itr() {
            this.current = GrpcHttp2OutboundHeaders.this.preHeaders.length != 0 ? GrpcHttp2OutboundHeaders.this.preHeaders : GrpcHttp2OutboundHeaders.this.normalHeaders;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.current.length;
        }

        @Override
        public Map.Entry<CharSequence, CharSequence> next() {
            if (this.hasNext()) {
                this.key = this.current[this.idx];
                this.value = this.current[this.idx + 1];
                this.idx += 2;
                if (this.idx >= this.current.length && this.current == GrpcHttp2OutboundHeaders.this.preHeaders) {
                    this.current = GrpcHttp2OutboundHeaders.this.normalHeaders;
                    this.idx = 0;
                }
                return this;
            }
            throw new NoSuchElementException();
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence charSequence) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

