/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.Codec;
import com.appoptics.ext.io.grpc.Compressor;
import com.appoptics.ext.io.grpc.Drainable;
import com.appoptics.ext.io.grpc.KnownLength;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.Framer;
import com.appoptics.ext.io.grpc.internal.StatsTraceContext;
import com.appoptics.ext.io.grpc.internal.WritableBuffer;
import com.appoptics.ext.io.grpc.internal.WritableBufferAllocator;
import com.tracelytics.a.d.a.d.b;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MessageFramer
implements Framer {
    private final Sink sink;
    private int maxOutboundMessageSize = -1;
    private WritableBuffer buffer;
    private Compressor compressor = Codec.Identity.NONE;
    private boolean messageCompression = true;
    private final OutputStreamAdapter outputStreamAdapter = new OutputStreamAdapter();
    private final byte[] headerScratch = new byte[5];
    private final WritableBufferAllocator bufferAllocator;
    private final StatsTraceContext statsTraceCtx;
    private boolean closed;
    private int messagesBuffered;
    private int currentMessageSeqNo = -1;
    private long currentMessageWireSize;

    public MessageFramer(Sink sink, WritableBufferAllocator writableBufferAllocator, StatsTraceContext statsTraceContext) {
        this.sink = com.appoptics.ext.io.a.b.a(sink, (Object)"sink");
        this.bufferAllocator = com.appoptics.ext.io.a.b.a(writableBufferAllocator, (Object)"bufferAllocator");
        this.statsTraceCtx = com.appoptics.ext.io.a.b.a(statsTraceContext, (Object)"statsTraceCtx");
    }

    public MessageFramer setCompressor(Compressor compressor) {
        this.compressor = com.appoptics.ext.io.a.b.a(compressor, (Object)"Can't pass an empty compressor");
        return this;
    }

    public void setMaxOutboundMessageSize(int n2) {
        com.appoptics.ext.io.a.b.b(this.maxOutboundMessageSize == -1, "max size already set");
        this.maxOutboundMessageSize = n2;
    }

    public void writePayload(InputStream inputStream) {
        int n2;
        int n3;
        this.verifyNotClosed();
        ++this.messagesBuffered;
        ++this.currentMessageSeqNo;
        this.currentMessageWireSize = 0L;
        this.statsTraceCtx.outboundMessage(this.currentMessageSeqNo);
        boolean bl = this.messageCompression && this.compressor != Codec.Identity.NONE;
        try {
            n3 = this.getKnownLength(inputStream);
            n2 = n3 != 0 && bl ? this.writeCompressed(inputStream, n3) : this.writeUncompressed(inputStream, n3);
        }
        catch (IOException iOException) {
            throw Status.INTERNAL.withDescription("Failed to frame message").withCause(iOException).asRuntimeException();
        }
        catch (RuntimeException runtimeException) {
            throw Status.INTERNAL.withDescription("Failed to frame message").withCause(runtimeException).asRuntimeException();
        }
        if (n3 != -1 && n2 != n3) {
            String string = String.format("Message length inaccurate %s != %s", n2, n3);
            throw Status.INTERNAL.withDescription(string).asRuntimeException();
        }
        this.statsTraceCtx.outboundUncompressedSize(n2);
        this.statsTraceCtx.outboundWireSize(this.currentMessageWireSize);
        this.statsTraceCtx.outboundMessageSent(this.currentMessageSeqNo, this.currentMessageWireSize, n2);
    }

    private int writeUncompressed(InputStream inputStream, int n2) throws IOException {
        if (n2 != -1) {
            this.currentMessageWireSize = n2;
            return this.writeKnownLengthUncompressed(inputStream, n2);
        }
        BufferChainOutputStream bufferChainOutputStream = new BufferChainOutputStream();
        int n3 = MessageFramer.writeToOutputStream(inputStream, bufferChainOutputStream);
        if (this.maxOutboundMessageSize >= 0 && n3 > this.maxOutboundMessageSize) {
            throw Status.RESOURCE_EXHAUSTED.withDescription(String.format("message too large %d > %d", n3, this.maxOutboundMessageSize)).asRuntimeException();
        }
        this.writeBufferChain(bufferChainOutputStream, false);
        return n3;
    }

    private int writeCompressed(InputStream inputStream, int n2) throws IOException {
        int n3;
        BufferChainOutputStream bufferChainOutputStream = new BufferChainOutputStream();
        OutputStream outputStream = this.compressor.compress(bufferChainOutputStream);
        try {
            n3 = MessageFramer.writeToOutputStream(inputStream, outputStream);
        }
        finally {
            outputStream.close();
        }
        if (this.maxOutboundMessageSize >= 0 && n3 > this.maxOutboundMessageSize) {
            throw Status.RESOURCE_EXHAUSTED.withDescription(String.format("message too large %d > %d", n3, this.maxOutboundMessageSize)).asRuntimeException();
        }
        this.writeBufferChain(bufferChainOutputStream, true);
        return n3;
    }

    private int getKnownLength(InputStream inputStream) throws IOException {
        if (inputStream instanceof KnownLength || inputStream instanceof ByteArrayInputStream) {
            return inputStream.available();
        }
        return -1;
    }

    private int writeKnownLengthUncompressed(InputStream inputStream, int n2) throws IOException {
        if (this.maxOutboundMessageSize >= 0 && n2 > this.maxOutboundMessageSize) {
            throw Status.RESOURCE_EXHAUSTED.withDescription(String.format("message too large %d > %d", n2, this.maxOutboundMessageSize)).asRuntimeException();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.headerScratch);
        byteBuffer.put((byte)0);
        byteBuffer.putInt(n2);
        if (this.buffer == null) {
            this.buffer = this.bufferAllocator.allocate(byteBuffer.position() + n2);
        }
        MessageFramer messageFramer = this;
        messageFramer.writeRaw(messageFramer.headerScratch, 0, byteBuffer.position());
        return MessageFramer.writeToOutputStream(inputStream, this.outputStreamAdapter);
    }

    private void writeBufferChain(BufferChainOutputStream object, boolean bl) {
        ByteBuffer i2 = ByteBuffer.wrap(this.headerScratch);
        i2.put(bl ? (byte)1 : 0);
        int n2 = ((BufferChainOutputStream)object).readableBytes();
        i2.putInt(n2);
        WritableBuffer writableBuffer = this.bufferAllocator.allocate(5);
        writableBuffer.write(this.headerScratch, 0, i2.position());
        if (n2 == 0) {
            this.buffer = writableBuffer;
            return;
        }
        this.sink.deliverFrame(writableBuffer, false, false, this.messagesBuffered - 1);
        this.messagesBuffered = 1;
        object = ((BufferChainOutputStream)object).bufferList;
        for (int i3 = 0; i3 < object.size() - 1; ++i3) {
            this.sink.deliverFrame((WritableBuffer)object.get(i3), false, false, 0);
        }
        Object object2 = object;
        this.buffer = (WritableBuffer)object2.get(object2.size() - 1);
        this.currentMessageWireSize = n2;
    }

    private static int writeToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream instanceof Drainable) {
            return ((Drainable)((Object)inputStream)).drainTo(outputStream);
        }
        long l2 = b.a(inputStream, outputStream);
        com.appoptics.ext.io.a.b.a(l2 <= Integer.MAX_VALUE, "Message size overflow: %s", l2);
        return (int)l2;
    }

    private void writeRaw(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            if (this.buffer != null && this.buffer.writableBytes() == 0) {
                this.commitToSink(false, false);
            }
            if (this.buffer == null) {
                this.buffer = this.bufferAllocator.allocate(n3);
            }
            int n4 = Math.min(n3, this.buffer.writableBytes());
            this.buffer.write(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void flush() {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.commitToSink(false, true);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (!this.isClosed()) {
            this.closed = true;
            if (this.buffer != null && this.buffer.readableBytes() == 0) {
                this.releaseBuffer();
            }
            this.commitToSink(true, true);
        }
    }

    private void releaseBuffer() {
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    private void commitToSink(boolean bl, boolean bl2) {
        WritableBuffer writableBuffer = this.buffer;
        this.buffer = null;
        this.sink.deliverFrame(writableBuffer, bl, bl2, this.messagesBuffered);
        this.messagesBuffered = 0;
    }

    private void verifyNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Framer already closed");
        }
    }

    private final class BufferChainOutputStream
    extends OutputStream {
        private final List<WritableBuffer> bufferList = new ArrayList<WritableBuffer>();
        private WritableBuffer current;

        private BufferChainOutputStream() {
        }

        public final void write(int n2) throws IOException {
            if (this.current != null && this.current.writableBytes() > 0) {
                this.current.write((byte)n2);
                return;
            }
            byte[] byArray = new byte[]{(byte)n2};
            this.write(byArray, 0, 1);
        }

        public final void write(byte[] byArray, int n2, int n3) {
            if (this.current == null) {
                this.current = MessageFramer.this.bufferAllocator.allocate(n3);
                this.bufferList.add(this.current);
            }
            while (n3 > 0) {
                int n4 = Math.min(n3, this.current.writableBytes());
                if (n4 == 0) {
                    n4 = Math.max(n3, this.current.readableBytes() << 1);
                    this.current = MessageFramer.this.bufferAllocator.allocate(n4);
                    this.bufferList.add(this.current);
                    continue;
                }
                this.current.write(byArray, n2, n4);
                n2 += n4;
                n3 -= n4;
            }
        }

        private int readableBytes() {
            int n2 = 0;
            for (WritableBuffer writableBuffer : this.bufferList) {
                n2 += writableBuffer.readableBytes();
            }
            return n2;
        }
    }

    private class OutputStreamAdapter
    extends OutputStream {
        private OutputStreamAdapter() {
        }

        public void write(int n2) {
            byte[] byArray = new byte[]{(byte)n2};
            this.write(byArray, 0, 1);
        }

        public void write(byte[] byArray, int n2, int n3) {
            MessageFramer.this.writeRaw(byArray, n2, n3);
        }
    }

    public static interface Sink {
        public void deliverFrame(WritableBuffer var1, boolean var2, boolean var3, int var4);
    }
}

