/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.ManagedChannel;
import com.appoptics.ext.io.grpc.internal.ForwardingManagedChannel;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ManagedChannelOrphanWrapper
extends ForwardingManagedChannel {
    private static final ReferenceQueue<ManagedChannelOrphanWrapper> refqueue = new ReferenceQueue();
    private static final ConcurrentMap<ManagedChannelReference, ManagedChannelReference> refs = new ConcurrentHashMap<ManagedChannelReference, ManagedChannelReference>();
    private static final Logger logger = Logger.getLogger(ManagedChannelOrphanWrapper.class.getName());
    private final ManagedChannelReference phantom;

    ManagedChannelOrphanWrapper(ManagedChannel managedChannel) {
        this(managedChannel, refqueue, refs);
    }

    ManagedChannelOrphanWrapper(ManagedChannel managedChannel, ReferenceQueue<ManagedChannelOrphanWrapper> referenceQueue, ConcurrentMap<ManagedChannelReference, ManagedChannelReference> concurrentMap) {
        super(managedChannel);
        this.phantom = new ManagedChannelReference(this, managedChannel, referenceQueue, concurrentMap);
    }

    @Override
    public final ManagedChannel shutdown() {
        this.phantom.clearSafely();
        return super.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ManagedChannelReference
    extends WeakReference<ManagedChannelOrphanWrapper> {
        private static final boolean ENABLE_ALLOCATION_TRACKING = Boolean.parseBoolean(System.getProperty("com.appoptics.ext.io.grpc.ManagedChannel.enableAllocationTracking", "true"));
        private static final RuntimeException missingCallSite = ManagedChannelReference.missingCallSite();
        private final ReferenceQueue<ManagedChannelOrphanWrapper> refqueue;
        private final ConcurrentMap<ManagedChannelReference, ManagedChannelReference> refs;
        private final String channelStr;
        private final Reference<RuntimeException> allocationSite;
        private final AtomicBoolean shutdown = new AtomicBoolean();

        ManagedChannelReference(ManagedChannelOrphanWrapper managedChannelOrphanWrapper, ManagedChannel managedChannel, ReferenceQueue<ManagedChannelOrphanWrapper> referenceQueue, ConcurrentMap<ManagedChannelReference, ManagedChannelReference> concurrentMap) {
            super(managedChannelOrphanWrapper, referenceQueue);
            this.allocationSite = new SoftReference<RuntimeException>(ENABLE_ALLOCATION_TRACKING ? new RuntimeException("ManagedChannel allocation site") : missingCallSite);
            this.channelStr = managedChannel.toString();
            this.refqueue = referenceQueue;
            this.refs = concurrentMap;
            ManagedChannelReference managedChannelReference = this;
            this.refs.put(managedChannelReference, managedChannelReference);
            ManagedChannelReference.cleanQueue(referenceQueue);
        }

        @Override
        public final void clear() {
            this.clearInternal();
            ManagedChannelReference.cleanQueue(this.refqueue);
        }

        private void clearSafely() {
            if (!this.shutdown.getAndSet(true)) {
                this.clear();
            }
        }

        private void clearInternal() {
            super.clear();
            this.refs.remove(this);
            this.allocationSite.clear();
        }

        private static RuntimeException missingCallSite() {
            RuntimeException runtimeException = new RuntimeException("ManagedChannel allocation site not recorded.  Set -Dio.grpc.ManagedChannel.enableAllocationTracking=true to enable it");
            runtimeException.setStackTrace(new StackTraceElement[0]);
            return runtimeException;
        }

        static int cleanQueue(ReferenceQueue<ManagedChannelOrphanWrapper> referenceQueue) {
            ManagedChannelReference managedChannelReference;
            int n2 = 0;
            while ((managedChannelReference = (ManagedChannelReference)referenceQueue.poll()) != null) {
                RuntimeException runtimeException = managedChannelReference.allocationSite.get();
                managedChannelReference.clearInternal();
                if (managedChannelReference.shutdown.get()) continue;
                ++n2;
                Serializable serializable = Level.SEVERE;
                if (!logger.isLoggable((Level)serializable)) continue;
                String string = "*~*~*~ Channel {0} was not shutdown properly!!! ~*~*~*" + System.getProperty("line.separator") + "    Make sure to call shutdown()/shutdownNow() and wait until awaitTermination() returns true.";
                serializable = new LogRecord((Level)serializable, string);
                ((LogRecord)serializable).setLoggerName(logger.getName());
                ((LogRecord)serializable).setParameters(new Object[]{managedChannelReference.channelStr});
                ((LogRecord)serializable).setThrown(runtimeException);
                logger.log((LogRecord)serializable);
            }
            return n2;
        }
    }
}

