/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.internal.ClientTransport;
import com.tracelytics.a.d.a.a.l;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Http2Ping {
    private static final Logger log = Logger.getLogger(Http2Ping.class.getName());
    private final long data;
    private final l stopwatch;
    private Map<ClientTransport.PingCallback, Executor> callbacks = new LinkedHashMap<ClientTransport.PingCallback, Executor>();
    private boolean completed;
    private Throwable failureCause;
    private long roundTripTimeNanos;

    public Http2Ping(long l2, l l3) {
        this.data = l2;
        this.stopwatch = l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(ClientTransport.PingCallback object, Executor executor) {
        Http2Ping http2Ping = this;
        synchronized (http2Ping) {
            if (!this.completed) {
                this.callbacks.put((ClientTransport.PingCallback)object, executor);
                return;
            }
            object = this.failureCause != null ? Http2Ping.asRunnable((ClientTransport.PingCallback)object, this.failureCause) : Http2Ping.asRunnable((ClientTransport.PingCallback)object, this.roundTripTimeNanos);
        }
        Http2Ping.doExecute(executor, (Runnable)object);
    }

    public long payload() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete() {
        Map<ClientTransport.PingCallback, Executor> object;
        long l2;
        Http2Ping http2Ping = this;
        synchronized (http2Ping) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            l2 = this.roundTripTimeNanos = this.stopwatch.a(TimeUnit.NANOSECONDS);
            object = this.callbacks;
            this.callbacks = null;
        }
        for (Map.Entry entry : object.entrySet()) {
            Http2Ping.doExecute((Executor)entry.getValue(), Http2Ping.asRunnable((ClientTransport.PingCallback)entry.getKey(), l2));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable throwable) {
        Map<ClientTransport.PingCallback, Executor> object;
        Http2Ping http2Ping = this;
        synchronized (http2Ping) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.failureCause = throwable;
            object = this.callbacks;
            this.callbacks = null;
        }
        for (Map.Entry entry : object.entrySet()) {
            Http2Ping.notifyFailed((ClientTransport.PingCallback)entry.getKey(), (Executor)entry.getValue(), throwable);
        }
    }

    public static void notifyFailed(ClientTransport.PingCallback pingCallback, Executor executor, Throwable throwable) {
        Http2Ping.doExecute(executor, Http2Ping.asRunnable(pingCallback, throwable));
    }

    private static void doExecute(Executor executor, Runnable runnable) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, "Failed to execute PingCallback", throwable);
            return;
        }
    }

    private static Runnable asRunnable(final ClientTransport.PingCallback pingCallback, final long l2) {
        return new Runnable(){

            public void run() {
                pingCallback.onSuccess(l2);
            }
        };
    }

    private static Runnable asRunnable(final ClientTransport.PingCallback pingCallback, final Throwable throwable) {
        return new Runnable(){

            public void run() {
                pingCallback.onFailure(throwable);
            }
        };
    }
}

