/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.Compressor;
import com.appoptics.ext.io.grpc.Deadline;
import com.appoptics.ext.io.grpc.DecompressorRegistry;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientStreamListener;
import com.appoptics.ext.io.grpc.internal.InsightBuilder;
import com.appoptics.ext.io.grpc.internal.NoopClientStream;
import com.appoptics.ext.io.grpc.internal.StreamListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class DelayedStream
implements ClientStream {
    private volatile boolean passThrough;
    private ClientStreamListener listener;
    private ClientStream realStream;
    private Status error;
    private List<Runnable> pendingCalls = new ArrayList<Runnable>();
    private DelayedStreamListener delayedListener;
    private long startTimeNanos;
    private long streamSetTimeNanos;

    DelayedStream() {
    }

    public void setMaxInboundMessageSize(final int n2) {
        if (this.passThrough) {
            this.realStream.setMaxInboundMessageSize(n2);
            return;
        }
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.setMaxInboundMessageSize(n2);
            }
        });
    }

    public void setMaxOutboundMessageSize(final int n2) {
        if (this.passThrough) {
            this.realStream.setMaxOutboundMessageSize(n2);
            return;
        }
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.setMaxOutboundMessageSize(n2);
            }
        });
    }

    public void setDeadline(final Deadline deadline) {
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.setDeadline(deadline);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendTimeoutInsight(InsightBuilder insightBuilder) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.listener == null) {
                return;
            }
            if (this.realStream != null) {
                insightBuilder.appendKeyValue("buffered_nanos", this.streamSetTimeNanos - this.startTimeNanos);
                this.realStream.appendTimeoutInsight(insightBuilder);
            } else {
                insightBuilder.appendKeyValue("buffered_nanos", System.nanoTime() - this.startTimeNanos);
                insightBuilder.append("waiting_for_connection");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setStream(ClientStream clientStream) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.realStream != null) {
                return;
            }
            this.setRealStream(b.a(clientStream, (Object)"stream"));
        }
        this.drainPendingCalls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainPendingCalls() {
        assert (this.realStream != null);
        assert (!this.passThrough);
        Object object = new ArrayList<Runnable>();
        while (true) {
            Object object2;
            Object object3 = this;
            synchronized (object3) {
                if (this.pendingCalls.isEmpty()) {
                    this.pendingCalls = null;
                    this.passThrough = true;
                    object = this.delayedListener;
                    break;
                }
                object2 = object;
                object = this.pendingCalls;
                this.pendingCalls = object2;
            }
            object3 = object.iterator();
            while (object3.hasNext()) {
                object2 = (Runnable)object3.next();
                object2.run();
            }
            object.clear();
        }
        if (object != null) {
            ((DelayedStreamListener)object).drainPendingCallbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOrExecute(Runnable runnable) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (!this.passThrough) {
                this.pendingCalls.add(runnable);
                return;
            }
        }
        runnable.run();
    }

    public void setAuthority(final String string) {
        b.b(this.listener == null, "May only be called before start");
        b.a(string, (Object)"authority");
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.setAuthority(string);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClientStreamListener clientStreamListener) {
        boolean bl;
        Status status;
        b.b(this.listener == null, "already started");
        Object object = this;
        synchronized (object) {
            this.listener = b.a(clientStreamListener, (Object)"listener");
            status = this.error;
            bl = this.passThrough;
            if (!bl) {
                this.delayedListener = new DelayedStreamListener(clientStreamListener);
                clientStreamListener = this.delayedListener;
            }
            this.startTimeNanos = System.nanoTime();
        }
        if (status != null) {
            clientStreamListener.closed(status, new Metadata());
            return;
        }
        if (bl) {
            this.realStream.start(clientStreamListener);
            return;
        }
        object = clientStreamListener;
        this.delayOrExecute(new Runnable((ClientStreamListener)object){
            final /* synthetic */ ClientStreamListener val$finalListener;
            {
                this.val$finalListener = clientStreamListener;
            }

            public void run() {
                DelayedStream.this.realStream.start(this.val$finalListener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes getAttributes() {
        ClientStream clientStream;
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            clientStream = this.realStream;
        }
        if (clientStream != null) {
            return clientStream.getAttributes();
        }
        return Attributes.EMPTY;
    }

    public void writeMessage(final InputStream inputStream) {
        b.a(inputStream, (Object)"message");
        if (this.passThrough) {
            this.realStream.writeMessage(inputStream);
            return;
        }
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.writeMessage(inputStream);
            }
        });
    }

    public void flush() {
        if (this.passThrough) {
            this.realStream.flush();
            return;
        }
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.flush();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(final Status status) {
        b.a(status, (Object)"reason");
        boolean bl = true;
        ClientStreamListener clientStreamListener = null;
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.realStream == null) {
                this.setRealStream(NoopClientStream.INSTANCE);
                bl = false;
                clientStreamListener = this.listener;
                this.error = status;
            }
        }
        if (bl) {
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedStream.this.realStream.cancel(status);
                }
            });
            return;
        }
        if (clientStreamListener != null) {
            clientStreamListener.closed(status, new Metadata());
        }
        this.drainPendingCalls();
    }

    private void setRealStream(ClientStream clientStream) {
        b.b(this.realStream == null, "realStream already set to %s", this.realStream);
        this.realStream = clientStream;
        this.streamSetTimeNanos = System.nanoTime();
    }

    public void halfClose() {
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.halfClose();
            }
        });
    }

    public void request(final int n2) {
        if (this.passThrough) {
            this.realStream.request(n2);
            return;
        }
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.request(n2);
            }
        });
    }

    public void optimizeForDirectExecutor() {
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.optimizeForDirectExecutor();
            }
        });
    }

    public void setCompressor(final Compressor compressor) {
        b.a(compressor, (Object)"compressor");
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.setCompressor(compressor);
            }
        });
    }

    public void setFullStreamDecompression(final boolean bl) {
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.setFullStreamDecompression(bl);
            }
        });
    }

    public void setDecompressorRegistry(final DecompressorRegistry decompressorRegistry) {
        b.a(decompressorRegistry, (Object)"decompressorRegistry");
        this.delayOrExecute(new Runnable(){

            public void run() {
                DelayedStream.this.realStream.setDecompressorRegistry(decompressorRegistry);
            }
        });
    }

    private static class DelayedStreamListener
    implements ClientStreamListener {
        private final ClientStreamListener realListener;
        private volatile boolean passThrough;
        private List<Runnable> pendingCallbacks = new ArrayList<Runnable>();

        public DelayedStreamListener(ClientStreamListener clientStreamListener) {
            this.realListener = clientStreamListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delayOrExecute(Runnable runnable) {
            DelayedStreamListener delayedStreamListener = this;
            synchronized (delayedStreamListener) {
                if (!this.passThrough) {
                    this.pendingCallbacks.add(runnable);
                    return;
                }
            }
            runnable.run();
        }

        public void messagesAvailable(final StreamListener.MessageProducer messageProducer) {
            if (this.passThrough) {
                this.realListener.messagesAvailable(messageProducer);
                return;
            }
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedStreamListener.this.realListener.messagesAvailable(messageProducer);
                }
            });
        }

        public void onReady() {
            if (this.passThrough) {
                this.realListener.onReady();
                return;
            }
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedStreamListener.this.realListener.onReady();
                }
            });
        }

        public void headersRead(final Metadata metadata) {
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedStreamListener.this.realListener.headersRead(metadata);
                }
            });
        }

        public void closed(final Status status, final Metadata metadata) {
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedStreamListener.this.realListener.closed(status, metadata);
                }
            });
        }

        public void closed(final Status status, final ClientStreamListener.RpcProgress rpcProgress, final Metadata metadata) {
            this.delayOrExecute(new Runnable(){

                public void run() {
                    DelayedStreamListener.this.realListener.closed(status, rpcProgress, metadata);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drainPendingCallbacks() {
            assert (!this.passThrough);
            List<Runnable> list = new ArrayList<Runnable>();
            while (true) {
                DelayedStreamListener delayedStreamListener = this;
                synchronized (delayedStreamListener) {
                    if (this.pendingCallbacks.isEmpty()) {
                        this.pendingCallbacks = null;
                        this.passThrough = true;
                        return;
                    }
                    ArrayList<Runnable> arrayList = list;
                    list = this.pendingCallbacks;
                    this.pendingCallbacks = arrayList;
                }
                for (Runnable runnable : list) {
                    runnable.run();
                }
                list.clear();
            }
        }
    }
}

