/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.Context;
import com.appoptics.ext.io.grpc.InternalLogId;
import com.appoptics.ext.io.grpc.LoadBalancer;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.SynchronizationContext;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientTransport;
import com.appoptics.ext.io.grpc.internal.DelayedStream;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.ManagedClientTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DelayedClientTransport
implements ManagedClientTransport {
    private final InternalLogId logId = InternalLogId.allocate(DelayedClientTransport.class, null);
    private final Object lock = new Object();
    private final Executor defaultAppExecutor;
    private final SynchronizationContext syncContext;
    private Runnable reportTransportInUse;
    private Runnable reportTransportNotInUse;
    private Runnable reportTransportTerminated;
    private ManagedClientTransport.Listener listener;
    private Collection<PendingStream> pendingStreams = new LinkedHashSet<PendingStream>();
    private Status shutdownStatus;
    private LoadBalancer.SubchannelPicker lastPicker;
    private long lastPickerVersion;

    DelayedClientTransport(Executor executor, SynchronizationContext synchronizationContext) {
        this.defaultAppExecutor = executor;
        this.syncContext = synchronizationContext;
    }

    @Override
    public final Runnable start(final ManagedClientTransport.Listener listener) {
        this.listener = listener;
        this.reportTransportInUse = new Runnable(){

            public void run() {
                listener.transportInUse(true);
            }
        };
        this.reportTransportNotInUse = new Runnable(){

            public void run() {
                listener.transportInUse(false);
            }
        };
        this.reportTransportTerminated = new Runnable(){

            public void run() {
                listener.transportTerminated();
            }
        };
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final ClientStream newStream(MethodDescriptor<?, ?> var1_1, Metadata var2_4, CallOptions var3_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PendingStream createPendingStream(LoadBalancer.PickSubchannelArgs object) {
        object = new PendingStream((LoadBalancer.PickSubchannelArgs)object);
        this.pendingStreams.add((PendingStream)object);
        if (this.getPendingStreamsCount() == 1) {
            this.syncContext.executeLater(this.reportTransportInUse);
        }
        return object;
    }

    @Override
    public final void ping(ClientTransport.PingCallback pingCallback, Executor executor) {
        throw new UnsupportedOperationException("This method is not expected to be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown(final Status status) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownStatus != null) {
                return;
            }
            this.shutdownStatus = status;
            this.syncContext.executeLater(new Runnable(){

                public void run() {
                    DelayedClientTransport.this.listener.transportShutdown(status);
                }
            });
            if (!this.hasPendingStreams() && this.reportTransportTerminated != null) {
                this.syncContext.executeLater(this.reportTransportTerminated);
                this.reportTransportTerminated = null;
            }
        }
        this.syncContext.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdownNow(Status status) {
        Runnable runnable;
        Object object;
        this.shutdown(status);
        Iterator<PendingStream> iterator = this.lock;
        synchronized (iterator) {
            object = this.pendingStreams;
            runnable = this.reportTransportTerminated;
            this.reportTransportTerminated = null;
            if (!this.pendingStreams.isEmpty()) {
                this.pendingStreams = Collections.emptyList();
            }
        }
        if (runnable != null) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                ((PendingStream)object).cancel(status);
            }
            this.syncContext.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasPendingStreams() {
        Object object = this.lock;
        synchronized (object) {
            return !this.pendingStreams.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getPendingStreamsCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reprocess(LoadBalancer.SubchannelPicker subchannelPicker) {
        Object object;
        ArrayList<PendingStream> arrayList = this.lock;
        synchronized (arrayList) {
            this.lastPicker = subchannelPicker;
            ++this.lastPickerVersion;
            if (subchannelPicker == null || !this.hasPendingStreams()) {
                return;
            }
            object = new ArrayList<PendingStream>(this.pendingStreams);
        }
        arrayList = new ArrayList<PendingStream>();
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            final PendingStream pendingStream = (PendingStream)object.next();
            Object object2 = subchannelPicker.pickSubchannel(pendingStream.args);
            CallOptions callOptions = pendingStream.args.getCallOptions();
            if ((object2 = GrpcUtil.getTransportFromPickResult((LoadBalancer.PickResult)object2, callOptions.isWaitForReady())) == null) continue;
            Executor executor = this.defaultAppExecutor;
            if (callOptions.getExecutor() != null) {
                executor = callOptions.getExecutor();
            }
            executor.execute(new Runnable((ClientTransport)object2){
                final /* synthetic */ ClientTransport val$transport;
                {
                    this.val$transport = clientTransport;
                }

                public void run() {
                    pendingStream.createRealStream(this.val$transport);
                }
            });
            arrayList.add(pendingStream);
        }
        object = this.lock;
        synchronized (object) {
            if (!this.hasPendingStreams()) {
                return;
            }
            this.pendingStreams.removeAll(arrayList);
            if (this.pendingStreams.isEmpty()) {
                this.pendingStreams = new LinkedHashSet<PendingStream>();
            }
            if (!this.hasPendingStreams()) {
                this.syncContext.executeLater(this.reportTransportNotInUse);
                if (this.shutdownStatus != null && this.reportTransportTerminated != null) {
                    this.syncContext.executeLater(this.reportTransportTerminated);
                    this.reportTransportTerminated = null;
                }
            }
        }
        this.syncContext.drain();
    }

    @Override
    public final InternalLogId getLogId() {
        return this.logId;
    }

    private class PendingStream
    extends DelayedStream {
        private final LoadBalancer.PickSubchannelArgs args;
        private final Context context = Context.current();

        private PendingStream(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
            this.args = pickSubchannelArgs;
        }

        private void createRealStream(ClientTransport object) {
            Context context = this.context.attach();
            try {
                object = object.newStream(this.args.getMethodDescriptor(), this.args.getHeaders(), this.args.getCallOptions());
            }
            finally {
                this.context.detach(context);
            }
            this.setStream((ClientStream)object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Status object) {
            super.cancel((Status)object);
            object = DelayedClientTransport.this.lock;
            synchronized (object) {
                if (DelayedClientTransport.this.reportTransportTerminated != null) {
                    boolean bl = DelayedClientTransport.this.pendingStreams.remove(this);
                    if (!DelayedClientTransport.this.hasPendingStreams() && bl) {
                        DelayedClientTransport.this.syncContext.executeLater(DelayedClientTransport.this.reportTransportNotInUse);
                        if (DelayedClientTransport.this.shutdownStatus != null) {
                            DelayedClientTransport.this.syncContext.executeLater(DelayedClientTransport.this.reportTransportTerminated);
                            DelayedClientTransport.this.reportTransportTerminated = null;
                        }
                    }
                }
            }
            DelayedClientTransport.this.syncContext.drain();
        }
    }
}

