/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Decompressor;
import com.appoptics.ext.io.grpc.internal.ApplicationThreadDeframerListener;
import com.appoptics.ext.io.grpc.internal.Deframer;
import com.appoptics.ext.io.grpc.internal.MessageDeframer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffer;
import com.appoptics.ext.io.grpc.internal.SquelchLateMessagesAvailableDeframerListener;
import com.appoptics.ext.io.grpc.internal.StreamListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class ApplicationThreadDeframer
implements Deframer {
    private final MessageDeframer.Listener storedListener;
    private final ApplicationThreadDeframerListener appListener;
    private final MessageDeframer deframer;

    ApplicationThreadDeframer(MessageDeframer.Listener listener, TransportExecutor transportExecutor, MessageDeframer messageDeframer) {
        this.storedListener = new SquelchLateMessagesAvailableDeframerListener(b.a(listener, (Object)"listener"));
        this.appListener = new ApplicationThreadDeframerListener(this.storedListener, transportExecutor);
        messageDeframer.setListener(this.appListener);
        this.deframer = messageDeframer;
    }

    public void setMaxInboundMessageSize(int n2) {
        this.deframer.setMaxInboundMessageSize(n2);
    }

    public void setDecompressor(Decompressor decompressor) {
        this.deframer.setDecompressor(decompressor);
    }

    public void request(final int n2) {
        this.storedListener.messagesAvailable(new InitializingMessageProducer(new Runnable(){

            public void run() {
                if (ApplicationThreadDeframer.this.deframer.isClosed()) {
                    return;
                }
                try {
                    ApplicationThreadDeframer.this.deframer.request(n2);
                    return;
                }
                catch (Throwable throwable) {
                    ApplicationThreadDeframer.this.appListener.deframeFailed(throwable);
                    ApplicationThreadDeframer.this.deframer.close();
                    return;
                }
            }
        }));
    }

    public void deframe(final ReadableBuffer readableBuffer) {
        this.storedListener.messagesAvailable(new CloseableInitializingMessageProducer(new Runnable(){

            public void run() {
                try {
                    ApplicationThreadDeframer.this.deframer.deframe(readableBuffer);
                    return;
                }
                catch (Throwable throwable) {
                    ApplicationThreadDeframer.this.appListener.deframeFailed(throwable);
                    ApplicationThreadDeframer.this.deframer.close();
                    return;
                }
            }
        }, new Closeable(){

            public void close() {
                readableBuffer.close();
            }
        }));
    }

    public void closeWhenComplete() {
        this.storedListener.messagesAvailable(new InitializingMessageProducer(new Runnable(){

            public void run() {
                ApplicationThreadDeframer.this.deframer.closeWhenComplete();
            }
        }));
    }

    public void close() {
        this.deframer.stopDelivery();
        this.storedListener.messagesAvailable(new InitializingMessageProducer(new Runnable(){

            public void run() {
                ApplicationThreadDeframer.this.deframer.close();
            }
        }));
    }

    private class CloseableInitializingMessageProducer
    extends InitializingMessageProducer
    implements Closeable {
        private final Closeable closeable;

        public CloseableInitializingMessageProducer(Runnable runnable, Closeable closeable) {
            super(runnable);
            this.closeable = closeable;
        }

        public void close() throws IOException {
            this.closeable.close();
        }
    }

    private class InitializingMessageProducer
    implements StreamListener.MessageProducer {
        private final Runnable runnable;
        private boolean initialized = false;

        private InitializingMessageProducer(Runnable runnable) {
            this.runnable = runnable;
        }

        private void initialize() {
            if (!this.initialized) {
                this.runnable.run();
                this.initialized = true;
            }
        }

        public InputStream next() {
            this.initialize();
            return ApplicationThreadDeframer.this.appListener.messageReadQueuePoll();
        }
    }

    static interface TransportExecutor
    extends ApplicationThreadDeframerListener.TransportExecutor {
    }
}

