/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.a.c;
import com.appoptics.ext.io.grpc.Codec;
import com.appoptics.ext.io.grpc.Compressor;
import com.appoptics.ext.io.grpc.Decompressor;
import com.appoptics.ext.io.grpc.internal.ApplicationThreadDeframer;
import com.appoptics.ext.io.grpc.internal.Deframer;
import com.appoptics.ext.io.grpc.internal.Framer;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.GzipInflatingBuffer;
import com.appoptics.ext.io.grpc.internal.MessageDeframer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffer;
import com.appoptics.ext.io.grpc.internal.StatsTraceContext;
import com.appoptics.ext.io.grpc.internal.Stream;
import com.appoptics.ext.io.grpc.internal.StreamListener;
import com.appoptics.ext.io.grpc.internal.ThreadOptimizedDeframer;
import com.appoptics.ext.io.grpc.internal.TransportTracer;
import java.io.InputStream;

public abstract class AbstractStream
implements Stream {
    protected abstract Framer framer();

    protected abstract TransportState transportState();

    public void optimizeForDirectExecutor() {
        this.transportState().optimizeForDirectExecutor();
    }

    public final void request(int n2) {
        this.transportState().requestMessagesFromDeframer(n2);
    }

    public final void writeMessage(InputStream inputStream) {
        b.a(inputStream, (Object)"message");
        try {
            if (!this.framer().isClosed()) {
                this.framer().writePayload(inputStream);
            }
            return;
        }
        finally {
            GrpcUtil.closeQuietly(inputStream);
        }
    }

    public final void flush() {
        if (!this.framer().isClosed()) {
            this.framer().flush();
        }
    }

    protected final void endOfMessages() {
        this.framer().close();
    }

    public final void setCompressor(Compressor compressor) {
        this.framer().setCompressor(b.a(compressor, (Object)"compressor"));
    }

    protected final void onSendingBytes(int n2) {
        this.transportState().onSendingBytes(n2);
    }

    public static abstract class TransportState
    implements ApplicationThreadDeframer.TransportExecutor,
    MessageDeframer.Listener {
        private Deframer deframer;
        private final Object onReadyLock = new Object();
        private final StatsTraceContext statsTraceCtx;
        private final TransportTracer transportTracer;
        private final MessageDeframer rawDeframer;
        private int numSentBytesQueued;
        private boolean allocated;
        private boolean deallocated;

        protected TransportState(int n2, StatsTraceContext statsTraceContext, TransportTracer transportTracer) {
            this.statsTraceCtx = b.a(statsTraceContext, (Object)"statsTraceCtx");
            this.transportTracer = b.a(transportTracer, (Object)"transportTracer");
            this.rawDeframer = new MessageDeframer(this, Codec.Identity.NONE, n2, statsTraceContext, transportTracer);
            this.deframer = this.rawDeframer;
        }

        final void optimizeForDirectExecutor() {
            this.rawDeframer.setListener(this);
            this.deframer = this.rawDeframer;
        }

        protected void setFullStreamDecompressor(GzipInflatingBuffer gzipInflatingBuffer) {
            this.rawDeframer.setFullStreamDecompressor(gzipInflatingBuffer);
            TransportState transportState = this;
            this.deframer = new ApplicationThreadDeframer(transportState, transportState, this.rawDeframer);
        }

        final void setMaxInboundMessageSize(int n2) {
            this.deframer.setMaxInboundMessageSize(n2);
        }

        protected abstract StreamListener listener();

        public void messagesAvailable(StreamListener.MessageProducer messageProducer) {
            this.listener().messagesAvailable(messageProducer);
        }

        protected final void closeDeframer(boolean bl) {
            if (bl) {
                this.deframer.close();
                return;
            }
            this.deframer.closeWhenComplete();
        }

        protected final void deframe(ReadableBuffer readableBuffer) {
            try {
                this.deframer.deframe(readableBuffer);
                return;
            }
            catch (Throwable throwable) {
                this.deframeFailed(throwable);
                return;
            }
        }

        private void requestMessagesFromDeframer(final int n2) {
            if (this.deframer instanceof ThreadOptimizedDeframer) {
                c.a("AbstractStream.request");
                try {
                    this.deframer.request(n2);
                    return;
                }
                finally {
                    c.b("AbstractStream.request");
                }
            }
            final b b2 = c.b();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class RequestRunnable
            implements Runnable {
                RequestRunnable() {
                }

                @Override
                public void run() {
                    c.a("AbstractStream.request");
                    c.a(b2);
                    try {
                        TransportState.this.deframer.request(n2);
                        return;
                    }
                    catch (Throwable throwable) {
                        TransportState.this.deframeFailed(throwable);
                        return;
                    }
                    finally {
                        c.b("AbstractStream.request");
                    }
                }
            }
            this.runOnTransportThread(new RequestRunnable());
        }

        public final StatsTraceContext getStatsTraceContext() {
            return this.statsTraceCtx;
        }

        protected final void setDecompressor(Decompressor decompressor) {
            this.deframer.setDecompressor(decompressor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReady() {
            Object object = this.onReadyLock;
            synchronized (object) {
                return this.allocated && this.numSentBytesQueued < 32768 && !this.deallocated;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onStreamAllocated() {
            b.b(this.listener() != null);
            Object object = this.onReadyLock;
            synchronized (object) {
                b.b(!this.allocated, "Already allocated");
                this.allocated = true;
            }
            this.notifyIfReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void onStreamDeallocated() {
            Object object = this.onReadyLock;
            synchronized (object) {
                this.deallocated = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onSendingBytes(int n2) {
            Object object = this.onReadyLock;
            synchronized (object) {
                this.numSentBytesQueued += n2;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSentBytes(int n2) {
            Object object = this.onReadyLock;
            synchronized (object) {
                b.b(this.allocated, "onStreamAllocated was not called, but it seems the stream is active");
                boolean bl = this.numSentBytesQueued < 32768;
                this.numSentBytesQueued -= n2;
                n2 = this.numSentBytesQueued < 32768 ? 1 : 0;
                n2 = !bl && n2 != 0 ? 1 : 0;
            }
            if (n2 != 0) {
                this.notifyIfReady();
            }
        }

        protected TransportTracer getTransportTracer() {
            return this.transportTracer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIfReady() {
            boolean bl;
            Object object = this.onReadyLock;
            synchronized (object) {
                bl = this.isReady();
            }
            if (bl) {
                this.listener().onReady();
            }
        }
    }
}

