/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.Codec;
import com.appoptics.ext.io.grpc.Compressor;
import com.appoptics.ext.io.grpc.Deadline;
import com.appoptics.ext.io.grpc.Decompressor;
import com.appoptics.ext.io.grpc.DecompressorRegistry;
import com.appoptics.ext.io.grpc.Grpc;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.AbstractStream;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientStreamListener;
import com.appoptics.ext.io.grpc.internal.Framer;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.GzipInflatingBuffer;
import com.appoptics.ext.io.grpc.internal.InsightBuilder;
import com.appoptics.ext.io.grpc.internal.MessageFramer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffer;
import com.appoptics.ext.io.grpc.internal.StatsTraceContext;
import com.appoptics.ext.io.grpc.internal.TransportTracer;
import com.appoptics.ext.io.grpc.internal.WritableBuffer;
import com.appoptics.ext.io.grpc.internal.WritableBufferAllocator;
import com.tracelytics.a.d.a.d.b;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractClientStream
extends AbstractStream
implements ClientStream,
MessageFramer.Sink {
    private static final Logger log = Logger.getLogger(AbstractClientStream.class.getName());
    private final TransportTracer transportTracer;
    private final Framer framer;
    private boolean shouldBeCountedForInUse;
    private boolean useGet;
    private Metadata headers;
    private volatile boolean cancelled;

    protected AbstractClientStream(WritableBufferAllocator writableBufferAllocator, StatsTraceContext statsTraceContext, TransportTracer transportTracer, Metadata metadata, CallOptions callOptions, boolean bl) {
        com.appoptics.ext.io.a.b.a(metadata, (Object)"headers");
        this.transportTracer = com.appoptics.ext.io.a.b.a(transportTracer, (Object)"transportTracer");
        this.shouldBeCountedForInUse = GrpcUtil.shouldBeCountedForInUse(callOptions);
        this.useGet = bl;
        if (!bl) {
            this.framer = new MessageFramer(this, writableBufferAllocator, statsTraceContext);
            this.headers = metadata;
            return;
        }
        this.framer = new GetFramer(metadata, statsTraceContext);
    }

    public void setDeadline(Deadline deadline) {
        this.headers.discardAll(GrpcUtil.TIMEOUT_KEY);
        long l2 = Math.max(0L, deadline.timeRemaining(TimeUnit.NANOSECONDS));
        this.headers.put(GrpcUtil.TIMEOUT_KEY, l2);
    }

    public void setMaxOutboundMessageSize(int n2) {
        this.framer.setMaxOutboundMessageSize(n2);
    }

    public void setMaxInboundMessageSize(int n2) {
        this.transportState().setMaxInboundMessageSize(n2);
    }

    public final void setFullStreamDecompression(boolean bl) {
        this.transportState().setFullStreamDecompression(bl);
    }

    public final void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
        this.transportState().setDecompressorRegistry(decompressorRegistry);
    }

    protected abstract TransportState transportState();

    public final void start(ClientStreamListener clientStreamListener) {
        this.transportState().setListener(clientStreamListener);
        if (!this.useGet) {
            this.abstractClientStreamSink().writeHeaders(this.headers, null);
            this.headers = null;
        }
    }

    protected abstract Sink abstractClientStreamSink();

    protected final Framer framer() {
        return this.framer;
    }

    public final boolean shouldBeCountedForInUse() {
        return this.shouldBeCountedForInUse;
    }

    public final void deliverFrame(WritableBuffer writableBuffer, boolean bl, boolean bl2, int n2) {
        com.appoptics.ext.io.a.b.a(writableBuffer != null || bl, (Object)"null frame before EOS");
        this.abstractClientStreamSink().writeFrame(writableBuffer, bl, bl2, n2);
    }

    public final void halfClose() {
        if (!this.transportState().isOutboundClosed()) {
            this.transportState().setOutboundClosed();
            this.endOfMessages();
        }
    }

    public final void cancel(Status status) {
        com.appoptics.ext.io.a.b.a(!status.isOk(), (Object)"Should not cancel with OK status");
        this.cancelled = true;
        this.abstractClientStreamSink().cancel(status);
    }

    public final void appendTimeoutInsight(InsightBuilder insightBuilder) {
        Attributes attributes = this.getAttributes();
        insightBuilder.appendKeyValue("remote_addr", attributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
    }

    protected TransportTracer getTransportTracer() {
        return this.transportTracer;
    }

    private class GetFramer
    implements Framer {
        private Metadata headers;
        private boolean closed;
        private final StatsTraceContext statsTraceCtx;
        private byte[] payload;

        public GetFramer(Metadata metadata, StatsTraceContext statsTraceContext) {
            this.headers = com.appoptics.ext.io.a.b.a(metadata, (Object)"headers");
            this.statsTraceCtx = com.appoptics.ext.io.a.b.a(statsTraceContext, (Object)"statsTraceCtx");
        }

        public void writePayload(InputStream inputStream) {
            com.appoptics.ext.io.a.b.b(this.payload == null, "writePayload should not be called multiple times");
            try {
                this.payload = b.a(inputStream);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.statsTraceCtx.outboundMessage(0);
            this.statsTraceCtx.outboundMessageSent(0, this.payload.length, this.payload.length);
            this.statsTraceCtx.outboundUncompressedSize(this.payload.length);
            this.statsTraceCtx.outboundWireSize(this.payload.length);
        }

        public void flush() {
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void close() {
            this.closed = true;
            com.appoptics.ext.io.a.b.b(this.payload != null, "Lack of request message. GET request is only supported for unary requests");
            AbstractClientStream.this.abstractClientStreamSink().writeHeaders(this.headers, this.payload);
            this.payload = null;
            this.headers = null;
        }

        public Framer setCompressor(Compressor compressor) {
            return this;
        }

        public void setMaxOutboundMessageSize(int n2) {
        }
    }

    protected static abstract class TransportState
    extends AbstractStream.TransportState {
        private final StatsTraceContext statsTraceCtx;
        private boolean listenerClosed;
        private ClientStreamListener listener;
        private boolean fullStreamDecompression;
        private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
        private boolean deframerClosed = false;
        private Runnable deframerClosedTask;
        private volatile boolean outboundClosed;
        private boolean statusReported;
        private boolean statusReportedIsOk;

        protected TransportState(int n2, StatsTraceContext statsTraceContext, TransportTracer transportTracer) {
            super(n2, statsTraceContext, transportTracer);
            this.statsTraceCtx = com.appoptics.ext.io.a.b.a(statsTraceContext, (Object)"statsTraceCtx");
        }

        private void setFullStreamDecompression(boolean bl) {
            this.fullStreamDecompression = bl;
        }

        private void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
            com.appoptics.ext.io.a.b.b(this.listener == null, "Already called start");
            this.decompressorRegistry = com.appoptics.ext.io.a.b.a(decompressorRegistry, (Object)"decompressorRegistry");
        }

        public final void setListener(ClientStreamListener clientStreamListener) {
            com.appoptics.ext.io.a.b.b(this.listener == null, "Already called setListener");
            this.listener = com.appoptics.ext.io.a.b.a(clientStreamListener, (Object)"listener");
        }

        public void deframerClosed(boolean bl) {
            com.appoptics.ext.io.a.b.b(this.statusReported, "status should have been reported on deframer closed");
            this.deframerClosed = true;
            if (this.statusReportedIsOk && bl) {
                this.transportReportStatus(Status.INTERNAL.withDescription("Encountered end-of-stream mid-frame"), true, new Metadata());
            }
            if (this.deframerClosedTask != null) {
                this.deframerClosedTask.run();
                this.deframerClosedTask = null;
            }
        }

        protected final ClientStreamListener listener() {
            return this.listener;
        }

        private final void setOutboundClosed() {
            this.outboundClosed = true;
        }

        protected final boolean isOutboundClosed() {
            return this.outboundClosed;
        }

        protected void inboundHeadersReceived(Metadata metadata) {
            com.appoptics.ext.io.a.b.b(!this.statusReported, "Received headers on closed stream");
            this.statsTraceCtx.clientInboundHeaders();
            boolean bl = false;
            String string = metadata.get(GrpcUtil.CONTENT_ENCODING_KEY);
            if (this.fullStreamDecompression && string != null) {
                if (string.equalsIgnoreCase("gzip")) {
                    this.setFullStreamDecompressor(new GzipInflatingBuffer());
                    bl = true;
                } else if (!string.equalsIgnoreCase("identity")) {
                    this.deframeFailed(Status.INTERNAL.withDescription(String.format("Can't find full stream decompressor for %s", string)).asRuntimeException());
                    return;
                }
            }
            if ((string = metadata.get(GrpcUtil.MESSAGE_ENCODING_KEY)) != null) {
                Decompressor decompressor = this.decompressorRegistry.lookupDecompressor(string);
                if (decompressor == null) {
                    this.deframeFailed(Status.INTERNAL.withDescription(String.format("Can't find decompressor for %s", string)).asRuntimeException());
                    return;
                }
                if (decompressor != Codec.Identity.NONE) {
                    if (bl) {
                        this.deframeFailed(Status.INTERNAL.withDescription(String.format("Full stream and gRPC message encoding cannot both be set", new Object[0])).asRuntimeException());
                        return;
                    }
                    this.setDecompressor(decompressor);
                }
            }
            this.listener().headersRead(metadata);
        }

        protected void inboundDataReceived(ReadableBuffer readableBuffer) {
            boolean bl;
            block4: {
                com.appoptics.ext.io.a.b.a(readableBuffer, (Object)"frame");
                bl = true;
                try {
                    if (!this.statusReported) break block4;
                    log.log(Level.INFO, "Received data on closed stream");
                    readableBuffer.close();
                    return;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        readableBuffer.close();
                    }
                    throw throwable;
                }
            }
            bl = false;
            this.deframe(readableBuffer);
        }

        protected void inboundTrailersReceived(Metadata metadata, Status status) {
            com.appoptics.ext.io.a.b.a(status, (Object)"status");
            com.appoptics.ext.io.a.b.a(metadata, (Object)"trailers");
            if (this.statusReported) {
                log.log(Level.INFO, "Received trailers on closed stream:\n {1}\n {2}", new Object[]{status, metadata});
                return;
            }
            this.statsTraceCtx.clientInboundTrailers(metadata);
            this.transportReportStatus(status, false, metadata);
        }

        public final void transportReportStatus(Status status, boolean bl, Metadata metadata) {
            this.transportReportStatus(status, ClientStreamListener.RpcProgress.PROCESSED, bl, metadata);
        }

        public final void transportReportStatus(final Status status, final ClientStreamListener.RpcProgress rpcProgress, boolean bl, final Metadata metadata) {
            com.appoptics.ext.io.a.b.a(status, (Object)"status");
            com.appoptics.ext.io.a.b.a(metadata, (Object)"trailers");
            if (this.statusReported && !bl) {
                return;
            }
            this.statusReported = true;
            this.statusReportedIsOk = status.isOk();
            this.onStreamDeallocated();
            if (this.deframerClosed) {
                this.deframerClosedTask = null;
                this.closeListener(status, rpcProgress, metadata);
                return;
            }
            this.deframerClosedTask = new Runnable(){

                public void run() {
                    TransportState.this.closeListener(status, rpcProgress, metadata);
                }
            };
            this.closeDeframer(bl);
        }

        private void closeListener(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata metadata) {
            if (!this.listenerClosed) {
                this.listenerClosed = true;
                this.statsTraceCtx.streamClosed(status);
                this.listener().closed(status, rpcProgress, metadata);
                if (this.getTransportTracer() != null) {
                    this.getTransportTracer().reportStreamClosed(status.isOk());
                }
            }
        }
    }

    protected static interface Sink {
        public void writeHeaders(Metadata var1, byte[] var2);

        public void writeFrame(WritableBuffer var1, boolean var2, boolean var3, int var4);

        public void cancel(Status var1);
    }
}

