/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.EquivalentAddressGroup;
import com.appoptics.ext.io.grpc.ProxyDetector;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.SynchronizationContext;
import com.tracelytics.a.d.a.a.d;
import com.tracelytics.a.d.a.a.g;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public abstract class NameResolver {
    public abstract String getServiceAuthority();

    public void start(final Listener listener) {
        if (listener instanceof Listener2) {
            this.start((Listener2)listener);
            return;
        }
        this.start(new Listener2(){

            public void onError(Status status) {
                listener.onError(status);
            }

            public void onResult(ResolutionResult resolutionResult) {
                listener.onAddresses(resolutionResult.getAddresses(), resolutionResult.getAttributes());
            }
        });
    }

    public void start(Listener2 listener2) {
        this.start((Listener)listener2);
    }

    public abstract void shutdown();

    public void refresh() {
    }

    public static final class ConfigOrError {
        private final Status status;
        private final Object config;

        public static ConfigOrError fromConfig(Object object) {
            return new ConfigOrError(object);
        }

        public static ConfigOrError fromError(Status status) {
            return new ConfigOrError(status);
        }

        private ConfigOrError(Object object) {
            this.config = b.a(object, (Object)"config");
            this.status = null;
        }

        private ConfigOrError(Status status) {
            this.config = null;
            this.status = b.a(status, (Object)"status");
            b.a(!status.isOk(), "cannot use OK status: %s", (Object)status);
        }

        public final Object getConfig() {
            return this.config;
        }

        public final Status getError() {
            return this.status;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (ConfigOrError)object;
            return d.a(this.status, (Object)((ConfigOrError)object).status) && d.a(this.config, ((ConfigOrError)object).config);
        }

        public final int hashCode() {
            Object[] objectArray = new Object[]{this.status, this.config};
            return Arrays.hashCode(objectArray);
        }

        public final String toString() {
            if (this.config != null) {
                return g.a(this).a("config", this.config).toString();
            }
            assert (this.status != null);
            return g.a(this).a("error", this.status).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ResolutionResult {
        private final List<EquivalentAddressGroup> addresses;
        private final Attributes attributes;
        private final ConfigOrError serviceConfig;

        ResolutionResult(List<EquivalentAddressGroup> list, Attributes attributes, ConfigOrError configOrError) {
            this.addresses = Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(list));
            this.attributes = b.a(attributes, (Object)"attributes");
            this.serviceConfig = configOrError;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public final List<EquivalentAddressGroup> getAddresses() {
            return this.addresses;
        }

        public final Attributes getAttributes() {
            return this.attributes;
        }

        public final ConfigOrError getServiceConfig() {
            return this.serviceConfig;
        }

        public final String toString() {
            return g.a(this).a("addresses", this.addresses).a("attributes", this.attributes).a("serviceConfig", this.serviceConfig).toString();
        }

        public final boolean equals(Object object) {
            if (!(object instanceof ResolutionResult)) {
                return false;
            }
            object = (ResolutionResult)object;
            return d.a(this.addresses, ((ResolutionResult)object).addresses) && d.a(this.attributes, (Object)((ResolutionResult)object).attributes) && d.a(this.serviceConfig, (Object)((ResolutionResult)object).serviceConfig);
        }

        public final int hashCode() {
            Object[] objectArray = new Object[]{this.addresses, this.attributes, this.serviceConfig};
            return Arrays.hashCode(objectArray);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Builder {
            private List<EquivalentAddressGroup> addresses = Collections.emptyList();
            private Attributes attributes = Attributes.EMPTY;
            private ConfigOrError serviceConfig;

            Builder() {
            }

            public final Builder setAddresses(List<EquivalentAddressGroup> list) {
                this.addresses = list;
                return this;
            }

            public final Builder setAttributes(Attributes attributes) {
                this.attributes = attributes;
                return this;
            }

            public final Builder setServiceConfig(ConfigOrError configOrError) {
                this.serviceConfig = configOrError;
                return this;
            }

            public final ResolutionResult build() {
                return new ResolutionResult(this.addresses, this.attributes, this.serviceConfig);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ServiceConfigParser {
        public abstract ConfigOrError parseServiceConfig(Map<String, ?> var1);
    }

    public static final class Args {
        private final int defaultPort;
        private final ProxyDetector proxyDetector;
        private final SynchronizationContext syncContext;
        private final ServiceConfigParser serviceConfigParser;
        private final ScheduledExecutorService scheduledExecutorService;
        private final ChannelLogger channelLogger;
        private final Executor executor;

        private Args(Integer n2, ProxyDetector proxyDetector, SynchronizationContext synchronizationContext, ServiceConfigParser serviceConfigParser, ScheduledExecutorService scheduledExecutorService, ChannelLogger channelLogger, Executor executor) {
            this.defaultPort = b.a(n2, (Object)"defaultPort not set");
            this.proxyDetector = b.a(proxyDetector, (Object)"proxyDetector not set");
            this.syncContext = b.a(synchronizationContext, (Object)"syncContext not set");
            this.serviceConfigParser = b.a(serviceConfigParser, (Object)"serviceConfigParser not set");
            this.scheduledExecutorService = scheduledExecutorService;
            this.channelLogger = channelLogger;
            this.executor = executor;
        }

        public final int getDefaultPort() {
            return this.defaultPort;
        }

        public final ProxyDetector getProxyDetector() {
            return this.proxyDetector;
        }

        public final SynchronizationContext getSynchronizationContext() {
            return this.syncContext;
        }

        public final ServiceConfigParser getServiceConfigParser() {
            return this.serviceConfigParser;
        }

        public final Executor getOffloadExecutor() {
            return this.executor;
        }

        public final String toString() {
            return g.a(this).a("defaultPort", this.defaultPort).a("proxyDetector", this.proxyDetector).a("syncContext", this.syncContext).a("serviceConfigParser", this.serviceConfigParser).a("scheduledExecutorService", this.scheduledExecutorService).a("channelLogger", this.channelLogger).a("executor", this.executor).toString();
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private Integer defaultPort;
            private ProxyDetector proxyDetector;
            private SynchronizationContext syncContext;
            private ServiceConfigParser serviceConfigParser;
            private ScheduledExecutorService scheduledExecutorService;
            private ChannelLogger channelLogger;
            private Executor executor;

            Builder() {
            }

            public final Builder setDefaultPort(int n2) {
                this.defaultPort = n2;
                return this;
            }

            public final Builder setProxyDetector(ProxyDetector proxyDetector) {
                this.proxyDetector = b.a(proxyDetector);
                return this;
            }

            public final Builder setSynchronizationContext(SynchronizationContext synchronizationContext) {
                this.syncContext = b.a(synchronizationContext);
                return this;
            }

            public final Builder setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
                this.scheduledExecutorService = b.a(scheduledExecutorService);
                return this;
            }

            public final Builder setServiceConfigParser(ServiceConfigParser serviceConfigParser) {
                this.serviceConfigParser = b.a(serviceConfigParser);
                return this;
            }

            public final Builder setChannelLogger(ChannelLogger channelLogger) {
                this.channelLogger = b.a(channelLogger);
                return this;
            }

            public final Builder setOffloadExecutor(Executor executor) {
                this.executor = executor;
                return this;
            }

            public final Args build() {
                return new Args(this.defaultPort, this.proxyDetector, this.syncContext, this.serviceConfigParser, this.scheduledExecutorService, this.channelLogger, this.executor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static abstract class Helper {
        public abstract int getDefaultPort();

        public abstract ProxyDetector getProxyDetector();

        public SynchronizationContext getSynchronizationContext() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ConfigOrError parseServiceConfig(Map<String, ?> map) {
            throw new UnsupportedOperationException("should have been implemented");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Listener2
    implements Listener {
        @Override
        @Deprecated
        public final void onAddresses(List<EquivalentAddressGroup> list, Attributes attributes) {
            this.onResult(ResolutionResult.newBuilder().setAddresses(list).setAttributes(attributes).build());
        }

        public abstract void onResult(ResolutionResult var1);

        @Override
        public abstract void onError(Status var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public void onAddresses(List<EquivalentAddressGroup> var1, Attributes var2);

        public void onError(Status var1);
    }

    public static abstract class Factory {
        @Deprecated
        public static final Attributes.Key<Integer> PARAMS_DEFAULT_PORT = Attributes.Key.create("params-default-port");
        @Deprecated
        public static final Attributes.Key<ProxyDetector> PARAMS_PROXY_DETECTOR = Attributes.Key.create("params-proxy-detector");
        @Deprecated
        private static final Attributes.Key<SynchronizationContext> PARAMS_SYNC_CONTEXT = Attributes.Key.create("params-sync-context");
        @Deprecated
        private static final Attributes.Key<ServiceConfigParser> PARAMS_PARSER = Attributes.Key.create("params-parser");

        @Deprecated
        public NameResolver newNameResolver(URI uRI, Attributes object) {
            object = Args.newBuilder().setDefaultPort(((Attributes)object).get(PARAMS_DEFAULT_PORT)).setProxyDetector(((Attributes)object).get(PARAMS_PROXY_DETECTOR)).setSynchronizationContext(((Attributes)object).get(PARAMS_SYNC_CONTEXT)).setServiceConfigParser(((Attributes)object).get(PARAMS_PARSER)).build();
            return this.newNameResolver(uRI, (Args)object);
        }

        @Deprecated
        public NameResolver newNameResolver(URI uRI, final Helper helper) {
            return this.newNameResolver(uRI, Attributes.newBuilder().set(PARAMS_DEFAULT_PORT, helper.getDefaultPort()).set(PARAMS_PROXY_DETECTOR, helper.getProxyDetector()).set(PARAMS_SYNC_CONTEXT, helper.getSynchronizationContext()).set(PARAMS_PARSER, new ServiceConfigParser(){

                @Override
                public ConfigOrError parseServiceConfig(Map<String, ?> map) {
                    return helper.parseServiceConfig(map);
                }
            }).build());
        }

        public NameResolver newNameResolver(URI uRI, final Args args) {
            return this.newNameResolver(uRI, new Helper(){

                @Override
                public int getDefaultPort() {
                    return args.getDefaultPort();
                }

                @Override
                public ProxyDetector getProxyDetector() {
                    return args.getProxyDetector();
                }

                @Override
                public SynchronizationContext getSynchronizationContext() {
                    return args.getSynchronizationContext();
                }

                @Override
                public ConfigOrError parseServiceConfig(Map<String, ?> map) {
                    return args.getServiceConfigParser().parseServiceConfig(map);
                }
            });
        }

        public abstract String getDefaultScheme();
    }
}

